/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.engines.blind.ParamBlind;
import org.eclipse.actf.visualization.eval.html.HtmlTagUtil;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.DocumentCleaner;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapDataImpl;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VisualizeColorUtil {
    private static final double WORD_JP = 0.1598360655737705;
    private Document result;
    private VisualizeMapDataImpl mapData;
    private List<VisualizationNodeInfo> nodeInfoList;
    private Map<Node, Node> linkMap;
    private ParamBlind param;
    private boolean isHTML5;

    public VisualizeColorUtil(Document document, VisualizeMapDataImpl visualizeMapDataImpl, ParamBlind paramBlind, boolean bl) {
        this.result = document;
        this.mapData = visualizeMapDataImpl;
        this.nodeInfoList = visualizeMapDataImpl.getNodeInfoList();
        this.linkMap = visualizeMapDataImpl.getIntraPageLinkMap();
        this.param = paramBlind;
        this.isHTML5 = bl;
    }

    public void setColorAll() {
        int n = 0;
        DocumentCleaner.removeBgcolor(this.result);
        this.initHeadings();
        int n2 = 0;
        while (n2 < 10) {
            n = this.calcWords();
            if (n == 0) break;
            ++n2;
        }
        this.calcTime();
        this.calcOrgTime();
        this.setColor();
    }

    private void setColor() {
        Node node;
        Node node2;
        Object object = "#000000";
        if (this.param.bVisualizeTable) {
            NodeList nodeList = this.result.getElementsByTagName("head");
            try {
                Element object2 = (Element)nodeList.item(0);
                node2 = this.result.createElement("style");
                node2.setAttribute("type", "text/css");
                object = this.getRGBString(this.param.tableBorderColor, "#000000");
                node = this.result.createComment("td {border-width: 1px; border-style: dashed; border-color: " + (String)object + "}");
                node2.appendChild(node);
                object2.appendChild(node2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (VisualizationNodeInfo visualizationNodeInfo : this.nodeInfoList) {
            Object object2;
            node2 = visualizationNodeInfo.getNode();
            node = null;
            if (node2.getNodeType() == 1) {
                node = (Element)node2;
            } else if (node2.getNodeType() == 3) {
                if (node2.getParentNode().getNodeName().equals("textarea")) continue;
                node = this.result.createElement("span");
                node2.getParentNode().insertBefore(node, node2);
                if (visualizationNodeInfo.isInvisible()) {
                    node2.getParentNode().removeChild(node2);
                } else {
                    node.appendChild(node2);
                }
                object2 = this.mapData.getIdOfNode(node2);
                if (object2 != null) {
                    node.setAttribute("id", "id" + ((Integer)object2).toString());
                }
            } else {
                DebugPrintUtil.devOrDebugPrintln((Object)"VisualizeColorUtil: unknown node in the nodeList");
                continue;
            }
            object2 = this.getRGBString(this.param.headingTagsColor, "#33CCFF");
            String string = this.getRGBString(this.param.tableHeaderColor, "#99FF00");
            String string2 = this.getRGBString(this.param.labelTagsColor, "#FFFF00");
            String string3 = this.getRGBString(this.param.inputTagsColor, "#FF9900");
            String string4 = this.getRGBString(this.param.captionColor, "#FFFF80");
            if (this.param.bColorizeTags && (visualizationNodeInfo.isHeading() || visualizationNodeInfo.isTableHeader() || visualizationNodeInfo.isLabel() || visualizationNodeInfo.isIdRequiredInput() || visualizationNodeInfo.isCaption())) {
                if (visualizationNodeInfo.isHeading()) {
                    object = object2;
                } else if (visualizationNodeInfo.isTableHeader()) {
                    object = string;
                } else if (visualizationNodeInfo.isIdRequiredInput()) {
                    object = string3;
                } else if (visualizationNodeInfo.isLabel()) {
                    object = string2;
                } else if (visualizationNodeInfo.isCaption()) {
                    object = string4;
                }
                node.setAttribute("style", "color: black; background-image: none; background-color:" + (String)object);
                continue;
            }
            int n = visualizationNodeInfo.getTime();
            if (n == 0) {
                switch (this.param.iLanguage) {
                    case 1: {
                        n = this.calcTimeJp(visualizationNodeInfo.getTotalWords(), visualizationNodeInfo.getTotalLines());
                        break;
                    }
                    default: {
                        n = this.calcTime(visualizationNodeInfo.getTotalWords(), visualizationNodeInfo.getTotalLines());
                    }
                }
                visualizationNodeInfo.setTime(n);
            }
            if (this.param.bVisualizeTime) {
                if ("mark".equals(node.getTagName()) || HtmlTagUtil.hasAncestor((Node)node, (String)"mark")) {
                    node.setAttribute("style", "color: black; background-image: none;");
                    continue;
                }
                node.setAttribute("style", "color: black; background-image: none; background-color: #" + this.calcColor(n, this.param.maxTimeColor, this.param.iMaxTime));
                continue;
            }
            node.setAttribute("style", "color: black; background-image: none; background-color: transparent");
        }
    }

    private String calcColor(int n, RGB rGB, int n2) {
        double d = n;
        double d2 = n2;
        if (n >= n2) {
            Color color = new Color(rGB.red, rGB.green, rGB.blue);
            return Integer.toHexString(color.getRGB()).substring(2);
        }
        int n3 = (int)(255.0 - d / d2 * (255.0 - (double)rGB.red));
        int n4 = (int)(255.0 - d / d2 * (255.0 - (double)rGB.green));
        int n5 = (int)(255.0 - d / d2 * (255.0 - (double)rGB.blue));
        Color color = new Color(n3, n4, n5);
        return Integer.toHexString(color.getRGB()).substring(2);
    }

    private String getRGBString(RGB rGB, String string) {
        if (rGB != null) {
            return "rgb(" + rGB.red + "," + rGB.green + "," + rGB.blue + ")";
        }
        return string;
    }

    private void initHeadings() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.nodeInfoList.size();
        int n6 = 0;
        while (n6 < n5) {
            VisualizationNodeInfo visualizationNodeInfo = this.nodeInfoList.get(n6);
            if (this.isHTML5 && visualizationNodeInfo.isLandmark()) {
                int n7 = this.wordcountForLandmark(++n2);
                if (this.calcTime(n3, n4) >= this.calcTime(n7, 0)) {
                    n3 = n7;
                    n4 = 0;
                }
                visualizationNodeInfo.setTotalWords(n3);
                visualizationNodeInfo.setTotalLines(n4);
                n3 += visualizationNodeInfo.getWords();
                n4 += visualizationNodeInfo.getLines();
            } else if (visualizationNodeInfo.isHeading()) {
                Element element;
                Node node = visualizationNodeInfo.getNode();
                if (node.getNodeName().matches("h[1-6]")) {
                    ++n;
                } else if (node instanceof Element && (element = (Element)node).hasAttribute("role") && "heading".equalsIgnoreCase(element.getAttribute("role"))) {
                    ++n;
                }
                int n8 = this.wordcountForHeading(n);
                if (this.calcTime(n3, n4) >= this.calcTime(n8, 0)) {
                    n3 = n8;
                    n4 = 0;
                }
                visualizationNodeInfo.setTotalWords(n3);
                visualizationNodeInfo.setTotalLines(n4);
                n3 += visualizationNodeInfo.getWords();
                n4 += visualizationNodeInfo.getLines();
            } else if (this.calcTime(visualizationNodeInfo.getTotalWords(), visualizationNodeInfo.getTotalLines()) > this.calcTime(n3, n4)) {
                visualizationNodeInfo.setTotalWords(n3);
                visualizationNodeInfo.setTotalLines(n4);
                n3 += visualizationNodeInfo.getWords();
                n4 += visualizationNodeInfo.getLines();
            } else {
                n3 = visualizationNodeInfo.getTotalWords() + visualizationNodeInfo.getWords();
                n4 = visualizationNodeInfo.getTotalLines() + visualizationNodeInfo.getLines();
            }
            ++n6;
        }
    }

    private void calcTime() {
        int n = this.nodeInfoList.size();
        int n2 = 0;
        while (n2 < n) {
            VisualizationNodeInfo visualizationNodeInfo = this.nodeInfoList.get(n2);
            int n3 = this.calcTime(visualizationNodeInfo.getTotalWords(), visualizationNodeInfo.getTotalLines());
            visualizationNodeInfo.setTime(n3);
            if (visualizationNodeInfo.getNode().getNodeName().matches("h[1-6]")) {
                this.replaceParentInfoTime(visualizationNodeInfo.getNode(), n3);
            }
            ++n2;
        }
    }

    private void calcOrgTime() {
        int n = this.nodeInfoList.size();
        int n2 = 0;
        while (n2 < n) {
            VisualizationNodeInfo visualizationNodeInfo = this.nodeInfoList.get(n2);
            int n3 = this.calcTime(visualizationNodeInfo.getOrgTotalWords(), visualizationNodeInfo.getOrgTotalLines());
            visualizationNodeInfo.setOrgTime(n3);
            ++n2;
        }
    }

    private void replaceParentInfoTime(Node node, int n) {
        if (node != null) {
            Node node2 = node.getParentNode();
            while (node2 != null) {
                if (node2.getFirstChild() != node) break;
                VisualizationNodeInfo visualizationNodeInfo = this.mapData.getNodeInfo(node2);
                if (visualizationNodeInfo != null && visualizationNodeInfo.getTime() > n) {
                    visualizationNodeInfo.setTime(n);
                }
                node = node2;
                node2 = node.getParentNode();
            }
        }
    }

    private void replaceParentInfoWord(Node node, int n, int n2, int n3) {
        if (node != null) {
            Node node2 = node.getParentNode();
            while (node2 != null) {
                if (node2.getFirstChild() != node) break;
                VisualizationNodeInfo visualizationNodeInfo = this.mapData.getNodeInfo(node2);
                if (visualizationNodeInfo != null && this.calcTime(visualizationNodeInfo.getTotalWords(), visualizationNodeInfo.getTotalLines()) > n3) {
                    visualizationNodeInfo.setTotalWords(n);
                    visualizationNodeInfo.setTotalLines(n2);
                }
                node = node2;
                node2 = node.getParentNode();
            }
        }
    }

    private int calcWords() {
        int n = 0;
        Set<Node> set = this.linkMap.keySet();
        block0: for (Node node : set) {
            Node node2 = this.linkMap.get(node);
            Integer n2 = this.mapData.getIdOfNode(node);
            Integer n3 = this.mapData.getIdOfNode(node2);
            if (n2 == null || n3 == null) continue;
            int n4 = n2;
            int n5 = n3;
            VisualizationNodeInfo visualizationNodeInfo = this.nodeInfoList.get(n4);
            if (visualizationNodeInfo.getNode() != node) {
                DebugPrintUtil.devOrDebugPrintln((Object)("from node does not exists: " + n4 + " " + node));
                continue;
            }
            VisualizationNodeInfo visualizationNodeInfo2 = this.nodeInfoList.get(n5);
            if (visualizationNodeInfo2.getNode() != node2) {
                DebugPrintUtil.devOrDebugPrintln((Object)("to node does not exists: " + n5 + " " + node2));
                continue;
            }
            VisualizationNodeInfo visualizationNodeInfo3 = visualizationNodeInfo2;
            int n6 = n5;
            int n7 = visualizationNodeInfo.getTotalWords() + this.getWordcountFor2sec();
            int n8 = visualizationNodeInfo.getTotalLines();
            int n9 = this.calcTime(n7, n8);
            while (this.calcTime(visualizationNodeInfo3.getTotalWords(), visualizationNodeInfo3.getTotalLines()) > n9) {
                ++n;
                visualizationNodeInfo3.setTotalWords(n7);
                visualizationNodeInfo3.setTotalLines(n8);
                this.replaceParentInfoWord(visualizationNodeInfo3.getNode(), n7, n8, n9);
                if (++n6 >= this.nodeInfoList.size()) continue block0;
                visualizationNodeInfo3 = this.nodeInfoList.get(n6);
                n9 = this.calcTime(n7 += visualizationNodeInfo3.getWords(), n8 += visualizationNodeInfo3.getLines());
            }
        }
        return n;
    }

    private int calcTime(int n, int n2) {
        switch (this.param.iLanguage) {
            case 0: {
                return this.calcTimeEn(n, n2);
            }
            case 1: {
                return this.calcTimeJp(n, n2);
            }
        }
        return this.calcTimeEn(n, n2);
    }

    private int calcTimeEn(int n, int n2) {
        return (int)((double)n / 3.0 + (double)n2 * 0.7);
    }

    private int calcTimeJp(int n, int n2) {
        return (int)((double)n * 0.1598360655737705 + (double)n2 * 0.6);
    }

    private int wordcountForLandmark(int n) {
        switch (this.param.iLanguage) {
            case 0: {
                return 3 * n + 9;
            }
            case 1: {
                return (int)Math.round(6.5 * (double)n) + 18;
            }
        }
        return 3 * n + 9;
    }

    private int wordcountForHeading(int n) {
        switch (this.param.iLanguage) {
            case 0: {
                return 6 * n + 9;
            }
            case 1: {
                return 13 * n + 18;
            }
        }
        return 6 * n + 9;
    }

    private int getWordcountFor2sec() {
        switch (this.param.iLanguage) {
            case 0: {
                return 6;
            }
            case 1: {
                return 13;
            }
        }
        return 6;
    }
}

