/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.ui;

import java.io.File;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.IModelServiceScrollManager;
import org.eclipse.actf.model.ui.util.ModelServiceMessages;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class ModelServiceImageCreator {
    public static final int DUMP_IMG_SIZE_LIMIT = 10000000;
    private IModelService modelService;

    public ModelServiceImageCreator(IModelService iModelService) {
        this.modelService = iModelService;
    }

    public File getScreenImageAsBMP(String string, boolean bl) {
        ImageData[] imageDataArray;
        IModelServiceScrollManager iModelServiceScrollManager = this.modelService.getScrollManager();
        int[] nArray = iModelServiceScrollManager.getSize(bl).toArray();
        boolean bl2 = false;
        if (nArray[0] < 1 || nArray[1] < 1) {
            nArray = new int[]{1, 1, 1, 1};
        }
        if (nArray[2] * nArray[3] > 10000000) {
            nArray[3] = 10000000 / nArray[2];
            if (bl) {
                bl2 = true;
            }
        }
        if (bl) {
            switch (iModelServiceScrollManager.getScrollType()) {
                case 0: {
                    imageDataArray = this.getImageByAbsoluteCoordinateScroll(nArray, iModelServiceScrollManager, true);
                    break;
                }
                case 2: {
                    imageDataArray = this.getImageByPageScroll(nArray, iModelServiceScrollManager);
                    break;
                }
                case 1: {
                    imageDataArray = this.getImageByIncrementalScroll(nArray, iModelServiceScrollManager);
                    break;
                }
                default: {
                    bl2 = false;
                    imageDataArray = this.getImageByAbsoluteCoordinateScroll(nArray, iModelServiceScrollManager, false);
                    break;
                }
            }
        } else {
            imageDataArray = this.getImageByAbsoluteCoordinateScroll(nArray, iModelServiceScrollManager, false);
        }
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = imageDataArray;
        imageLoader.save(string, 0);
        if (bl2) {
            MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 34);
            messageBox.setMessage(ModelServiceMessages.ImageCreator_ImageTooLarge);
            messageBox.open();
        }
        return new File(string);
    }

    private ImageData[] getImageByAbsoluteCoordinateScroll(int[] nArray, IModelServiceScrollManager iModelServiceScrollManager, boolean bl) {
        int n;
        int n2;
        int n3;
        Image image = new Image((Device)Display.getDefault(), nArray[0] + 2, nArray[1] + 2);
        ImageData[] imageDataArray = new ImageData[1];
        GC gC = new GC((Drawable)this.modelService.getTargetComposite());
        if (bl) {
            n3 = (nArray[2] + nArray[0] - 1) / nArray[0];
            n2 = (nArray[3] + nArray[1] - 1) / nArray[1];
        } else {
            n3 = 1;
            n2 = 1;
            nArray[2] = nArray[0];
            nArray[3] = nArray[1];
        }
        ImageData[][] imageDataArray2 = new ImageData[n3][n2];
        int n4 = 0;
        while (n4 < n3) {
            n = 0;
            while (n < n2) {
                if (bl) {
                    iModelServiceScrollManager.absoluteCoordinateScroll(n4 * nArray[0], n * nArray[1], true);
                }
                gC.copyArea(image, 0, 0);
                imageDataArray2[n4][n] = image.getImageData();
                ++n;
            }
            ++n4;
        }
        if (bl) {
            iModelServiceScrollManager.absoluteCoordinateScroll(0, 0, false);
        }
        n4 = imageDataArray2[0][0].depth;
        imageDataArray[0] = new ImageData(nArray[2], nArray[3], n4, imageDataArray2[0][0].palette);
        n = (nArray[2] * n4 + 31) / 32 * 4;
        int n5 = ((nArray[0] + 2) * n4 + 31) / 32 * 4;
        n4 /= 8;
        int n6 = imageDataArray[0].data.length;
        if (n2 > 1) {
            int n7 = 0;
            while (n7 < n2) {
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = n7 < n2 - 1 ? 0 : nArray[1] * n2 - nArray[3];
                    int n10 = n8 < n3 - 1 ? 0 : nArray[0] * n3 - nArray[2];
                    n10 += 2;
                    int n11 = n9;
                    while (n11 < nArray[1]) {
                        int n12 = (n7 * nArray[1] + (n11 - n9)) * n + n8 * nArray[0] * n4;
                        int n13 = n5 - n10 * n4;
                        if (n6 < n12 + n13) {
                            n13 = n6 - n12;
                        }
                        System.arraycopy(imageDataArray2[n8][n7].data, (n11 + 2) * n5 + n10 * n4, imageDataArray[0].data, n12, n13);
                        ++n11;
                    }
                    ++n8;
                }
                ++n7;
            }
        } else {
            int n14 = 0;
            while (n14 < n3) {
                int n15 = 0;
                int n16 = n14 < n3 - 1 ? 0 : nArray[0] * n3 - nArray[2];
                n16 += 2;
                int n17 = n15;
                while (n17 < nArray[3]) {
                    int n18 = (n17 - n15) * n + n14 * nArray[0] * n4;
                    int n19 = n5 - n16 * n4;
                    if (n6 < n18 + n19) {
                        n19 = n6 - n18;
                    }
                    System.arraycopy(imageDataArray2[n14][0].data, (n17 + 2) * n5 + n16 * n4, imageDataArray[0].data, n18, n19);
                    ++n17;
                }
                ++n14;
            }
        }
        gC.dispose();
        return imageDataArray;
    }

    private ImageData[] getImageByIncrementalScroll(int[] nArray, IModelServiceScrollManager iModelServiceScrollManager) {
        int n;
        Image image = new Image((Device)Display.getDefault(), nArray[0] + 2, nArray[1] + 2);
        ImageData[] imageDataArray = new ImageData[1];
        GC gC = new GC((Drawable)this.modelService.getTargetComposite());
        int n2 = 1;
        int n3 = 1;
        while (iModelServiceScrollManager.incrementLargeScrollX(false) > 0) {
        }
        while (iModelServiceScrollManager.incrementLargeScrollY(false) > 0) {
        }
        while (iModelServiceScrollManager.decrementLargeScrollX(false) > 0) {
            ++n2;
        }
        while (iModelServiceScrollManager.decrementLargeScrollY(false) > 0) {
            ++n3;
        }
        iModelServiceScrollManager.decrementLargeScrollY(true);
        ImageData[][] imageDataArray2 = new ImageData[n2][n3];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n3];
        int n4 = 0;
        while (n4 < n2) {
            n = 0;
            while (n < n3) {
                gC.copyArea(image, 0, 0);
                imageDataArray2[n4][n] = image.getImageData();
                nArray3[n] = iModelServiceScrollManager.incrementLargeScrollY(true);
                ++n;
            }
            nArray2[n4] = iModelServiceScrollManager.incrementLargeScrollX(true);
            while (iModelServiceScrollManager.decrementLargeScrollY(false) > 0) {
            }
            ++n4;
        }
        n4 = imageDataArray2[0][0].depth;
        imageDataArray[0] = new ImageData(nArray[2], nArray[3], n4, imageDataArray2[0][0].palette);
        n = (nArray[2] * n4 + 31) / 32 * 4;
        int n5 = ((nArray[0] + 2) * n4 + 31) / 32 * 4;
        n4 /= 8;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = imageDataArray[0].data.length;
        int n11 = 0;
        while (n11 < n3) {
            int n12 = n11 == 0 ? 0 : n9 - n7;
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n13 == 0 ? 0 : n8 - n6;
                n14 += 2;
                int n15 = 0;
                while (n15 < nArray[1]) {
                    int n16 = (n9 + (n15 - n12)) * n + n8 * n4;
                    int n17 = n5 - n14 * n4;
                    if (n10 < n16 + n17) {
                        n17 = n10 - n16;
                    }
                    if (n17 > 0) {
                        System.arraycopy(imageDataArray2[n13][n11].data, (n15 + 2) * n5 + n14 * n4, imageDataArray[0].data, n16, n17);
                    }
                    ++n15;
                }
                n6 += nArray2[n13];
                n8 += nArray[0] - n14;
                ++n13;
            }
            n7 += nArray3[n11];
            n9 += nArray[1] - n12;
            ++n11;
        }
        gC.dispose();
        return imageDataArray;
    }

    private ImageData[] getImageByPageScroll(int[] nArray, IModelServiceScrollManager iModelServiceScrollManager) {
        Image image = new Image((Device)Display.getDefault(), nArray[0] + 2, nArray[1] + 2);
        ImageData[] imageDataArray = new ImageData[1];
        GC gC = new GC((Drawable)this.modelService.getTargetComposite());
        int n = 1;
        n = iModelServiceScrollManager.getLastPageNumber();
        if (n < 1) {
            n = 1;
        }
        iModelServiceScrollManager.jumpToPage(1, true);
        ImageData[] imageDataArray2 = new ImageData[n];
        int n2 = 0;
        while (n2 < n) {
            gC.copyArea(image, 0, 0);
            imageDataArray2[n2] = image.getImageData();
            iModelServiceScrollManager.incrementPageScroll(true);
            ++n2;
        }
        iModelServiceScrollManager.jumpToPage(1, false);
        n2 = imageDataArray2[0].depth;
        imageDataArray[0] = new ImageData(nArray[2], nArray[3], n2, imageDataArray2[0].palette);
        int n3 = (nArray[2] * n2 + 31) / 32 * 4;
        int n4 = ((nArray[0] + 2) * n2 + 31) / 32 * 4;
        n2 /= 8;
        int n5 = imageDataArray[0].data.length;
        int n6 = 0;
        while (n6 < n) {
            int n7 = 0;
            while (n7 < nArray[1]) {
                int n8 = (nArray[1] * n6 + n7) * n3;
                int n9 = n4;
                if (n5 < n8 + n9) {
                    n9 = n5 - n8;
                }
                if (n9 > 0) {
                    System.arraycopy(imageDataArray2[n6].data, (n7 + 2) * n4, imageDataArray[0].data, n8, n9);
                }
                ++n7;
            }
            ++n6;
        }
        gC.dispose();
        return imageDataArray;
    }
}

