/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.eval.guideline;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.actf.visualization.eval.IGuidelineItem;
import org.eclipse.actf.visualization.eval.ITechniquesItem;
import org.eclipse.actf.visualization.internal.eval.GuidelineItemImpl;
import org.eclipse.actf.visualization.internal.eval.TechniquesItemImpl;
import org.eclipse.actf.visualization.internal.eval.guideline.GuidelineData;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class GuidelineItemReader
extends DefaultHandler {
    private static final String GUIDELINE = "guideline";
    private static final String MIMETYPES = "mimetypes";
    private static final String MIMETYPE = "mimetype";
    private static final String ITEMS = "items";
    private static final String GITEM = "gItem";
    private static final String TECHNIQUES = "techniques";
    private static final String TECHNIQUE = "technique";
    private static final String LEVELS = "levels";
    private static final String LEVEL = "level";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String HELP_URL = "helpUrl";
    private static final String ORDER = "order";
    private static final String DESCRIPTION = "description";
    private static final String CATEGORY = "category";
    private static final short IN_GUIDELINE = 0;
    private static final short IN_LEVELS = 1;
    private static final short IN_ITEMS = 2;
    private static final short IN_ITEM = 3;
    private static final short IN_MIMETYPES = 4;
    private static final short IN_LEVEL = 5;
    private static final short IN_TECHNIQUES = 6;
    private static final short IN_TECHNIQUE = 7;
    private Vector<String> levelsV = new Vector();
    private Vector<String> descriptionsV = new Vector();
    private Vector<String> categoriesV = new Vector();
    private Vector<String> mimeV = new Vector();
    private GuidelineItemImpl curItem = new GuidelineItemImpl("");
    private TechniquesItemImpl curTech = new TechniquesItemImpl();
    private Stack<Short> statusStack = new Stack();
    private String curValue;
    private HashMap<String, IGuidelineItem> itemMap;
    private HashMap<String, ITechniquesItem> techMap;
    private String guidelineName;
    private int order;
    private String[] levels = new String[0];
    private String[] descriptions = new String[0];
    private String[] categories = new String[0];
    private String description = "";
    private String category = "";
    private String[] mimetypes = new String[0];
    private short status = 0;
    private boolean succeed = false;

    public static GuidelineData getGuidelineData(InputStream inputStream) {
        GuidelineItemReader guidelineItemReader = new GuidelineItemReader();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)guidelineItemReader);
        }
        catch (Exception exception) {}
        if (guidelineItemReader.isSucceed() && guidelineItemReader.guidelineName.length() > 0) {
            return new GuidelineData(guidelineItemReader.guidelineName, guidelineItemReader.order, guidelineItemReader.category, guidelineItemReader.description, guidelineItemReader.levels, guidelineItemReader.categories, guidelineItemReader.descriptions, guidelineItemReader.mimetypes, guidelineItemReader.itemMap, guidelineItemReader.techMap);
        }
        return null;
    }

    public GuidelineItemReader() {
        this.itemMap = new HashMap();
        this.techMap = new HashMap();
    }

    public void characters(char[] cArray, int n, int n2) {
        if (n2 > 0) {
            this.curValue = String.valueOf(this.curValue) + new String(cArray, n, n2);
        }
    }

    public void endDocument() {
        this.levels = new String[this.levelsV.size()];
        this.levelsV.toArray(this.levels);
        this.categories = new String[this.categoriesV.size()];
        this.categoriesV.toArray(this.categories);
        this.descriptions = new String[this.descriptionsV.size()];
        this.descriptionsV.toArray(this.descriptions);
        this.mimetypes = new String[this.mimeV.size()];
        this.mimeV.toArray(this.mimetypes);
        this.succeed = true;
    }

    private String getLocalGuidelineURL(String string) {
        if (string.startsWith("${")) {
            int n = string.indexOf("}");
            if (n == -1) {
                return null;
            }
            String string2 = string.substring(2, n);
            String string3 = "/" + string2 + "/" + string.substring(n + 2);
            return PlatformUI.getWorkbench().getHelpSystem().resolve(string3, true).toString();
        }
        return null;
    }

    public void endElement(String string, String string2, String string3) {
        if (string3.equalsIgnoreCase(GITEM)) {
            this.itemMap.put(this.curItem.getId(), this.curItem);
            if (!this.statusStack.isEmpty()) {
                this.status = this.statusStack.pop();
            }
        } else if (string3.equalsIgnoreCase(TECHNIQUE)) {
            this.techMap.put(this.curTech.getId(), this.curTech);
            if (!this.statusStack.isEmpty()) {
                this.status = this.statusStack.pop();
            }
        } else if (string3.equalsIgnoreCase(HELP_URL)) {
            String string4 = this.getLocalGuidelineURL(this.curValue);
            switch (this.status) {
                case 3: {
                    if (string4 != null) {
                        this.curItem.setUrl(string4);
                        break;
                    }
                    this.curItem.setUrl(this.curValue);
                    break;
                }
                case 7: {
                    if (string4 != null) {
                        this.curTech.setUrl(string4);
                        break;
                    }
                    this.curTech.setUrl(this.curValue);
                }
            }
        } else if (string3.equalsIgnoreCase(DESCRIPTION)) {
            switch (this.status) {
                case 5: {
                    this.descriptionsV.add(this.curValue);
                    break;
                }
                case 0: {
                    this.description = this.curValue;
                }
            }
        } else if (string3.equalsIgnoreCase(CATEGORY)) {
            switch (this.status) {
                case 5: {
                    this.categoriesV.add(this.curValue);
                    break;
                }
                case 0: {
                    this.category = this.curValue;
                }
            }
        } else if (!string3.equalsIgnoreCase(GUIDELINE)) {
            if (string3.equalsIgnoreCase(MIMETYPES) || string3.equalsIgnoreCase(ITEMS) || string3.equalsIgnoreCase(TECHNIQUES) || string3.equalsIgnoreCase(LEVELS)) {
                if (!this.statusStack.isEmpty()) {
                    this.status = this.statusStack.pop();
                }
            } else if (string3.equalsIgnoreCase(MIMETYPE)) {
                switch (this.status) {
                    case 4: {
                        this.mimeV.add(this.curValue);
                    }
                }
            } else if (string3.equalsIgnoreCase(LEVEL)) {
                if (!this.statusStack.isEmpty()) {
                    this.status = this.statusStack.pop();
                }
                if (this.levelsV.size() > this.descriptionsV.size()) {
                    this.descriptionsV.add("");
                }
                if (this.levelsV.size() > this.categoriesV.size()) {
                    this.categoriesV.add("");
                }
            } else {
                System.out.println("unknown element(end): " + string3);
            }
        }
    }

    public void startDocument() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.curValue = "";
        if (string3.equalsIgnoreCase(GITEM)) {
            this.statusStack.push(new Short(this.status));
            this.status = (short)3;
            this.curItem = new GuidelineItemImpl(this.guidelineName);
            this.curItem.setLevel(this.getAttribute(attributes, LEVEL));
            this.curItem.setId(this.getAttribute(attributes, ID));
        } else if (string3.equalsIgnoreCase(TECHNIQUE)) {
            this.statusStack.push(new Short(this.status));
            this.status = (short)7;
            this.curTech = new TechniquesItemImpl();
            this.curTech.setId(this.getAttribute(attributes, ID));
            this.curTech.setGuidelineName(this.guidelineName);
        } else if (!string3.equalsIgnoreCase(HELP_URL)) {
            if (string3.equalsIgnoreCase(GUIDELINE)) {
                this.guidelineName = this.getAttribute(attributes, NAME);
                this.getGuidelineOrder(attributes);
            } else if (string3.equalsIgnoreCase(MIMETYPES)) {
                this.statusStack.push(new Short(this.status));
                this.status = (short)4;
            } else if (string3.equalsIgnoreCase(LEVELS)) {
                this.statusStack.push(new Short(this.status));
                this.status = 1;
            } else if (string3.equalsIgnoreCase(LEVEL)) {
                this.statusStack.push(new Short(this.status));
                this.status = (short)5;
                this.levelsV.add(this.getAttribute(attributes, ID));
            } else if (string3.equalsIgnoreCase(ITEMS)) {
                this.statusStack.push(new Short(this.status));
                this.status = (short)2;
            } else if (string3.equalsIgnoreCase(TECHNIQUES)) {
                this.statusStack.push(new Short(this.status));
                this.status = (short)6;
            }
        }
    }

    public boolean isSucceed() {
        return this.succeed;
    }

    private String getAttribute(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private void getGuidelineOrder(Attributes attributes) {
        String string = attributes.getValue(ORDER);
        this.order = Integer.MAX_VALUE;
        if (this.guidelineName != null) {
            try {
                this.order = Integer.parseInt(string);
            }
            catch (Exception exception) {}
        }
    }
}

