/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.visualization.eval.IEvaluationResult;
import org.eclipse.actf.visualization.eval.problem.IProblemConst;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.ui.report.table.ResultTableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemTree {
    private Tree tree;
    private TreeItem nodeRoot;
    private TreeItem node1_1;
    private TreeItem node1_2;
    private TreeItem node1_3;
    private TreeItem node1_4;
    private ResultTableViewer _resultTableViewer = null;

    public ProblemTree(Composite composite) {
        this.tree = new Tree(composite, 2050);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.tree.setLayoutData((Object)gridData);
        this.createTreeNodes();
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ProblemTree.this._resultTableViewer != null) {
                    TreeItem[] treeItemArray = ProblemTree.this.tree.getSelection();
                    if (treeItemArray != null) {
                        int n = 0;
                        int n2 = 0;
                        while (n2 < treeItemArray.length) {
                            TreeItem treeItem = treeItemArray[n2];
                            if (treeItem == ProblemTree.this.nodeRoot) {
                                ProblemTree.this._resultTableViewer.changeFilterType(Integer.MAX_VALUE);
                                return;
                            }
                            if (treeItem == ProblemTree.this.node1_1) {
                                n |= 1;
                            } else if (treeItem == ProblemTree.this.node1_2) {
                                n |= 2;
                            } else if (treeItem == ProblemTree.this.node1_3) {
                                n |= 4;
                            } else if (treeItem == ProblemTree.this.node1_4) {
                                n |= 8;
                            }
                            ++n2;
                        }
                        ProblemTree.this._resultTableViewer.changeFilterType(n);
                        return;
                    }
                    ProblemTree.this._resultTableViewer.changeFilterType(Integer.MAX_VALUE);
                }
            }
        });
    }

    public void createTreeNodes() {
        this.tree.removeAll();
        this.nodeRoot = new TreeItem(this.tree, 0);
        this.nodeRoot.setImage(PlatformUIUtil.getSharedImageDescriptor((String)"IMG_OBJ_FOLDER").createImage());
        this.node1_1 = new TreeItem(this.nodeRoot, 0);
        this.node1_1.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.eval", (String)"icons/Err.png").createImage());
        this.node1_2 = new TreeItem(this.nodeRoot, 0);
        this.node1_2.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.eval", (String)"icons/Warn.png").createImage());
        this.node1_3 = new TreeItem(this.nodeRoot, 0);
        this.node1_3.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.eval", (String)"icons/Conf.png").createImage());
        this.node1_4 = new TreeItem(this.nodeRoot, 0);
        this.node1_4.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.eval", (String)"icons/Info.png").createImage());
        this.nodeRoot.setExpanded(true);
        this.clearTreeNodeAmount();
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setRootSel() {
        this.tree.setSelection(new TreeItem[]{this.nodeRoot});
    }

    public void clearTreeNodeAmount() {
        this.changeTreeNodeAmount(new ArrayList<IProblemItem>());
        this.tree.getDisplay().update();
    }

    public void changeTreeNodeAmount(List<IProblemItem> list) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Iterator<IProblemItem> iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                switch (iterator.next().getSeverity()) {
                    case 1: {
                        ++n;
                        break;
                    }
                    case 2: {
                        ++n2;
                        break;
                    }
                    case 4: {
                        ++n3;
                        break;
                    }
                    case 8: {
                        ++n4;
                    }
                }
            }
            catch (Exception exception) {}
        }
        int n5 = n + n3 + n4;
        this.nodeRoot.setText(String.valueOf(IProblemConst.ALL_ERRORS) + "  (" + n5 + ")");
        this.node1_1.setText(String.valueOf(IProblemConst.ESSENTIAL) + "  (" + n + ")");
        this.node1_2.setText(String.valueOf(IProblemConst.WARNING) + "  (" + n2 + ")");
        this.node1_3.setText(String.valueOf(IProblemConst.USER_CHECK) + " (" + n3 + ")");
        this.node1_4.setText(String.valueOf(IProblemConst.INFO) + " (" + n4 + ")");
    }

    public void setResultTableViewer(ResultTableViewer resultTableViewer) {
        this._resultTableViewer = resultTableViewer;
    }

    public ResultTableViewer getResultTableViewer() {
        return this._resultTableViewer;
    }

    public void setResult(IEvaluationResult iEvaluationResult) {
        this.changeTreeNodeAmount(iEvaluationResult.getProblemList());
    }
}

