/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ColorHistogramBin;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;

public class ColorHistogram {
    private HashMap<Integer, ColorHistogramBin> pixelMap = new HashMap();
    private ColorHistogramBin[] sortedArrayByOccurrence = null;
    private boolean changedFlag = true;

    public boolean changed() {
        return this.changedFlag;
    }

    public ColorHistogramBin[] getSortedArrayByOccurrence() {
        return this.sortedArrayByOccurrence;
    }

    public int getSize() {
        return this.pixelMap.size();
    }

    public void put(int n) {
        this.changedFlag = true;
        Integer n2 = new Integer(n);
        ColorHistogramBin colorHistogramBin = this.pixelMap.get(n2);
        if (colorHistogramBin != null) {
            ++colorHistogramBin.occurrence;
        } else {
            colorHistogramBin = new ColorHistogramBin(n2);
            ++colorHistogramBin.occurrence;
            this.pixelMap.put(n2, colorHistogramBin);
        }
    }

    public void makeSortedArrayByOccurrence() {
        if (!this.changedFlag) {
            return;
        }
        if (this.getSize() == 0) {
            return;
        }
        this.changedFlag = false;
        Object[] objectArray = this.pixelMap.keySet().toArray();
        int n = objectArray.length;
        this.sortedArrayByOccurrence = new ColorHistogramBin[n];
        int n2 = 0;
        while (n2 < n) {
            this.sortedArrayByOccurrence[n2] = this.pixelMap.get(objectArray[n2]);
            ++n2;
        }
        Arrays.sort(this.sortedArrayByOccurrence, new ComparatorByOccurrence());
    }

    public static ColorHistogram makeColorHistogram(int[][] nArray, int n, int n2) {
        ColorHistogram colorHistogram = new ColorHistogram();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                colorHistogram.put(nArray[n3][n4]);
                ++n4;
            }
            ++n3;
        }
        colorHistogram.makeSortedArrayByOccurrence();
        return colorHistogram;
    }

    public static ColorHistogram makeColorHistogram(IInt2D iInt2D) {
        return ColorHistogram.makeColorHistogram(iInt2D.getData(), iInt2D.getWidth(), iInt2D.getHeight());
    }

    public void dump(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.dump(printWriter);
    }

    public void dump(PrintWriter printWriter) {
        if (this.changedFlag) {
            this.makeSortedArrayByOccurrence();
        }
        int n = this.sortedArrayByOccurrence.length;
        int n2 = 0;
        while (n2 < n) {
            ColorHistogramBin colorHistogramBin = this.sortedArrayByOccurrence[n2];
            int n3 = colorHistogramBin.occurrence;
            int n4 = colorHistogramBin.getR();
            int n5 = colorHistogramBin.getG();
            int n6 = colorHistogramBin.getB();
            printWriter.println(String.valueOf(n2) + ": rgb = ( " + n4 + ", " + n5 + ", " + n6 + ") occurrence = " + n3);
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ComparatorByOccurrence
    implements Comparator<ColorHistogramBin> {
        @Override
        public int compare(ColorHistogramBin colorHistogramBin, ColorHistogramBin colorHistogramBin2) {
            return colorHistogramBin2.occurrence - colorHistogramBin.occurrence;
        }
    }
}

