/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IHighlightElementListener;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.PopupMenu;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.internal.engines.blind.html.Messages;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationAttributeInfo;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementViewerJFace {
    private static final String NULL_STRING = "";
    private IHighlightElementListener prb;
    private int[] sortModeArray;
    private Composite elementViewerComposite;
    private TableViewer viewer;
    private TableColumn categoryCol;
    private TableColumn descCol;
    private static final String COL_CATEGORY = "Category";
    private static final String COL_ID_STRING = "Value";
    private static final String COL_TAG_NAME = "Tag Name";
    private static final String COL_DESCRIPTION = "Description";
    private String strHelpUrl;

    public ElementViewerJFace(Composite composite, IHighlightElementListener iHighlightElementListener) {
        this.prb = iHighlightElementListener;
        this.elementViewerComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.elementViewerComposite.setLayout((Layout)gridLayout);
        this.elementViewerComposite.setLayoutData((Object)new GridData(1808));
        final Table table = new Table(this.elementViewerComposite, 68354);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.sortModeArray = new int[4];
        this.categoryCol = new TableColumn(table, 16384);
        this.categoryCol.setText(COL_CATEGORY);
        this.sortModeArray[0] = 0;
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(COL_ID_STRING);
        tableColumn.setWidth(150);
        this.sortModeArray[1] = 0;
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        tableColumn2.setText(COL_TAG_NAME);
        tableColumn2.setWidth(100);
        this.sortModeArray[2] = 0;
        this.descCol = new TableColumn(table, 16384);
        this.descCol.setText(COL_DESCRIPTION);
        this.sortModeArray[3] = 0;
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (mouseEvent.stateMask == 0x200000 && table.getSelectionIndex() >= 0) {
                    ElementViewerJFace.this.openPopupMenu();
                }
            }
        });
        this.viewer = new TableViewer(table);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ArrayList<VisualizationAttributeInfo> arrayList = new ArrayList<VisualizationAttributeInfo>();
                for (Object e : (IStructuredSelection)selectionChangedEvent.getSelection()) {
                    if (!(e instanceof VisualizationAttributeInfo)) continue;
                    arrayList.add((VisualizationAttributeInfo)e);
                }
                if (arrayList.size() > 0) {
                    ElementViewerJFace.this.viewerSelected(arrayList);
                }
            }
        });
        this.categoryCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ElementViewerJFace.this.toggleCurrentSortMode(0);
                if (ElementViewerJFace.this.sortModeArray[0] == -2) {
                    ElementViewerJFace.this.sortByNodeId();
                } else {
                    ElementViewerJFace.this.viewer.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object object, Object object2) {
                            int n;
                            if (object == null) {
                                n = -1;
                            } else if (object2 == null) {
                                n = 1;
                            } else {
                                String string = ((VisualizationAttributeInfo)object).getCategory();
                                String string2 = ((VisualizationAttributeInfo)object2).getCategory();
                                if (string.equals(ElementViewerJFace.NULL_STRING)) {
                                    return 1;
                                }
                                if (string2.equals(ElementViewerJFace.NULL_STRING)) {
                                    return -1;
                                }
                                n = string.compareToIgnoreCase(string2);
                            }
                            return n * ElementViewerJFace.this.sortModeArray[0];
                        }
                    });
                }
            }
        });
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ElementViewerJFace.this.toggleCurrentSortMode(1);
                if (ElementViewerJFace.this.sortModeArray[1] == -2) {
                    ElementViewerJFace.this.sortByNodeId();
                } else {
                    ElementViewerJFace.this.viewer.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object object, Object object2) {
                            int n = object == null ? -1 : (object2 == null ? 1 : ((VisualizationAttributeInfo)object).getAttributeValue().compareToIgnoreCase(((VisualizationAttributeInfo)object2).getAttributeValue()));
                            return n * ElementViewerJFace.this.sortModeArray[1];
                        }
                    });
                }
            }
        });
        tableColumn2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ElementViewerJFace.this.toggleCurrentSortMode(2);
                if (ElementViewerJFace.this.sortModeArray[2] == -2) {
                    ElementViewerJFace.this.sortByNodeId();
                } else {
                    ElementViewerJFace.this.viewer.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object object, Object object2) {
                            int n = object == null ? -1 : (object2 == null ? 1 : ((VisualizationAttributeInfo)object).getTagName().compareToIgnoreCase(((VisualizationAttributeInfo)object2).getTagName()));
                            return n * ElementViewerJFace.this.sortModeArray[2];
                        }
                    });
                }
            }
        });
        this.descCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ElementViewerJFace.this.toggleCurrentSortMode(3);
                if (ElementViewerJFace.this.sortModeArray[3] == -2) {
                    ElementViewerJFace.this.sortByNodeId();
                } else {
                    ElementViewerJFace.this.viewer.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object object, Object object2) {
                            int n;
                            if (object == null) {
                                n = -1;
                            } else if (object2 == null) {
                                n = 1;
                            } else {
                                String string = ((VisualizationAttributeInfo)object).getDescription();
                                String string2 = ((VisualizationAttributeInfo)object2).getDescription();
                                if (string.equals(ElementViewerJFace.NULL_STRING)) {
                                    return 1;
                                }
                                if (string2.equals(ElementViewerJFace.NULL_STRING)) {
                                    return -1;
                                }
                                n = string.compareToIgnoreCase(string2);
                            }
                            return n * ElementViewerJFace.this.sortModeArray[3];
                        }
                    });
                }
            }
        });
    }

    private void viewerSelected(List<VisualizationAttributeInfo> list) {
        this.prb.clearHighlight();
        VisualizationAttributeInfo visualizationAttributeInfo = null;
        Vector<HighlightTargetId> vector = new Vector<HighlightTargetId>();
        int n = 0;
        while (n < list.size()) {
            visualizationAttributeInfo = list.get(n);
            vector.add(new HighlightTargetId(visualizationAttributeInfo.getNodeId(), visualizationAttributeInfo.getNodeId()));
            if (n == 0) {
                this.strHelpUrl = visualizationAttributeInfo.getHelpUrl();
            } else if (!this.strHelpUrl.equals(visualizationAttributeInfo.getHelpUrl())) {
                this.strHelpUrl = NULL_STRING;
            }
            ++n;
        }
        this.prb.highlight(vector);
        IModelService iModelService = ModelServiceUtils.getActiveModelService();
        if (iModelService != null && iModelService instanceof IWebBrowserACTF) {
            ((IWebBrowserACTF)iModelService).hightlightElementByAttribute(visualizationAttributeInfo.getAttribtueName(), visualizationAttributeInfo.getAttributeValue());
        }
    }

    private void toggleCurrentSortMode(int n) {
        switch (this.sortModeArray[n]) {
            case -2: {
                this.sortModeArray[n] = 1;
                break;
            }
            case -1: {
                this.sortModeArray[n] = -2;
                break;
            }
            case 0: {
                this.sortModeArray[n] = 1;
                break;
            }
            case 1: {
                this.sortModeArray[n] = -1;
            }
        }
    }

    private void sortByNodeId() {
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                int n = object == null ? -1 : (object2 == null ? 1 : ((VisualizationAttributeInfo)object).getNodeId() - ((VisualizationAttributeInfo)object2).getNodeId());
                return n;
            }
        });
    }

    private void openPopupMenu() {
        PopupMenu popupMenu;
        String string;
        String[] stringArray = new String[]{Messages.ElementViewerJFace_0, Messages.ElementViewerJFace_1};
        boolean[] blArray = new boolean[]{true, true};
        if (this.strHelpUrl.equals(NULL_STRING)) {
            blArray[1] = false;
        }
        if ((string = (popupMenu = new PopupMenu(new Shell(), stringArray, blArray)).open()).equals(stringArray[1])) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(this.strHelpUrl);
        }
    }

    public Composite getComposite() {
        return this.elementViewerComposite;
    }

    public void setContentProvider(IStructuredContentProvider iStructuredContentProvider) {
        this.viewer.setContentProvider((IContentProvider)iStructuredContentProvider);
    }

    public void setLabelProvider(ITableLabelProvider iTableLabelProvider) {
        this.viewer.setLabelProvider((IBaseLabelProvider)iTableLabelProvider);
    }

    public void setElementList(List<VisualizationAttributeInfo> list) {
        this.viewer.setInput(list);
    }

    public void setCategoryColWidth(int n) {
        this.categoryCol.setWidth(n);
        if (n == 0) {
            this.categoryCol.setResizable(false);
        }
    }

    public void setDescColWidth(int n) {
        this.descCol.setWidth(n);
        if (n == 0) {
            this.descCol.setResizable(false);
        }
    }
}

