/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.ui.report.views;

import org.eclipse.actf.mediator.IACTFReportViewer;
import org.eclipse.actf.mediator.MediatorEvent;
import org.eclipse.actf.visualization.eval.EvaluationResultImpl;
import org.eclipse.actf.visualization.eval.IEvaluationResult;
import org.eclipse.actf.visualization.internal.ui.report.DetailProblemReportArea;
import org.eclipse.actf.visualization.ui.IVisualizationView;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class DetailedReportView
extends ViewPart
implements IACTFReportViewer {
    private IEvaluationResult curResult = null;
    private static final IEvaluationResult dummyResult = new EvaluationResultImpl();
    private DetailProblemReportArea problemArea;

    public void createPartControl(Composite composite) {
        this.problemArea = new DetailProblemReportArea(composite, 0);
        this.getSite().setSelectionProvider((ISelectionProvider)this.problemArea.getProblemTree().getResultTableViewer().getTableViewer());
    }

    public void setFocus() {
    }

    public void modelserviceChanged(MediatorEvent mediatorEvent) {
        this.problemArea.setModelService(mediatorEvent.getModelServiceHolder().getModelService());
        this.updateEvaluationResult(mediatorEvent);
    }

    public void modelserviceInputChanged(MediatorEvent mediatorEvent) {
        this.updateEvaluationResult(mediatorEvent);
    }

    public void reportChanged(MediatorEvent mediatorEvent) {
        this.updateEvaluationResult(mediatorEvent);
    }

    public void reportGeneratorChanged(MediatorEvent mediatorEvent) {
        this.updateEvaluationResult(mediatorEvent);
    }

    private void updateEvaluationResult(MediatorEvent mediatorEvent) {
        IEvaluationResult iEvaluationResult = dummyResult;
        if (mediatorEvent.getReport() instanceof IEvaluationResult) {
            iEvaluationResult = (IEvaluationResult)mediatorEvent.getReport();
        }
        if (this.curResult != iEvaluationResult) {
            IVisualizationView iVisualizationView = null;
            if (mediatorEvent.getView() instanceof IVisualizationView) {
                iVisualizationView = (IVisualizationView)mediatorEvent.getView();
            }
            this.problemArea.setResult(iVisualizationView, iEvaluationResult);
            this.curResult = iEvaluationResult;
        }
    }
}

