/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.flash.ui.views;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.model.flash.ASAccInfo;
import org.eclipse.actf.model.flash.FlashPlayerFactory;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashConst;
import org.eclipse.actf.model.flash.IFlashPlayer;
import org.eclipse.actf.model.flash.util.FlashDetect;
import org.eclipse.actf.model.flash.util.FlashMSAAUtil;
import org.eclipse.actf.visualization.flash.ui.properties.FlashNodePropertySource;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.ui.actions.RefreshRootAction;
import org.eclipse.actf.visualization.gui.ui.views.IFlashDOMView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.actf.visualization.internal.flash.FlashImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class FlashDOMView
extends ViewPart
implements IFlashDOMView,
IFlashConst {
    private TreeViewer viewer;
    private Action expandAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private RefreshRootAction refreshAction;
    private Action informativeTreeAction;
    private Action visualTreeAction;
    private Action debugTreeAction;
    private Action scanWindowlessAction;
    private Color colorFound = Display.getCurrent().getSystemColor(13);
    private boolean debugMode = false;

    public void createPartControl(Composite composite) {
        this.viewer = new FlashTreeViewer(composite, 772);
        this.viewer.setContentProvider((IContentProvider)new FlashDOMContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FlashDOMLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    if (object instanceof IASNode) {
                        ((IASNode)object).setMarker();
                    } else if (!(object instanceof IFlashPlayer)) {
                        return;
                    }
                    MSAAViewRegistory.showProperties((Object)object);
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        MSAAViewRegistory.findView((String)IGuiViewIDs.ID_OUTLINEVIEW);
        this.refresh();
    }

    public void refresh() {
        AccessibleObject accessibleObject = MSAAViewRegistory.getRootObject();
        if (accessibleObject != null) {
            IFlashPlayer[] iFlashPlayerArray = FlashMSAAUtil.getFlashPlayers((int)accessibleObject.getWindow());
            int n = 0;
            while (n < iFlashPlayerArray.length) {
                iFlashPlayerArray[n].clearAllMarkers();
                ++n;
            }
            this.viewer.setInput((Object)iFlashPlayerArray);
            FlashDetect.showDialog();
        }
    }

    public void findRectangle(Rectangle rectangle, Object object) {
        this.viewer.setInput((Object)new Object[]{object});
        String string = org.eclipse.actf.visualization.internal.flash.Messages.flash_error_no_element;
        RectangleFinder rectangleFinder = new RectangleFinder(rectangle);
        try {
            rectangleFinder.find(this.viewer.getTree().getItems());
        }
        catch (Error error) {}
        if (rectangleFinder.foundCount > 0) {
            string = MessageFormat.format((String)org.eclipse.actf.visualization.internal.flash.Messages.flash_element_found, (Object[])new Object[]{new Integer(rectangleFinder.foundCount)});
        }
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)org.eclipse.actf.visualization.internal.flash.Messages.flash_flash_dom, (String)string);
    }

    public void addWindowlessElement(final Object object) {
        if (!this.scanWindowlessAction.isChecked() && object instanceof AccessibleObject) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    Object object2 = FlashDOMView.this.viewer.getInput();
                    IFlashPlayer iFlashPlayer = FlashPlayerFactory.getPlayerFromPtr((int)((AccessibleObject)object).getPtr());
                    if (object2 instanceof IFlashPlayer[]) {
                        List<IFlashPlayer> list = Arrays.asList((IFlashPlayer[])object2);
                        for (IFlashPlayer object22 : list) {
                            if (object22 != iFlashPlayer && object22.getAccessible().getPtr() != object22.getAccessible().getPtr()) continue;
                            return;
                        }
                        ArrayList<IFlashPlayer> arrayList = new ArrayList<IFlashPlayer>(list);
                        arrayList.add(iFlashPlayer);
                        FlashDOMView.this.viewer.setInput((Object)arrayList.toArray());
                    }
                }
            });
        }
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                FlashDOMView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.informativeTreeAction);
        iMenuManager.add((IAction)this.visualTreeAction);
        iMenuManager.add((IAction)this.scanWindowlessAction);
        iMenuManager.add((IAction)this.debugTreeAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        Object object = this.getSelectedItem();
        if (object != null) {
            iMenuManager.add((IAction)this.expandAction);
        }
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.refreshAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.expandAllAction);
        iToolBarManager.add((IAction)this.collapseAllAction);
        iToolBarManager.add((IAction)this.refreshAction);
    }

    private void makeActions() {
        this.expandAction = new Action(Messages.msaa_expand){

            public void run() {
                try {
                    Object object = FlashDOMView.this.getSelectedItem();
                    if (object != null) {
                        FlashDOMView.this.viewer.expandToLevel(object, -1);
                    }
                }
                catch (Error error) {
                    error.printStackTrace();
                }
            }
        };
        this.expandAllAction = new Action(Messages.msaa_expand_all){

            public void run() {
                try {
                    FlashDOMView.this.viewer.expandAll();
                }
                catch (Error error) {
                    System.err.println(error.getMessage());
                }
            }
        };
        this.expandAllAction.setToolTipText(Messages.msaa_expand_all);
        this.expandAllAction.setImageDescriptor(GuiImages.IMAGE_EXPAND_ALL);
        this.collapseAllAction = new Action(Messages.msaa_collapse_all){

            public void run() {
                try {
                    FlashDOMView.this.viewer.collapseAll();
                }
                catch (Error error) {
                    error.printStackTrace();
                }
            }
        };
        this.collapseAllAction.setToolTipText(Messages.msaa_collapse_all);
        this.collapseAllAction.setImageDescriptor(GuiImages.IMAGE_COLLAPSE_ALL);
        this.refreshAction = new RefreshRootAction();
        this.informativeTreeAction = new Action(org.eclipse.actf.visualization.internal.flash.Messages.flash_filter_noninformative, 2){

            public void run() {
                FlashDOMContentProvider flashDOMContentProvider = (FlashDOMContentProvider)FlashDOMView.this.viewer.getContentProvider();
                flashDOMContentProvider.informativeTree = FlashDOMView.this.informativeTreeAction.isChecked();
                MSAAViewRegistory.refreshRootObject();
            }
        };
        this.visualTreeAction = new Action(org.eclipse.actf.visualization.internal.flash.Messages.flash_show_visual, 2){

            public void run() {
                FlashDOMContentProvider flashDOMContentProvider = (FlashDOMContentProvider)FlashDOMView.this.viewer.getContentProvider();
                flashDOMContentProvider.visualTree = FlashDOMView.this.visualTreeAction.isChecked();
                MSAAViewRegistory.refreshRootObject();
            }
        };
        this.debugTreeAction = new Action(org.eclipse.actf.visualization.internal.flash.Messages.flash_debugMode, 2){

            public void run() {
                FlashDOMView.this.debugMode = FlashDOMView.this.debugTreeAction.isChecked();
                FlashNodePropertySource.setDebugMode(FlashDOMView.this.debugMode);
                MSAAViewRegistory.refreshRootObject();
            }
        };
        this.scanWindowlessAction = new Action(org.eclipse.actf.visualization.internal.flash.Messages.flash_scanWindowless, 2){

            public void run() {
                FlashMSAAUtil.setScanAll((boolean)FlashDOMView.this.scanWindowlessAction.isChecked());
                MSAAViewRegistory.refreshRootObject();
            }
        };
    }

    public void setDebugMode(boolean bl) {
        this.debugTreeAction.setChecked(bl);
        this.scanWindowlessAction.setChecked(bl);
        this.debugMode = bl;
        FlashNodePropertySource.setDebugMode(bl);
        FlashMSAAUtil.setScanAll((boolean)bl);
        MSAAViewRegistory.refreshRootObject();
    }

    private Object getSelectedItem() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        if (iStructuredSelection.size() == 1) {
            return iStructuredSelection.getFirstElement();
        }
        return null;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private static String getNodeImage(Object object) {
        String string = null;
        if (object instanceof IASNode) {
            string = ((IASNode)object).getIconType();
            if (string.startsWith("accrole_")) {
                try {
                    String string2 = string.substring("accrole_".length());
                    return GuiImages.roleIcon((int)Integer.parseInt(string2));
                }
                catch (Exception exception) {}
            }
        } else if (object instanceof IFlashPlayer) {
            string = "flash";
        }
        return string != null ? FlashImages.flashIcon(string) : null;
    }

    private static String getNodeText(Object object) {
        if (object instanceof IASNode) {
            String string;
            String string2;
            IASNode iASNode = (IASNode)object;
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = iASNode.getText();
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            if ((string2 = iASNode.getTitle()) != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string2);
            }
            if ((string = iASNode.getValue()) != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string);
            }
            if (stringBuffer.length() == 0) {
                stringBuffer.append(Messages.msaa_NAMELESS);
            }
            String string4 = iASNode.getObjectName();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string4);
            String string5 = iASNode.getType();
            if (string5 != null) {
                stringBuffer.append("(");
                stringBuffer.append(string5);
                stringBuffer.append(")");
            }
            return stringBuffer.toString();
        }
        if (object instanceof IFlashPlayer) {
            return ((IFlashPlayer)object).getStatus();
        }
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    public String getNodeError(Object object) {
        if (object instanceof IASNode) {
            boolean bl;
            IASNode iASNode = (IASNode)object;
            if (!iASNode.getPlayer().isVisible()) {
                return "icons/ovr16/black.gif";
            }
            ASAccInfo aSAccInfo = iASNode.getAccInfo();
            if (iASNode.isUIComponent() && (aSAccInfo == null || -1 == aSAccInfo.getRole())) {
                return "icons/ovr16/red.gif";
            }
            boolean bl2 = bl = "movieclip".equals(iASNode.getType()) || "Button".equals(iASNode.getClassName());
            if (bl && aSAccInfo != null && aSAccInfo.isSilent()) {
                return "icons/ovr16/black.gif";
            }
            if (iASNode.getText() != null) {
                return "icons/ovr16/green.gif";
            }
            if (bl && (aSAccInfo == null || aSAccInfo.getName() == null)) {
                return "icons/ovr16/red.gif";
            }
            if ("Button".equals(iASNode.getClassName())) {
                return "icons/ovr16/yellow.gif";
            }
            String string = iASNode.getObjectName();
            if ("onRelease".equals(string)) {
                return "icons/ovr16/yellow.gif";
            }
            if ("_accProps".equals(string) || "_accImpl".equals(string)) {
                return "icons/ovr16/green.gif";
            }
        } else if (object instanceof IFlashPlayer) {
            return "icons/ovr16/black.gif";
        }
        return null;
    }

    private class FlashDOMContentProvider
    implements ITreeContentProvider {
        public boolean visualTree = false;
        public boolean informativeTree = false;

        private FlashDOMContentProvider() {
        }

        public Object[] getChildren(Object object) {
            Object[] objectArray = new IASNode[]{};
            if (object instanceof IASNode) {
                if (FlashDOMView.this.debugMode) {
                    objectArray = ((IASNode)object).getEntireChildren();
                } else {
                    objectArray = ((IASNode)object).getChildren(this.visualTree);
                    if (this.informativeTree) {
                        Vector<Object> vector = new Vector<Object>();
                        Object[] objectArray2 = objectArray;
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object2 = objectArray2[n2];
                            if (!object2.isAccProperties()) {
                                if (object2.getText() != null || "movieclip".equals(object2.getType()) || "Button".equals(object2.getClassName()) || "_accProps".equals(object2.getObjectName()) || "_accImpl".equals(object2.getObjectName()) || "onRelease".equals(object2.getObjectName())) {
                                    vector.add(object2);
                                }
                            } else {
                                vector.add(object2);
                            }
                            ++n2;
                        }
                        objectArray = new IASNode[vector.size()];
                        vector.toArray(objectArray);
                    }
                }
            }
            return objectArray;
        }

        public Object getParent(Object object) {
            if (object instanceof IASNode) {
                return ((IASNode)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            if (object instanceof IASNode) {
                return ((IASNode)object).hasChild(this.visualTree, FlashDOMView.this.debugMode);
            }
            return false;
        }

        public Object[] getElements(Object object) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n = 0;
                while (n < objectArray.length) {
                    AccessibleObject accessibleObject;
                    IFlashPlayer iFlashPlayer = null;
                    if (objectArray[n] instanceof AccessibleObject) {
                        accessibleObject = (AccessibleObject)objectArray[n];
                        iFlashPlayer = FlashPlayerFactory.getPlayerFromPtr((int)accessibleObject.getPtr());
                    } else if (objectArray[n] instanceof IFlashPlayer) {
                        iFlashPlayer = (IFlashPlayer)objectArray[n];
                    }
                    if (iFlashPlayer != null) {
                        accessibleObject = iFlashPlayer.getRootNode();
                        if (accessibleObject != null) {
                            arrayList.add(accessibleObject);
                        } else {
                            arrayList.add(iFlashPlayer);
                        }
                    }
                    ++n;
                }
            }
            return arrayList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class FlashDOMLabelProvider
    extends LabelProvider
    implements IColorProvider {
        public Image getImage(Object object) {
            String string = FlashDOMView.getNodeImage(object);
            String string2 = FlashDOMView.this.getNodeError(object);
            if (string != null) {
                if (string2 != null) {
                    return FlashImages.getImage(string, string2, new Point(16, 16));
                }
                return FlashImages.getImage(string);
            }
            if (string2 != null) {
                return FlashImages.getImage(string2);
            }
            return null;
        }

        public String getText(Object object) {
            return FlashDOMView.getNodeText(object);
        }

        public Color getBackground(Object object) {
            return null;
        }

        public Color getForeground(Object object) {
            return null;
        }
    }

    private class FlashTreeViewer
    extends TreeViewer {
        public FlashTreeViewer(Composite composite, int n) {
            super(new Tree(composite, n));
        }

        public TreeItem[] getChildItems(TreeItem treeItem) {
            super.createChildren((Widget)treeItem);
            return treeItem.getItems();
        }
    }

    private class RectangleFinder {
        private static final int MARGIN = 10;
        public int foundCount = 0;
        private int errorCount = 0;
        private int flashLeft;
        private int flashTop;
        private int flashRight;
        private int flashBottom;

        public RectangleFinder(Rectangle rectangle) {
            this.flashLeft = rectangle.x;
            this.flashTop = rectangle.y;
            this.flashRight = rectangle.x + rectangle.width;
            this.flashBottom = rectangle.y + rectangle.height;
        }

        public void find(TreeItem[] treeItemArray) {
            int n = 0;
            while (n < treeItemArray.length) {
                block9: {
                    TreeItem treeItem = treeItemArray[n];
                    try {
                        double d;
                        double d2;
                        double d3;
                        IASNode iASNode = (IASNode)treeItem.getData();
                        if (iASNode.getLevel() >= 40) {
                            throw new Error(String.valueOf(MessageFormat.format((String)org.eclipse.actf.visualization.internal.flash.Messages.flash_error_target_length, (Object[])new Object[]{new Integer(iASNode.getLevel())})) + "\n" + iASNode.getTarget());
                        }
                        double d4 = iASNode.getX();
                        if (!(d4 >= (double)(this.flashRight + 10) || (d3 = iASNode.getY()) >= (double)(this.flashBottom + 10) || d4 + (d2 = iASNode.getWidth()) <= (double)(this.flashLeft - 10) || d3 + (d = iASNode.getHeight()) <= (double)(this.flashTop - 10))) {
                            if (this.isMatch(d4, d3, d2, d)) {
                                treeItem.setBackground(FlashDOMView.this.colorFound);
                                ++this.foundCount;
                                FlashDOMView.this.viewer.reveal((Object)iASNode);
                            }
                            if (!Boolean.TRUE.equals(iASNode.getObject("isOpaqueObject"))) {
                                this.find(((FlashTreeViewer)FlashDOMView.this.viewer).getChildItems(treeItem));
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    catch (FindError findError) {
                        throw findError;
                    }
                    catch (Error error) {
                        System.err.println(error.getMessage());
                        if (++this.errorCount < 20) break block9;
                        throw new FindError("Error count reached " + this.errorCount);
                    }
                }
                ++n;
            }
        }

        private boolean isMatch(double d, double d2, double d3, double d4) {
            return (double)(this.flashLeft - 10) <= d && d < (double)(this.flashLeft + 10) && (double)(this.flashTop - 10) <= d2 && d2 < (double)(this.flashTop + 10) && (double)(this.flashRight - 10) <= d + d3 && d + d3 <= (double)(this.flashRight + 10) && (double)(this.flashBottom - 10) <= d2 + d4 && d2 + d4 <= (double)(this.flashBottom + 10);
        }

        private class FindError
        extends Error {
            private static final long serialVersionUID = -7707451728015676479L;

            public FindError(String string) {
                super(string);
            }
        }
    }
}

