/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.base.impl;

import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFNode;
import org.eclipse.actf.model.dom.odf.base.impl.ODFDocumentImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFNamedNodeMapImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFNodeListImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

class ODFNodeImpl
implements ODFNode {
    protected ODFDocumentImpl odfDoc = null;
    protected Node iNode = null;

    protected ODFNodeImpl(Node node) {
        this.odfDoc = (ODFDocumentImpl)this;
        this.iNode = node;
    }

    protected ODFNodeImpl(ODFDocument oDFDocument, Node node) {
        this.odfDoc = (ODFDocumentImpl)oDFDocument;
        this.iNode = node;
    }

    protected Node getInternalNode() {
        return this.iNode;
    }

    public Node appendChild(Node node) throws DOMException {
        if (node instanceof ODFNodeImpl) {
            Node node2 = ((ODFNodeImpl)node).getInternalNode();
            Node node3 = this.iNode.appendChild(node2);
            return new ODFNodeImpl(this.odfDoc, node3);
        }
        return null;
    }

    public Node cloneNode(boolean bl) {
        if (this.odfDoc == null) {
            return null;
        }
        Node node = this.iNode.cloneNode(bl);
        if (node == null) {
            return null;
        }
        return this.odfDoc.getODFNode(node);
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        if (node instanceof ODFNodeImpl) {
            Node node2 = ((ODFNodeImpl)node).getInternalNode();
            return this.iNode.compareDocumentPosition(node2);
        }
        return 0;
    }

    public NamedNodeMap getAttributes() {
        if (this.odfDoc == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = this.iNode.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        return new ODFNamedNodeMapImpl(this.odfDoc, namedNodeMap);
    }

    public String getBaseURI() {
        return this.iNode.getBaseURI();
    }

    public NodeList getChildNodes() {
        return new ODFNodeListImpl(this.odfDoc, this.iNode.getChildNodes());
    }

    public Object getFeature(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public Node getFirstChild() {
        if (this.odfDoc == null) {
            return null;
        }
        Node node = this.iNode.getFirstChild();
        if (node == null) {
            return null;
        }
        return this.odfDoc.getODFNode(node);
    }

    public Node getLastChild() {
        if (this.odfDoc == null) {
            return null;
        }
        Node node = this.iNode.getLastChild();
        if (node == null) {
            return null;
        }
        return this.odfDoc.getODFNode(node);
    }

    public String getLocalName() {
        return this.iNode.getLocalName();
    }

    public String getNamespaceURI() {
        return this.iNode.getNamespaceURI();
    }

    public Node getNextSibling() {
        if (this.odfDoc == null) {
            return null;
        }
        Node node = this.iNode.getNextSibling();
        if (node == null) {
            return null;
        }
        return this.odfDoc.getODFNode(node);
    }

    public String getNodeName() {
        return this.iNode.getNodeName();
    }

    public short getNodeType() {
        return this.iNode.getNodeType();
    }

    public String getNodeValue() throws DOMException {
        return this.iNode.getNodeValue();
    }

    public Document getOwnerDocument() {
        return this.odfDoc;
    }

    public Node getParentNode() {
        Node node = this.iNode.getParentNode();
        if (node == null) {
            return null;
        }
        return this.odfDoc.getODFNode(node);
    }

    public String getPrefix() {
        return this.iNode.getPrefix();
    }

    public Node getPreviousSibling() {
        if (this.odfDoc == null) {
            return null;
        }
        Node node = this.iNode.getPreviousSibling();
        if (node == null) {
            return null;
        }
        return this.odfDoc.getODFNode(node);
    }

    public String getTextContent() throws DOMException {
        return this.iNode.getTextContent();
    }

    public Object getUserData(String string) {
        return this.iNode.getUserData(string);
    }

    public boolean hasAttributes() {
        return this.iNode.hasAttributes();
    }

    public boolean hasChildNodes() {
        return this.iNode.hasChildNodes();
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (this.odfDoc == null) {
            return null;
        }
        if (node instanceof ODFNodeImpl && node2 instanceof ODFNodeImpl) {
            Node node3;
            Node node4 = ((ODFNodeImpl)node).getInternalNode();
            Node node5 = this.iNode.insertBefore(node4, node3 = ((ODFNodeImpl)node2).getInternalNode());
            if (node5 == null) {
                return null;
            }
            return this.odfDoc.getODFNode(node5);
        }
        return null;
    }

    public boolean isDefaultNamespace(String string) {
        return this.iNode.isDefaultNamespace(string);
    }

    public boolean isEqualNode(Node node) {
        if (node instanceof ODFNodeImpl) {
            Node node2 = ((ODFNodeImpl)node).getInternalNode();
            return this.iNode.isEqualNode(node2);
        }
        return false;
    }

    public boolean isSameNode(Node node) {
        if (node instanceof ODFNodeImpl) {
            Node node2 = ((ODFNodeImpl)node).getInternalNode();
            return this.iNode.isSameNode(node2);
        }
        return false;
    }

    public boolean isSupported(String string, String string2) {
        return this.iNode.isSupported(string, string2);
    }

    public String lookupNamespaceURI(String string) {
        return this.iNode.lookupNamespaceURI(string);
    }

    public String lookupPrefix(String string) {
        return this.iNode.lookupPrefix(string);
    }

    public void normalize() {
    }

    public Node removeChild(Node node) throws DOMException {
        if (this.odfDoc == null) {
            return null;
        }
        if (node instanceof ODFNodeImpl) {
            Node node2 = ((ODFNodeImpl)node).getInternalNode();
            Node node3 = this.iNode.removeChild(node2);
            return this.odfDoc.getODFNode(node3);
        }
        return null;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (this.odfDoc == null) {
            return null;
        }
        if (node instanceof ODFNodeImpl && node2 instanceof ODFNodeImpl) {
            Node node3 = ((ODFNodeImpl)node).getInternalNode();
            Node node4 = ((ODFNodeImpl)node2).getInternalNode();
            Node node5 = this.iNode.replaceChild(node3, node4);
            return this.odfDoc.getODFNode(node5);
        }
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        this.iNode.setNodeValue(string);
    }

    public void setPrefix(String string) throws DOMException {
        this.iNode.setPrefix(string);
    }

    public void setTextContent(String string) throws DOMException {
        this.iNode.setTextContent(string);
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return null;
    }
}

