/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFNode;
import org.eclipse.actf.model.dom.odf.base.impl.ODFDocumentImpl;
import org.eclipse.actf.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ODFParser {
    private InputStream getFileInputStream(String string, String string2) {
        Object object;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {}
        ZipFile zipFile = null;
        ZipEntry zipEntry = null;
        try {
            zipFile = uRL != null ? new ZipFile(new File(uRL.toURI())) : new ZipFile(string);
            object = string2.replaceAll("\\\\", "/");
            zipEntry = zipFile.getEntry((String)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        object = null;
        if (zipEntry != null) {
            try {
                object = zipFile.getInputStream(zipEntry);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return object;
    }

    private void createODFNode(Node node, ODFDocument oDFDocument, ODFNode oDFNode) {
        int n;
        Object object;
        if (node instanceof Element && (object = ((Element)node).getAttributes()) != null && object.getLength() > 0) {
            n = 0;
            while (n < object.getLength()) {
                ((ODFDocumentImpl)oDFDocument).getODFNode(object.item(n));
                ++n;
            }
        }
        if ((object = node.getChildNodes()) != null && object.getLength() != 0) {
            n = 0;
            while (n < object.getLength()) {
                Node node2 = object.item(n);
                ODFNode oDFNode2 = ((ODFDocumentImpl)oDFDocument).getODFNode(node2);
                this.createODFNode(node2, oDFDocument, oDFNode2);
                ++n;
            }
        }
    }

    private ODFDocument parse(InputSource inputSource) {
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = null;
        try {
            object = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        if (document == null) {
            return null;
        }
        object = document.getDocumentElement();
        ODFDocumentImpl oDFDocumentImpl = new ODFDocumentImpl(document);
        ODFNode oDFNode = (ODFNode)((Object)oDFDocumentImpl.getDocumentElement());
        this.createODFNode((Node)object, oDFDocumentImpl, oDFNode);
        return oDFDocumentImpl;
    }

    public ODFDocument getDocument(String string, String string2) {
        ODFDocument oDFDocument = null;
        try {
            InputStream inputStream = this.getFileInputStream(string, string2);
            if (inputStream != null) {
                oDFDocument = this.parse(new InputSource(inputStream));
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return oDFDocument;
    }

    public ODFDocument getDocument(String string) {
        ODFDocument oDFDocument = this.getDocument(string, "content.xml");
        ODFDocument oDFDocument2 = this.getDocument(string, "styles.xml");
        if (oDFDocument != null) {
            oDFDocument.setStyleDocument(oDFDocument2);
            oDFDocument.setURL(string);
        }
        return oDFDocument;
    }

    public String[] getFileEntries(String string) {
        ZipFile zipFile = null;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            zipFile = uRL != null ? new ZipFile(uRL.getPath()) : new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                arrayList.add(string2);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void copyFile(String string, String string2, String string3) {
        InputStream inputStream = this.getFileInputStream(string, string2);
        FileUtils.saveToFile((InputStream)inputStream, (String)string3, (boolean)true);
    }
}

