/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.io;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.internal.engines.lowvision.DebugUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.DosUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;

public class BMPReader {
    public static Int2D readInt2D(String string) throws LowVisionIOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new LowVisionIOException("The file was not found: " + string);
        }
        return BMPReader.readInt2D(fileInputStream);
    }

    public static BufferedImage readBufferedImage(String string) throws LowVisionIOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new LowVisionIOException("The file was not found: " + string);
        }
        return BMPReader.readBufferedImage(fileInputStream);
    }

    public static int getBitCount(String string) throws LowVisionIOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new LowVisionIOException("The file was not found: " + string);
        }
        return BMPReader.getBitCount(fileInputStream);
    }

    public static int getBitCount(InputStream inputStream) throws LowVisionIOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        try {
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            if (by != 66 || by2 != 77) {
                throw new LowVisionIOException("Bad magic characters: " + by + " and " + by2);
            }
            DosUtil.upsideDownInt(dataInputStream.readInt());
            dataInputStream.skipBytes(4);
            DosUtil.upsideDownInt(dataInputStream.readInt());
            DosUtil.upsideDownInt(dataInputStream.readInt());
            DosUtil.upsideDownInt(dataInputStream.readInt());
            DosUtil.upsideDownInt(dataInputStream.readInt());
            dataInputStream.skipBytes(2);
            short s = DosUtil.upsideDownShort(dataInputStream.readShort());
            if (s != 8 && s != 16 && s != 24 && s != 32) {
                throw new LowVisionIOException("Current version processes 8-bit/16-bit/24-bit/32-bit images only. The image's bitcount = " + s);
            }
            return s;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LowVisionIOException("IO error occurred when reading the header.");
        }
    }

    public static BufferedImage readBufferedImage(InputStream inputStream) throws LowVisionIOException {
        int n;
        int n2;
        short s;
        int n3;
        int n4;
        int n5;
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        try {
            byte by = dataInputStream.readByte();
            n5 = dataInputStream.readByte();
            if (by != 66 || n5 != 77) {
                throw new LowVisionIOException("Bad magic characters: " + by + " and " + n5);
            }
            int n6 = DosUtil.upsideDownInt(dataInputStream.readInt());
            dataInputStream.skipBytes(4);
            int n7 = DosUtil.upsideDownInt(dataInputStream.readInt());
            DosUtil.upsideDownInt(dataInputStream.readInt());
            n4 = DosUtil.upsideDownInt(dataInputStream.readInt());
            n3 = DosUtil.upsideDownInt(dataInputStream.readInt());
            dataInputStream.skipBytes(2);
            s = DosUtil.upsideDownShort(dataInputStream.readShort());
            if (s != 8 && s != 16 && s != 24 && s != 32) {
                throw new LowVisionIOException("Current version processes 8-bit/16-bit/24-bit/32-bit images only. The image's bitcount = " + s);
            }
            dataInputStream.skipBytes(4);
            DosUtil.upsideDownInt(dataInputStream.readInt());
            n2 = 0;
            if (s == 24) {
                n = n4 * 3 % 4;
                if (n != 0) {
                    n2 = 4 - n;
                }
            } else if (s == 16 && n4 % 2 == 1) {
                n2 = 2;
            }
            if (s == 8 && n4 * n3 + n7 != n6) {
                DebugUtil.errMsg(null, "WARNING!!  Bad file size. imageWidth=" + n4 + ", linePadding=" + n2 + ", imageHeight=" + n3 + ", offSet=" + n7 + ", fileSize=" + n6);
            }
            if (s == 24 && (n4 * 3 + n2) * n3 + n7 != n6) {
                DebugUtil.errMsg(null, "WARNING!!  Bad file size. imageWidth=" + n4 + ", linePadding=" + n2 + ", imageHeight=" + n3 + ", offSet=" + n7 + ", fileSize=" + n6);
            }
            if (s == 32 && n4 * 4 * n3 + n7 != n6) {
                DebugUtil.errMsg(null, "WARNING!!  Bad file size. imageWidth=" + n4 + ", linePadding=" + n2 + ", imageHeight=" + n3 + ", offSet=" + n7 + ", fileSize=" + n6);
            }
            dataInputStream.skipBytes(16);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LowVisionIOException("IO error occurred when reading the header.");
        }
        int[] nArray = null;
        if (s == 8) {
            try {
                byte[] byArray = new byte[1024];
                n = dataInputStream.read(byArray);
                if (n != 1024) {
                    throw new LowVisionIOException("Amount of the image data is not enough.");
                }
                nArray = new int[256];
                int n8 = 0;
                while (n8 < 256) {
                    byte by = byArray[4 * n8];
                    byte by2 = byArray[4 * n8 + 1];
                    byte by3 = byArray[4 * n8 + 2];
                    nArray[n8] = (by3 << 16) + (by2 << 8) + by;
                    ++n8;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        n5 = 0;
        if (s == 8) {
            n5 = n4;
        } else if (s == 16) {
            n5 = n4 * 2;
        } else if (s == 24) {
            n5 = n4 * 3;
        } else if (s == 32) {
            n5 = n4 * 4;
        }
        byte[][] byArray = new byte[n3][n5];
        BufferedImage bufferedImage = new BufferedImage(n4, n3, 1);
        WritableRaster writableRaster = bufferedImage.copyData(null);
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray2 = dataBufferInt.getData();
        try {
            int n9;
            int n10 = 0;
            while (n10 < n3) {
                n9 = dataInputStream.read(byArray[n10]);
                if (n9 != n5) {
                    throw new LowVisionIOException("Amount of the image data is not enough.");
                }
                dataInputStream.skipBytes(n2);
                ++n10;
            }
            n10 = 0;
            if (s == 8) {
                n9 = n3 - 1;
                while (n9 >= 0) {
                    int n11 = 0;
                    while (n11 < n4) {
                        nArray2[n10] = nArray[byArray[n9][n11]];
                        ++n10;
                        ++n11;
                    }
                    --n9;
                }
            } else if (s == 16) {
                n9 = n3 - 1;
                while (n9 >= 0) {
                    int n12 = 0;
                    while (n12 < n4) {
                        int n13;
                        int n14 = byArray[n9][n12 * 2 + 1] << 8 | byArray[n9][n12 * 2] & 0xFF;
                        int n15 = n14 & 0x1F;
                        int n16 = n14 >> 5 & 0x1F;
                        int n17 = n14 >> 10 & 0x1F;
                        nArray2[n10] = n13 = n17 << 19 | n16 << 11 | n15 << 3;
                        ++n10;
                        ++n12;
                    }
                    --n9;
                }
            } else if (s == 24) {
                n9 = n3 - 1;
                while (n9 >= 0) {
                    int n18 = 0;
                    while (n18 < n4) {
                        int n19 = 0;
                        n19 |= byArray[n9][n18 * 3] & 0xFF;
                        n19 |= (byArray[n9][n18 * 3 + 1] & 0xFF) << 8;
                        nArray2[n10] = n19 |= (byArray[n9][n18 * 3 + 2] & 0xFF) << 16;
                        ++n10;
                        ++n18;
                    }
                    --n9;
                }
            } else if (s == 32) {
                n9 = n3 - 1;
                while (n9 >= 0) {
                    int n20 = 0;
                    while (n20 < n4) {
                        int n21 = 0;
                        n21 |= byArray[n9][n20 * 4] & 0xFF;
                        n21 |= (byArray[n9][n20 * 4 + 1] & 0xFF) << 8;
                        nArray2[n10] = n21 |= (byArray[n9][n20 * 4 + 2] & 0xFF) << 16;
                        ++n10;
                        ++n20;
                    }
                    --n9;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LowVisionIOException("IO error occurred when reading the image data.");
        }
        byArray = null;
        bufferedImage.setData(writableRaster);
        try {
            dataInputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LowVisionIOException("IO error occurred when closing the input streams.");
        }
        return bufferedImage;
    }

    public static Int2D readInt2D(InputStream inputStream) throws LowVisionIOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        short s;
        int n6;
        int n7;
        int n8;
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        try {
            byte by = dataInputStream.readByte();
            n8 = dataInputStream.readByte();
            if (by != 66 || n8 != 77) {
                throw new LowVisionIOException("Bad magic characters: " + by + " and " + n8);
            }
            int n9 = DosUtil.upsideDownInt(dataInputStream.readInt());
            dataInputStream.skipBytes(4);
            int n10 = DosUtil.upsideDownInt(dataInputStream.readInt());
            DosUtil.upsideDownInt(dataInputStream.readInt());
            n7 = DosUtil.upsideDownInt(dataInputStream.readInt());
            n6 = DosUtil.upsideDownInt(dataInputStream.readInt());
            dataInputStream.skipBytes(2);
            s = DosUtil.upsideDownShort(dataInputStream.readShort());
            if (s != 8 && s != 16 && s != 24 && s != 32) {
                throw new LowVisionIOException("Current version processes 8-bit/24-bit/32-bit images only. The image's bitcount = " + s);
            }
            dataInputStream.skipBytes(4);
            DosUtil.upsideDownInt(dataInputStream.readInt());
            n5 = 0;
            if (s == 24) {
                n4 = n7 * 3 % 4;
                if (n4 != 0) {
                    n5 = 4 - n4;
                }
            } else if (s == 16 && n7 % 2 == 1) {
                n5 = 2;
            }
            if (s == 8 && n7 * n6 + n10 != n9) {
                DebugUtil.errMsg(null, "WARNING!!  Bad file size. imageWidth=" + n7 + ", linePadding=" + n5 + ", imageHeight=" + n6 + ", offSet=" + n10 + ", fileSize=" + n9);
            }
            if (s == 24 && (n7 * 3 + n5) * n6 + n10 != n9) {
                DebugUtil.errMsg(null, "WARNING!!  Bad file size. imageWidth=" + n7 + ", linePadding=" + n5 + ", imageHeight=" + n6 + ", offSet=" + n10 + ", fileSize=" + n9);
            }
            if (s == 32 && n7 * 4 * n6 + n10 != n9) {
                DebugUtil.errMsg(null, "WARNING!!  Bad file size. imageWidth=" + n7 + ", linePadding=" + n5 + ", imageHeight=" + n6 + ", offSet=" + n10 + ", fileSize=" + n9);
            }
            dataInputStream.skipBytes(16);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LowVisionIOException("IO error occurred when reading the header.");
        }
        int[] nArray = null;
        if (s == 8) {
            try {
                byte[] byArray = new byte[1024];
                n4 = dataInputStream.read(byArray);
                if (n4 != 1024) {
                    throw new LowVisionIOException("Amount of the image data is not enough.");
                }
                nArray = new int[256];
                int n11 = 0;
                while (n11 < 256) {
                    n3 = byArray[4 * n11];
                    n2 = byArray[4 * n11 + 1];
                    n = byArray[4 * n11 + 2];
                    nArray[n11] = (n << 16) + (n2 << 8) + n3;
                    ++n11;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        n8 = 0;
        if (s == 8) {
            n8 = n7;
        } else if (s == 16) {
            n8 = n7 * 2;
        } else if (s == 24) {
            n8 = n7 * 3;
        } else if (s == 32) {
            n8 = n7 * 4;
        }
        byte[][] byArray = new byte[n6][n8];
        Int2D int2D = new Int2D(n7, n6);
        try {
            n3 = 0;
            while (n3 < n6) {
                n2 = dataInputStream.read(byArray[n3]);
                if (n2 != n8) {
                    throw new LowVisionIOException("Amount of the image data is not enough.");
                }
                dataInputStream.skipBytes(n5);
                ++n3;
            }
            if (s == 8) {
                n3 = n6 - 1;
                while (n3 >= 0) {
                    n2 = 0;
                    while (n2 < n7) {
                        int2D.getData()[n6 - n3 - 1][n2] = nArray[byArray[n3][n2]];
                        ++n2;
                    }
                    --n3;
                }
            } else if (s == 16) {
                n3 = n6 - 1;
                while (n3 >= 0) {
                    n2 = 0;
                    while (n2 < n7) {
                        int n12;
                        n = byArray[n3][n2 * 2 + 1] << 8 | byArray[n3][n2 * 2] & 0xFF;
                        int n13 = n & 0x1F;
                        int n14 = n >> 5 & 0x1F;
                        int n15 = n >> 10 & 0x1F;
                        int2D.getData()[n6 - n3 - 1][n2] = n12 = n15 << 19 | n14 << 11 | n13 << 3;
                        ++n2;
                    }
                    --n3;
                }
            } else if (s == 24) {
                n3 = n6 - 1;
                while (n3 >= 0) {
                    n2 = 0;
                    while (n2 < n7) {
                        n = 0;
                        n |= byArray[n3][n2 * 3] & 0xFF;
                        n |= (byArray[n3][n2 * 3 + 1] & 0xFF) << 8;
                        int2D.getData()[n6 - n3 - 1][n2] = n |= (byArray[n3][n2 * 3 + 2] & 0xFF) << 16;
                        ++n2;
                    }
                    --n3;
                }
            } else if (s == 32) {
                n3 = n6 - 1;
                while (n3 >= 0) {
                    n2 = 0;
                    while (n2 < n7) {
                        n = 0;
                        n |= byArray[n3][n2 * 4] & 0xFF;
                        n |= (byArray[n3][n2 * 4 + 1] & 0xFF) << 8;
                        int2D.getData()[n6 - n3 - 1][n2] = n |= (byArray[n3][n2 * 4 + 2] & 0xFF) << 16;
                        ++n2;
                    }
                    --n3;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LowVisionIOException("IO error occurred when reading the image data.");
        }
        byArray = null;
        try {
            dataInputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LowVisionIOException("IO error occurred when closing the input streams.");
        }
        return int2D;
    }
}

