/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.errorhandler;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.model.dom.html.IParser;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.html.parser.HTMLParser;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLDocument;
import org.eclipse.actf.model.internal.dom.sgml.impl.EndTag;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RangeExpander
implements IErrorHandler {
    public boolean handleError(int n, IParser iParser, Node node) throws ParseException, IOException, SAXException {
        if (n != 6 || !(node instanceof EndTag)) {
            return false;
        }
        Vector<Element> vector = new Vector<Element>();
        Node node2 = iParser.getContext();
        while (node2 instanceof Element) {
            String string = node2.getNodeName();
            if (string.equalsIgnoreCase(node.getNodeName())) {
                iParser.setContext((Element)node2.getParentNode());
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Element element = (Element)enumeration.nextElement();
                    iParser.getContext().appendChild(element);
                    iParser.setContext(element);
                }
                return true;
            }
            vector.addElement(iParser.getDocument().createElement(string));
            node2 = node2.getParentNode();
        }
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            HTMLParser hTMLParser = new HTMLParser();
            hTMLParser.addErrorLogListener(new IErrorLogListener(){

                public void errorLog(int n, String string) {
                    System.err.println(string);
                }
            });
            hTMLParser.setErrorHandler(new RangeExpander());
            hTMLParser.parse(new FileInputStream(stringArray[0]));
            ((ISGMLDocument)hTMLParser.getDocument()).printAsSGML(new PrintWriter(System.out), false);
        }
        catch (Exception exception) {}
    }
}

