/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.viatra.query;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.services.AbstractMetaModelService;
import org.eclipse.sphinx.emf.query.IModelQueryService;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.viatra.query.IViatraQueryEngineHelper;
import org.eclipse.sphinx.emf.viatra.query.ViatraQueryEngineHelper;
import org.eclipse.sphinx.emf.viatra.query.internal.Activator;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

public class BasicViatraModelQueryService
extends AbstractMetaModelService
implements IModelQueryService {
    private IViatraQueryEngineHelper viatraQueryEngineHelper;

    public BasicViatraModelQueryService(Collection<IMetaModelDescriptor> mmDescriptors) {
        super(mmDescriptors);
    }

    protected IViatraQueryEngineHelper getViatraQueryEngineHelper() {
        if (this.viatraQueryEngineHelper == null) {
            this.viatraQueryEngineHelper = this.createViatraQueryEngineHelper();
        }
        return this.viatraQueryEngineHelper;
    }

    protected IViatraQueryEngineHelper createViatraQueryEngineHelper() {
        return new ViatraQueryEngineHelper();
    }

    protected EClass getEClassForType(Class<?> type) {
        for (IMetaModelDescriptor mmDescriptor : this.getMetaModelDescriptors()) {
            for (EPackage ePackage : mmDescriptor.getEPackages()) {
                EClassifier eClassifier = EObjectUtil.findEClassifier((EPackage)ePackage, type);
                if (!(eClassifier instanceof EClass)) continue;
                return (EClass)eClassifier;
            }
        }
        return null;
    }

    public <T> List<T> getAllInstancesOf(EObject contextObject, Class<T> type) {
        return this.getAllInstancesOf(contextObject.eResource(), type);
    }

    public <T> List<T> getAllInstancesOf(Resource contextResource, Class<T> type) {
        try {
            ViatraQueryEngine engine = this.getViatraQueryEngineHelper().getEngine(contextResource);
            return this.doGetAllInstancesOf(type, engine);
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            return Collections.emptyList();
        }
    }

    protected <T> List<T> doGetAllInstancesOf(Class<T> type, ViatraQueryEngine engine) throws ViatraQueryException, InvocationTargetException {
        Assert.isNotNull(type);
        final NavigationHelper baseIndex = EMFScope.extractUnderlyingEMFIndex((ViatraQueryEngine)engine);
        final EClass eClass = this.getEClassForType(type);
        baseIndex.coalesceTraversals((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                baseIndex.registerEClasses(Collections.singleton(eClass), IndexingLevel.FULL);
                return null;
            }
        });
        ArrayList<T> instances = new ArrayList<T>();
        for (EObject instance : baseIndex.getAllInstances(eClass)) {
            instances.add(type.cast(instance));
        }
        return instances;
    }
}

