/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.wizards.pages;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.emf.workspace.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.ui.wizards.pages.CreateLinkedResourceGroup;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class LinkedFileCreationMainPage
extends WizardPage
implements Listener {
    private IStructuredSelection currentSelection;
    private IFile newFile;
    private URI linkTargetPath;
    private CreateLinkedResourceGroup linkedResourceGroup;
    private Composite linkedResourceParent;
    private Composite linkedResourceComposite;
    private String initialFileName;
    private String initialFileExtension;
    private IPath initialContainerFullPath;
    private int linkedResourceGroupHeight = -1;
    private boolean firstLinkCheck = true;
    private String[] filterExtensions = new String[0];

    public LinkedFileCreationMainPage(IStructuredSelection selection) {
        super(Messages.wizardNewLinkedFileCreationPage_title.replaceAll("[^A-Z]", ""));
        this.setTitle(Messages.wizardNewLinkedFileCreationPage_title);
        this.setDescription(Messages.wizardNewLinkedFileCreationPage_description);
        this.setPageComplete(false);
        this.currentSelection = selection;
        this.setContainerFullPath(this.currentSelection);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        topLevel.setLayout((Layout)layout);
        GridData gridData = new GridData(272);
        topLevel.setLayoutData((Object)gridData);
        topLevel.setFont(parent.getFont());
        this.doCreateControls(topLevel);
        if (this.initialFileName != null) {
            this.setFileName(this.initialFileName);
        }
        if (this.initialFileExtension != null) {
            this.setFileExtension(this.initialFileExtension);
        }
        this.validatePage();
        this.setControl((Control)topLevel);
    }

    protected void doCreateControls(Composite parent) {
        boolean disableLinking = Platform.getPreferencesService().getBoolean(ResourcesPlugin.getPlugin().getBundle().getSymbolicName(), "description.disableLinking", false, null);
        if (!disableLinking) {
            this.linkedResourceParent = new Composite(parent, 0);
            this.linkedResourceParent.setFont(parent.getFont());
            this.linkedResourceParent.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.linkedResourceParent.setLayout((Layout)layout);
        }
        this.linkedResourceGroup = new CreateLinkedResourceGroup(1, new Listener(){

            public void handleEvent(Event e) {
                LinkedFileCreationMainPage.this.firstLinkCheck = false;
                LinkedFileCreationMainPage.this.setPageComplete(LinkedFileCreationMainPage.this.validatePage());
            }
        }, new CreateLinkedResourceGroup.IStringValue(){

            @Override
            public void setValue(String string) {
                LinkedFileCreationMainPage.this.setFileName(string);
            }

            @Override
            public String getValue() {
                return LinkedFileCreationMainPage.this.getFileName();
            }
        });
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            this.linkedResourceGroup.setFilterExtensions(this.filterExtensions);
        }
        this.doShellResizing(parent);
    }

    protected IFile createFileHandle(IPath filePath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
    }

    protected void createLinkTarget() {
        this.linkTargetPath = this.linkedResourceGroup.getLinkTargetURI();
    }

    public IFile createNewFile() {
        if (this.newFile != null) {
            return this.newFile;
        }
        IPath containerPath = this.getContainerFullPath();
        IPath newFilePath = containerPath.append(this.getFileName());
        final IFile newFileHandle = this.createFileHandle(newFilePath);
        final InputStream initialContents = this.getInitialContents();
        this.createLinkTarget();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CreateFileOperation op = new CreateFileOperation(newFileHandle, LinkedFileCreationMainPage.this.linkTargetPath, initialContents, Messages.wizardNewLinkedFileCreationPage_title);
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)LinkedFileCreationMainPage.this.getShell()));
                }
                catch (ExecutionException e) {
                    LinkedFileCreationMainPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)LinkedFileCreationMainPage.this.getContainer().getShell(), (String)Messages.wizardNewLinkedFileCreationPage_errorTitle, null, (IStatus)((CoreException)e.getCause()).getStatus());
                            } else {
                                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)("createLinkedFile(): " + e.getCause()));
                                MessageDialog.openError((Shell)LinkedFileCreationMainPage.this.getContainer().getShell(), (String)Messages.wizardNewLinkedFileCreationPage_internalErrorTitle, (String)NLS.bind((String)Messages.wizardNewLinkedFileCreationPage_internalErrorMessage, (Object)e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)("createLinkedFile()" + e.getTargetException()));
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.wizardNewLinkedFileCreationPage_internalErrorTitle, (String)NLS.bind((String)Messages.wizardNewLinkedFileCreationPage_internalErrorMessage, (Object)e.getTargetException().getMessage()));
            return null;
        }
        this.newFile = newFileHandle;
        return this.newFile;
    }

    public IPath getContainerFullPath() {
        return this.initialContainerFullPath;
    }

    public String getFileName() {
        return this.initialFileName;
    }

    protected InputStream getInitialContents() {
        return null;
    }

    protected void doShellResizing(Composite parent) {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = parent;
        if (this.linkedResourceComposite != null) {
            this.linkedResourceComposite.dispose();
            this.linkedResourceComposite = null;
            composite.layout();
            shell.setSize(shellSize.x, shellSize.y - this.linkedResourceGroupHeight);
        } else {
            this.linkedResourceComposite = this.linkedResourceGroup.createContents(this.linkedResourceParent);
            if (this.linkedResourceGroupHeight == -1) {
                Point groupSize = this.linkedResourceComposite.computeSize(-1, -1, true);
                this.linkedResourceGroupHeight = groupSize.y;
            }
            shell.setSize(600, 300 + this.linkedResourceGroupHeight);
            composite.layout();
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    private void setContainerFullPath(IStructuredSelection currentSelection) {
        Iterator it = currentSelection.iterator();
        if (it.hasNext()) {
            Object object = it.next();
            IResource selectedResource = null;
            if (object instanceof IResource) {
                selectedResource = (IResource)object;
            } else if (object instanceof IAdaptable) {
                selectedResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
            }
            if (selectedResource != null) {
                if (selectedResource.getType() == 1) {
                    selectedResource = selectedResource.getParent();
                }
                this.initialContainerFullPath = selectedResource.getFullPath();
            }
        }
    }

    public void setFileName(String value) {
        this.initialFileName = value;
    }

    public void setFileExtension(String value) {
        this.initialFileExtension = value;
    }

    protected IStatus validateLinkedResource() {
        IPath containerPath = this.getContainerFullPath();
        IPath newFilePath = containerPath.append(this.getFileName());
        IFile newFileHandle = this.createFileHandle(newFilePath);
        IStatus status = this.linkedResourceGroup.validateLinkLocation((IResource)newFileHandle);
        if (status.getSeverity() == 4) {
            if (this.firstLinkCheck) {
                this.setMessage(status.getMessage());
            } else {
                this.setErrorMessage(status.getMessage());
            }
        } else if (status.getSeverity() == 2) {
            this.setMessage(status.getMessage(), 2);
            this.setErrorMessage(null);
        }
        return status;
    }

    protected boolean validatePage() {
        boolean valid = true;
        this.setMessage(null);
        this.setErrorMessage(null);
        IPath containerFullPath = this.getContainerFullPath();
        if (containerFullPath == null || containerFullPath.segmentCount() == 0) {
            valid = false;
            this.setErrorMessage(Messages.wizardNewLinkedFileCreationPage_noParentSelected);
        } else {
            String containerProjectName = containerFullPath.segment(0);
            IProject containerProject = ResourcesPlugin.getWorkspace().getRoot().getProject(containerProjectName);
            if (!containerProject.isOpen()) {
                valid = false;
                this.setErrorMessage(Messages.wizardNewLinkedFileCreationPage_selectedParentProjectNotOpen);
            }
        }
        if (valid) {
            String fileName = this.getFileName();
            IStatus result = ResourcesPlugin.getWorkspace().validateName(fileName, 1);
            if (!result.isOK()) {
                valid = false;
                if (!this.firstLinkCheck) {
                    this.setErrorMessage(result.getMessage());
                }
            }
        }
        IStatus linkedResourceStatus = null;
        if (valid && (linkedResourceStatus = this.validateLinkedResource()).getSeverity() == 4) {
            valid = false;
        }
        return valid;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }
}

