/**
 * <copyright>
 * 
 * Copyright (c) 2016 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.examples.workflows.simple.xtend;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.sphinx.emf.mwe.dynamic.annotations.WorkflowParameter;
import org.eclipse.sphinx.emf.mwe.dynamic.components.AbstractModelWorkflowComponent;
import org.eclipse.sphinx.examples.workflows.lib.ModelWorkflowExtensions;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class SimpleXtendWorkflowComponentWithParams extends AbstractModelWorkflowComponent {
  @WorkflowParameter
  private boolean boolComponentParam;
  
  @WorkflowParameter
  private String strComponentParam;
  
  @WorkflowParameter
  private URI uriComponentParam;
  
  @WorkflowParameter("componentParamWithAlias")
  private String otherComponentParam;
  
  protected void invokeInternal(final WorkflowContext ctx, final ProgressMonitor monitor, final Issues issues) {
    InputOutput.<String>println("Executing simple Xtend-based workflow component with parameters");
    InputOutput.<String>println(("boolComponentParam = " + Boolean.valueOf(this.boolComponentParam)));
    InputOutput.<String>println(("strComponentParam = " + this.strComponentParam));
    InputOutput.<String>println(("uriComponentParam = " + this.uriComponentParam));
    InputOutput.<String>println(("otherComponentParam (componentParamWithAlias) = " + this.otherComponentParam));
    Map<String, Object> _argumentsSlot = ModelWorkflowExtensions.getArgumentsSlot(ctx);
    String _plus = ("Arguments: " + _argumentsSlot);
    InputOutput.<String>println(_plus);
    InputOutput.<String>println("Done!");
  }
}
