/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.SailReadOnlyException;
import org.eclipse.rdf4j.sail.base.SailSourceConnection;
import org.eclipse.rdf4j.sail.features.ThreadSafetyAware;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.DefaultSailChangedEvent;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;

public class NativeStoreConnection
extends SailSourceConnection
implements ThreadSafetyAware {
    protected final NativeStore nativeStore;
    private volatile DefaultSailChangedEvent sailChangedEvent;
    private Lock txnLock;
    private int addedCount;

    protected NativeStoreConnection(NativeStore sail) {
        super((AbstractSail)sail, sail.getSailStore(), sail.getEvaluationStrategyFactory());
        this.nativeStore = sail;
        this.sailChangedEvent = new DefaultSailChangedEvent(sail);
    }

    @Override
    protected void startTransactionInternal() throws SailException {
        this.addedCount = 0;
        if (!this.nativeStore.isWritable()) {
            throw new SailReadOnlyException("Unable to start transaction: data file is locked or read-only");
        }
        assert (this.txnLock == null) : "Can not start another transaction before the previous one finishes!";
        this.txnLock = this.nativeStore.getTransactionLock(this.getTransactionIsolation());
        super.startTransactionInternal();
    }

    @Override
    protected void commitInternal() throws SailException {
        try {
            super.commitInternal();
        }
        finally {
            this.txnLock.release();
            this.txnLock = null;
        }
        this.nativeStore.notifySailChanged(this.sailChangedEvent);
        this.sailChangedEvent = new DefaultSailChangedEvent(this.nativeStore);
    }

    @Override
    protected void rollbackInternal() throws SailException {
        try {
            super.rollbackInternal();
        }
        finally {
            this.txnLock.release();
            this.txnLock = null;
        }
        this.sailChangedEvent = new DefaultSailChangedEvent(this.nativeStore);
    }

    @Override
    protected void addStatementInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsAdded(true);
        if (this.getTransactionIsolation() == IsolationLevels.NONE && ++this.addedCount % 100000 == 0) {
            this.flushUpdates();
            this.addedCount = 0;
        }
    }

    @Override
    public boolean addInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.addInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsAdded(true);
        if (this.getTransactionIsolation() == IsolationLevels.NONE && ++this.addedCount % 100000 == 0) {
            this.flushUpdates();
            this.addedCount = 0;
        }
        return ret;
    }

    @Override
    protected void removeStatementsInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    @Override
    public boolean removeInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.removeInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
        return ret;
    }

    @Override
    protected void clearInternal(Resource ... contexts) throws SailException {
        super.clearInternal(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    @Override
    public void clearInferred(Resource ... contexts) throws SailException {
        super.clearInferred(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    @Override
    public boolean supportsConcurrentReads() {
        return this.getTransactionIsolation() != null && this.getTransactionIsolation() != IsolationLevels.SERIALIZABLE;
    }
}

