/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.core.query;

import java.util.Optional;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expression;
import org.eclipse.rdf4j.sparqlbuilder.core.Dataset;
import org.eclipse.rdf4j.sparqlbuilder.core.From;
import org.eclipse.rdf4j.sparqlbuilder.core.GroupBy;
import org.eclipse.rdf4j.sparqlbuilder.core.Groupable;
import org.eclipse.rdf4j.sparqlbuilder.core.Having;
import org.eclipse.rdf4j.sparqlbuilder.core.OrderBy;
import org.eclipse.rdf4j.sparqlbuilder.core.Orderable;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryElement;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryPattern;
import org.eclipse.rdf4j.sparqlbuilder.core.SparqlBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfBlankNode;
import org.eclipse.rdf4j.sparqlbuilder.util.SparqlBuilderUtils;

public abstract class Query<T extends Query<T>>
implements QueryElement {
    protected static final String LIMIT = "LIMIT";
    protected static final String OFFSET = "OFFSET";
    protected Optional<Dataset> from = Optional.empty();
    protected QueryPattern where = SparqlBuilder.where(new GraphPattern[0]);
    protected Optional<GroupBy> groupBy = Optional.empty();
    protected Optional<OrderBy> orderBy = Optional.empty();
    protected Optional<Having> having = Optional.empty();
    protected int limit = -1;
    protected int offset = -1;
    protected int varCount = -1;
    protected int bnodeCount = -1;

    public T from(From ... graphs) {
        this.from = SparqlBuilderUtils.getOrCreateAndModifyOptional(this.from, () -> SparqlBuilder.dataset(new From[0]), f -> f.from(graphs));
        return (T)this;
    }

    public T from(Dataset from) {
        this.from = Optional.of(from);
        return (T)this;
    }

    public T where(GraphPattern ... queryPatterns) {
        this.where.where(queryPatterns);
        return (T)this;
    }

    public T where(QueryPattern where) {
        this.where = where;
        return (T)this;
    }

    public T groupBy(Groupable ... groupables) {
        this.groupBy = SparqlBuilderUtils.getOrCreateAndModifyOptional(this.groupBy, () -> SparqlBuilder.groupBy(new Groupable[0]), gb -> gb.by(groupables));
        return (T)this;
    }

    public T groupBy(GroupBy groupBy) {
        this.groupBy = Optional.of(groupBy);
        return (T)this;
    }

    public T orderBy(Orderable ... conditions) {
        this.orderBy = SparqlBuilderUtils.getOrCreateAndModifyOptional(this.orderBy, () -> SparqlBuilder.orderBy(new Orderable[0]), ob -> ob.by(conditions));
        return (T)this;
    }

    public T orderBy(OrderBy orderBy) {
        this.orderBy = Optional.of(orderBy);
        return (T)this;
    }

    public T having(Expression<?> ... constraints) {
        this.having = SparqlBuilderUtils.getOrCreateAndModifyOptional(this.having, () -> SparqlBuilder.having(new Expression[0]), h -> h.having(constraints));
        return (T)this;
    }

    public T having(Having having) {
        this.having = Optional.of(having);
        return (T)this;
    }

    public T limit(int limit) {
        this.limit = limit;
        return (T)this;
    }

    public T offset(int offset) {
        this.offset = offset;
        return (T)this;
    }

    public Variable var() {
        return SparqlBuilder.var("x" + ++this.varCount);
    }

    public RdfBlankNode.LabeledBlankNode bNode() {
        return Rdf.bNode("b" + ++this.bnodeCount);
    }

    protected abstract String getQueryActionString();

    @Override
    public String getQueryString() {
        StringBuilder query = new StringBuilder();
        query.append(this.getQueryActionString()).append("\n");
        SparqlBuilderUtils.appendAndNewlineIfPresent(this.from, query);
        query.append(this.where.getQueryString()).append("\n");
        SparqlBuilderUtils.appendAndNewlineIfPresent(this.groupBy, query);
        SparqlBuilderUtils.appendAndNewlineIfPresent(this.having, query);
        SparqlBuilderUtils.appendAndNewlineIfPresent(this.orderBy, query);
        if (this.limit >= 0) {
            query.append("LIMIT ").append(this.limit).append("\n");
        }
        if (this.offset >= 0) {
            query.append("OFFSET ").append(this.offset).append("\n");
        }
        return query.toString();
    }
}

