/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class UnionNode
implements PlanNode {
    private final HashSet<PlanNode> nodesSet;
    private StackTraceElement[] stackTrace;
    private final PlanNode[] nodes;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    private UnionNode(PlanNode ... nodes) {
        this.nodes = nodes;
        this.nodesSet = new HashSet<PlanNode>(Arrays.asList(nodes));
    }

    public static PlanNode getInstance(PlanNode ... nodes) {
        PlanNode[] planNodes = (PlanNode[])Arrays.stream(nodes).filter(n -> !n.isGuaranteedEmpty()).flatMap(n -> {
            if (n instanceof UnionNode) {
                return Arrays.stream(((UnionNode)n).nodes);
            }
            return Stream.of(n);
        }).map(n -> PlanNodeHelper.handleSorting(true, n)).toArray(PlanNode[]::new);
        if (planNodes.length == 1) {
            return planNodes[0];
        }
        if (planNodes.length == 0) {
            return EmptyNode.getInstance();
        }
        return new UnionNode(planNodes);
    }

    public static PlanNode getInstanceDedupe(PlanNode ... nodes) {
        PlanNode[] planNodes = (PlanNode[])Arrays.stream(nodes).filter(n -> !n.isGuaranteedEmpty()).distinct().flatMap(n -> {
            if (n instanceof UnionNode) {
                return Arrays.stream(((UnionNode)n).nodes);
            }
            return Stream.of(n);
        }).map(n -> PlanNodeHelper.handleSorting(true, n)).toArray(PlanNode[]::new);
        if (planNodes.length == 1) {
            return planNodes[0];
        }
        if (planNodes.length == 0) {
            return EmptyNode.getInstance();
        }
        return new UnionNode(planNodes);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        if (this.nodes.length == 1) {
            return new LoggingCloseableIteration(this, this.validationExecutionLogger){
                private CloseableIteration<? extends ValidationTuple> iterator;

                @Override
                protected void init() {
                    this.iterator = UnionNode.this.nodes[0].iterator();
                }

                @Override
                public void localClose() {
                    if (this.iterator != null) {
                        this.iterator.close();
                    }
                }

                @Override
                protected ValidationTuple loggingNext() {
                    return (ValidationTuple)this.iterator.next();
                }

                @Override
                protected boolean localHasNext() {
                    return this.iterator.hasNext();
                }
            };
        }
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            private CloseableIteration<? extends ValidationTuple>[] iterators;
            final ValidationTuple[] peekList;
            ValidationTuple next;
            ValidationTuple prev;
            {
                this.peekList = new ValidationTuple[UnionNode.this.nodes.length];
            }

            @Override
            protected void init() {
                this.iterators = (CloseableIteration[])Arrays.stream(UnionNode.this.nodes).map(PlanNode::iterator).toArray(CloseableIteration[]::new);
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                for (int i = 0; i < this.peekList.length; ++i) {
                    CloseableIteration<? extends ValidationTuple> iterator;
                    if (this.peekList[i] != null || !(iterator = this.iterators[i]).hasNext()) continue;
                    this.peekList[i] = (ValidationTuple)iterator.next();
                }
                ValidationTuple sortedFirst = null;
                int sortedFirstIndex = -1;
                for (int i = 0; i < this.peekList.length; ++i) {
                    if (this.peekList[i] == null) continue;
                    if (sortedFirst == null) {
                        sortedFirst = this.peekList[i];
                        sortedFirstIndex = i;
                        continue;
                    }
                    if (this.peekList[i].compareActiveTarget(sortedFirst) >= 0) continue;
                    sortedFirst = this.peekList[i];
                    sortedFirstIndex = i;
                }
                if (sortedFirstIndex >= 0) {
                    this.peekList[sortedFirstIndex] = null;
                }
                this.next = sortedFirst;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void localClose() {
                if (this.iterators != null) {
                    Throwable thrown = null;
                    for (int i = 0; i < this.iterators.length; ++i) {
                        try {
                            this.iterators[i].close();
                            continue;
                        }
                        catch (Throwable t) {
                            if (thrown != null) {
                                thrown.addSuppressed(t);
                                continue;
                            }
                            thrown = t;
                            continue;
                        }
                        finally {
                            this.iterators[i] = null;
                        }
                    }
                    if (thrown != null) {
                        throw new SailException(thrown);
                    }
                }
            }

            @Override
            protected boolean localHasNext() {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            protected ValidationTuple loggingNext() {
                this.calculateNext();
                assert (this.prev == null || this.next.compareActiveTarget(this.prev) >= 0);
                ValidationTuple temp = this.next;
                this.prev = this.next;
                this.next = null;
                return temp;
            }
        };
    }

    @Override
    public int depth() {
        return Arrays.stream(this.nodes).mapToInt(PlanNode::depth).max().orElse(0) + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        for (PlanNode node : this.nodes) {
            stringBuilder.append(node.getId() + " -> " + this.getId()).append("\n");
            node.getPlanAsGraphvizDot(stringBuilder);
        }
    }

    public String toString() {
        return "UnionNode";
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        for (PlanNode node : this.nodes) {
            node.receiveLogger(validationExecutionLogger);
        }
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionNode unionNode = (UnionNode)o;
        if (this.nodes.length != unionNode.nodes.length) {
            return false;
        }
        return this.nodesSet.equals(unionNode.nodesSet);
    }

    public int hashCode() {
        return this.nodes.length + this.nodesSet.hashCode();
    }
}

