/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.Arrays;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;

public class ShaclSparqlConstraintFailureException
extends RDF4JException {
    private final Shape shape;
    private final String query;
    private final BindingSet resultBindingSet;
    private final Value focusNode;
    private final Resource[] dataGraph;

    public ShaclSparqlConstraintFailureException(Shape shape, String query, BindingSet resultBindingSet, Value focusNode, Resource[] dataGraph) {
        super("The ?failure variable was true for " + ShaclSparqlConstraintFailureException.valueToString(focusNode) + " in shape " + ShaclSparqlConstraintFailureException.resourceToString(shape.getId()) + " with result resultBindingSet: " + resultBindingSet.toString() + " and dataGraph: " + Arrays.toString(dataGraph) + " and query:" + query);
        this.shape = shape;
        this.query = query;
        this.resultBindingSet = resultBindingSet;
        this.focusNode = focusNode;
        this.dataGraph = dataGraph;
    }

    public String getShape() {
        return this.shape.toString();
    }

    public String getQuery() {
        return this.query;
    }

    public BindingSet getResultBindingSet() {
        return this.resultBindingSet;
    }

    public Value getFocusNode() {
        return this.focusNode;
    }

    public Resource[] getDataGraph() {
        return this.dataGraph;
    }

    private static String resourceToString(Resource id) {
        assert (id != null);
        if (id == null) {
            return "null";
        }
        if (id.isIRI()) {
            return "<" + id.stringValue() + ">";
        }
        if (id.isBNode()) {
            return id.toString();
        }
        if (id.isTriple()) {
            return "TRIPLE " + id;
        }
        return id.toString();
    }

    private static String valueToString(Value value) {
        assert (value != null);
        if (value == null) {
            return "null";
        }
        if (value.isResource()) {
            return ShaclSparqlConstraintFailureException.resourceToString((Resource)value);
        }
        if (value.isLiteral()) {
            return value.toString();
        }
        return value.toString();
    }
}

