/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.LmdbContextIdIterator;
import org.eclipse.rdf4j.sail.lmdb.LmdbRecordIterator;
import org.eclipse.rdf4j.sail.lmdb.LmdbUtil;
import org.eclipse.rdf4j.sail.lmdb.Pool;
import org.eclipse.rdf4j.sail.lmdb.RecordIterator;
import org.eclipse.rdf4j.sail.lmdb.Statistics;
import org.eclipse.rdf4j.sail.lmdb.TxnManager;
import org.eclipse.rdf4j.sail.lmdb.TxnRecordCache;
import org.eclipse.rdf4j.sail.lmdb.Varint;
import org.eclipse.rdf4j.sail.lmdb.config.LmdbStoreConfig;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;
import org.lwjgl.util.lmdb.MDBEnvInfo;
import org.lwjgl.util.lmdb.MDBStat;
import org.lwjgl.util.lmdb.MDBVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TripleStore
implements Closeable {
    static final int SUBJ_IDX = 0;
    static final int PRED_IDX = 1;
    static final int OBJ_IDX = 2;
    static final int CONTEXT_IDX = 3;
    static final int MAX_KEY_LENGTH = 36;
    private static final String DEFAULT_INDEXES = "spoc,posc";
    private static final String PROPERTIES_FILE = "triples.prop";
    private static final String VERSION_KEY = "version";
    private static final String INDEXES_KEY = "triple-indexes";
    private static final int SCHEME_VERSION = 1;
    private static final Logger logger = LoggerFactory.getLogger(TripleStore.class);
    private final File dir;
    private final Properties properties;
    private final List<TripleIndex> indexes = new ArrayList<TripleIndex>();
    private long env;
    private int contextsDbi;
    private int pageSize;
    private final boolean forceSync;
    private final boolean autoGrow;
    private long mapSize;
    private long writeTxn;
    private final TxnManager txnManager;
    private final Pool pool = new Pool();
    private TxnRecordCache recordCache = null;
    static final Comparator<ByteBuffer> COMPARATOR = new Comparator<ByteBuffer>(){

        @Override
        public int compare(ByteBuffer b1, ByteBuffer b2) {
            int b1Len = b1.remaining();
            int b2Len = b2.remaining();
            int diff = this.compareRegion(b1, b1.position(), b2, b2.position(), Math.min(b1Len, b2Len));
            if (diff != 0) {
                return diff;
            }
            return b1Len > b2Len ? 1 : -1;
        }

        public int compareRegion(ByteBuffer array1, int startIdx1, ByteBuffer array2, int startIdx2, int length) {
            int result = 0;
            for (int i = 0; result == 0 && i < length; ++i) {
                result = (array1.get(startIdx1 + i) & 0xFF) - (array2.get(startIdx2 + i) & 0xFF);
            }
            return result;
        }
    };

    TripleStore(File dir, LmdbStoreConfig config) throws IOException, SailException {
        this.dir = dir;
        this.forceSync = config.getForceSync();
        this.autoGrow = config.getAutoGrow();
        this.dir.mkdirs();
        try (MemoryStack stack2 = MemoryStack.stackPush();){
            PointerBuffer pp = stack2.mallocPointer(1);
            LmdbUtil.E(LMDB.mdb_env_create((PointerBuffer)pp));
            this.env = pp.get(0);
        }
        LmdbUtil.E(LMDB.mdb_env_set_maxdbs((long)this.env, (int)12));
        LmdbUtil.E(LMDB.mdb_env_set_maxreaders((long)this.env, (int)256));
        int flags = 0x200000;
        if (!this.forceSync) {
            flags |= 0x50000;
        }
        LmdbUtil.E(LMDB.mdb_env_open((long)this.env, (CharSequence)this.dir.getAbsolutePath(), (int)flags, (int)436));
        this.contextsDbi = LmdbUtil.transaction(this.env, (stack, txn) -> {
            String name = "contexts";
            IntBuffer ip = stack.mallocInt(1);
            if (LMDB.mdb_dbi_open((long)txn, (CharSequence)name, (int)0, (IntBuffer)ip) == -30798) {
                LmdbUtil.E(LMDB.mdb_dbi_open((long)txn, (CharSequence)name, (int)262144, (IntBuffer)ip));
            }
            return ip.get(0);
        });
        this.txnManager = new TxnManager(this.env, TxnManager.Mode.RESET);
        File propFile = new File(this.dir, PROPERTIES_FILE);
        String indexSpecStr = config.getTripleIndexes();
        if (!propFile.exists()) {
            this.properties = new Properties();
            Set<String> indexSpecs = this.parseIndexSpecList(indexSpecStr);
            if (indexSpecs.isEmpty()) {
                logger.debug("No indexes specified, using default indexes: {}", (Object)DEFAULT_INDEXES);
                indexSpecStr = DEFAULT_INDEXES;
                indexSpecs = this.parseIndexSpecList(indexSpecStr);
            }
            this.initIndexes(indexSpecs, config.getTripleDBSize());
        } else {
            this.properties = this.loadProperties(propFile);
            this.checkVersion();
            Set<String> indexSpecs = this.getIndexSpecs();
            this.initIndexes(indexSpecs, config.getTripleDBSize());
            Set<String> reqIndexSpecs = this.parseIndexSpecList(indexSpecStr);
            if (reqIndexSpecs.isEmpty()) {
                indexSpecStr = this.properties.getProperty(INDEXES_KEY);
            } else if (!reqIndexSpecs.equals(indexSpecs)) {
                this.reindex(indexSpecs, reqIndexSpecs);
            }
        }
        if (!String.valueOf(1).equals(this.properties.getProperty(VERSION_KEY)) || !indexSpecStr.equals(this.properties.getProperty(INDEXES_KEY))) {
            this.properties.setProperty(VERSION_KEY, String.valueOf(1));
            this.properties.setProperty(INDEXES_KEY, indexSpecStr);
            this.storeProperties(propFile);
        }
    }

    private void checkVersion() throws SailException {
        String versionStr = this.properties.getProperty(VERSION_KEY);
        if (versionStr == null) {
            logger.warn("{} missing in TripleStore's properties file", (Object)VERSION_KEY);
        } else {
            try {
                int version = Integer.parseInt(versionStr);
                if (version > 1) {
                    throw new SailException("Directory contains data that uses a newer data format");
                }
            }
            catch (NumberFormatException e) {
                logger.warn("Malformed version number in TripleStore's properties file");
            }
        }
    }

    private Set<String> getIndexSpecs() throws SailException {
        String indexesStr = this.properties.getProperty(INDEXES_KEY);
        if (indexesStr == null) {
            throw new SailException("triple-indexes missing in TripleStore's properties file");
        }
        Set<String> indexSpecs = this.parseIndexSpecList(indexesStr);
        if (indexSpecs.isEmpty()) {
            throw new SailException("No triple-indexes found in TripleStore's properties file");
        }
        return indexSpecs;
    }

    TxnManager getTxnManager() {
        return this.txnManager;
    }

    private Set<String> parseIndexSpecList(String indexSpecStr) throws SailException {
        HashSet<String> indexes = new HashSet<String>();
        if (indexSpecStr != null) {
            StringTokenizer tok = new StringTokenizer(indexSpecStr, ", \t");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken().toLowerCase();
                if (index.length() != 4 || index.indexOf(115) == -1 || index.indexOf(112) == -1 || index.indexOf(111) == -1 || index.indexOf(99) == -1) {
                    throw new SailException("invalid value '" + index + "' in index specification: " + indexSpecStr);
                }
                indexes.add(index);
            }
        }
        return indexes;
    }

    private void initIndexes(Set<String> indexSpecs, long tripleDbSize) throws IOException {
        for (String fieldSeq : indexSpecs) {
            logger.trace("Initializing index '{}'...", (Object)fieldSeq);
            this.indexes.add(new TripleIndex(fieldSeq));
        }
        LmdbUtil.readTransaction(this.env, (stack, txn) -> {
            MDBStat stat = MDBStat.malloc((MemoryStack)stack);
            TripleIndex mainIndex = this.indexes.get(0);
            LMDB.mdb_stat((long)txn, (int)mainIndex.getDB(true), (MDBStat)stat);
            boolean isEmpty = stat.ms_entries() == 0L;
            this.pageSize = stat.ms_psize();
            long configMapSize = tripleDbSize / (long)this.pageSize * (long)this.pageSize;
            if (isEmpty) {
                LMDB.mdb_env_set_mapsize((long)this.env, (long)configMapSize);
            }
            MDBEnvInfo info = MDBEnvInfo.malloc((MemoryStack)stack);
            LMDB.mdb_env_info((long)this.env, (MDBEnvInfo)info);
            this.mapSize = info.me_mapsize();
            if (this.mapSize < configMapSize) {
                LMDB.mdb_env_set_mapsize((long)this.env, (long)configMapSize);
                this.mapSize = configMapSize;
            }
            return null;
        });
    }

    private void reindex(Set<String> currentIndexSpecs, Set<String> newIndexSpecs) throws IOException, SailException {
        HashMap<String, TripleIndex> currentIndexes = new HashMap<String, TripleIndex>();
        for (TripleIndex index : this.indexes) {
            currentIndexes.put(new String(index.getFieldSeq()), index);
        }
        HashSet<String> addedIndexSpecs = new HashSet<String>(newIndexSpecs);
        addedIndexSpecs.removeAll(currentIndexSpecs);
        if (!addedIndexSpecs.isEmpty()) {
            TripleIndex sourceIndex = this.indexes.get(0);
            for (boolean explicit : new boolean[]{true, false}) {
                LmdbUtil.transaction(this.env, (stack, txn) -> {
                    MDBVal keyValue = MDBVal.callocStack((MemoryStack)stack);
                    ByteBuffer keyBuf = stack.malloc(36);
                    keyValue.mv_data(keyBuf);
                    MDBVal dataValue = MDBVal.callocStack((MemoryStack)stack);
                    for (String fieldSeq : addedIndexSpecs) {
                        logger.debug("Initializing new index '{}'...", (Object)fieldSeq);
                        TripleIndex addedIndex = new TripleIndex(fieldSeq);
                        RecordIterator[] sourceIter = new RecordIterator[]{null};
                        try {
                            long[] quad;
                            sourceIter[0] = new LmdbRecordIterator(this.pool, sourceIndex, false, -1L, -1L, -1L, -1L, explicit, this.txnManager.createTxn(txn));
                            RecordIterator it = sourceIter[0];
                            while ((quad = it.next()) != null) {
                                keyBuf.clear();
                                addedIndex.toKey(keyBuf, quad[0], quad[1], quad[2], quad[3]);
                                keyBuf.flip();
                                LmdbUtil.E(LMDB.mdb_put((long)txn, (int)addedIndex.getDB(explicit), (MDBVal)keyValue, (MDBVal)dataValue, (int)0));
                            }
                        }
                        finally {
                            if (sourceIter[0] != null) {
                                sourceIter[0].close();
                            }
                        }
                        currentIndexes.put(fieldSeq, addedIndex);
                    }
                    return null;
                });
            }
            logger.debug("New index(es) initialized");
        }
        HashSet<String> removedIndexSpecs = new HashSet<String>(currentIndexSpecs);
        removedIndexSpecs.removeAll(newIndexSpecs);
        ArrayList removedIndexExceptions = new ArrayList();
        LmdbUtil.transaction(this.env, (stack, txn) -> {
            for (String fieldSeq : removedIndexSpecs) {
                try {
                    TripleIndex removedIndex = (TripleIndex)currentIndexes.remove(fieldSeq);
                    removedIndex.destroy(txn);
                    logger.debug("Deleted file(s) for removed {} index", (Object)fieldSeq);
                }
                catch (Throwable e) {
                    removedIndexExceptions.add(e);
                }
            }
            return null;
        });
        if (!removedIndexExceptions.isEmpty()) {
            throw new IOException((Throwable)removedIndexExceptions.get(0));
        }
        this.indexes.clear();
        for (String fieldSeq : newIndexSpecs) {
            this.indexes.add((TripleIndex)currentIndexes.remove(fieldSeq));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.env != 0L) {
            this.endTransaction(false);
            ArrayList<Throwable> caughtExceptions = new ArrayList<Throwable>();
            for (TripleIndex index : this.indexes) {
                try {
                    index.close();
                }
                catch (Throwable e) {
                    logger.warn("Failed to close file for {} index", (Object)new String(index.getFieldSeq()));
                    caughtExceptions.add(e);
                }
            }
            LMDB.mdb_env_close((long)this.env);
            this.env = 0L;
            if (!caughtExceptions.isEmpty()) {
                throw new IOException((Throwable)caughtExceptions.get(0));
            }
        }
    }

    public LmdbContextIdIterator getContexts(TxnManager.Txn txn) throws IOException {
        return new LmdbContextIdIterator(this.pool, this.contextsDbi, txn);
    }

    public RecordIterator getAllTriplesSortedByContext(TxnManager.Txn txn) throws IOException {
        for (TripleIndex index : this.indexes) {
            if (index.getFieldSeq()[0] != 'c') continue;
            return this.getTriplesUsingIndex(txn, -1L, -1L, -1L, -1L, true, index, false);
        }
        return null;
    }

    public RecordIterator getTriples(TxnManager.Txn txn, long subj, long pred, long obj, long context, boolean explicit) throws IOException {
        TripleIndex index = this.getBestIndex(subj, pred, obj, context);
        boolean doRangeSearch = index.getPatternScore(subj, pred, obj, context) > 0;
        return this.getTriplesUsingIndex(txn, subj, pred, obj, context, explicit, index, doRangeSearch);
    }

    private RecordIterator getTriplesUsingIndex(TxnManager.Txn txn, long subj, long pred, long obj, long context, boolean explicit, TripleIndex index, boolean rangeSearch) throws IOException {
        return new LmdbRecordIterator(this.pool, index, rangeSearch, subj, pred, obj, context, explicit, txn);
    }

    protected void bucketStart(double fraction, long[] lowerValues, long[] upperValues, long[] startValues) {
        long diff = 0L;
        for (int i = 0; i < lowerValues.length; ++i) {
            startValues[i] = diff == 0L ? ((diff = upperValues[i] - lowerValues[i]) == 0L ? lowerValues[i] : (long)((double)lowerValues[i] + (double)diff * fraction)) : 0L;
        }
    }

    protected void filterUsedIds(Collection<Long> ids) throws IOException {
        LmdbUtil.readTransaction(this.env, (stack, txn) -> {
            MDBVal maxKey = MDBVal.malloc((MemoryStack)stack);
            ByteBuffer maxKeyBuf = stack.malloc(36);
            MDBVal keyData = MDBVal.malloc((MemoryStack)stack);
            ByteBuffer keyBuf = stack.malloc(36);
            MDBVal valueData = MDBVal.mallocStack((MemoryStack)stack);
            PointerBuffer pp = stack.mallocPointer(1);
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                long id = (Long)it.next();
                if (id < 0L) {
                    it.remove();
                    continue;
                }
                keyBuf.clear();
                Varint.writeUnsigned(keyBuf, id);
                keyData.mv_data(keyBuf.flip());
                if (LmdbUtil.E(LMDB.mdb_get((long)txn, (int)this.contextsDbi, (MDBVal)keyData, (MDBVal)valueData)) != 0) continue;
                it.remove();
            }
            for (int component = 0; component <= 2; ++component) {
                int c = component;
                TripleIndex index = this.getBestIndex(component == 0 ? 1L : -1L, component == 1 ? 1L : -1L, component == 2 ? 1L : -1L, component == 3 ? 1L : -1L);
                boolean fullScan = index.getPatternScore(component == 0 ? 1L : -1L, component == 1 ? 1L : -1L, component == 2 ? 1L : -1L, component == 3 ? 1L : -1L) == 0;
                for (boolean explicit : new boolean[]{true, false}) {
                    int dbi = index.getDB(explicit);
                    long cursor = 0L;
                    try {
                        LmdbUtil.E(LMDB.mdb_cursor_open((long)txn, (int)dbi, (PointerBuffer)pp));
                        cursor = pp.get(0);
                        if (fullScan) {
                            long[] quad = new long[4];
                            int rc = LmdbUtil.E(LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)0));
                            while (rc == 0 && !ids.isEmpty()) {
                                index.keyToQuad(keyData.mv_data(), quad);
                                ids.remove(quad[0]);
                                ids.remove(quad[1]);
                                ids.remove(quad[2]);
                                ids.remove(quad[3]);
                                rc = LmdbUtil.E(LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)8));
                            }
                            continue;
                        }
                        Iterator it2 = ids.iterator();
                        while (it2.hasNext()) {
                            long id = (Long)it2.next();
                            if (id < 0L) {
                                it2.remove();
                                continue;
                            }
                            if (component != 2 && (id & 1L) == 1L) continue;
                            long subj = c == 0 ? id : -1L;
                            long pred = c == 1 ? id : -1L;
                            long obj = c == 2 ? id : -1L;
                            long context = c == 3 ? id : -1L;
                            Varint.GroupMatcher matcher = index.createMatcher(subj, pred, obj, context);
                            maxKeyBuf.clear();
                            index.getMaxKey(maxKeyBuf, subj, pred, obj, context);
                            maxKeyBuf.flip();
                            maxKey.mv_data(maxKeyBuf);
                            keyBuf.clear();
                            index.getMinKey(keyBuf, subj, pred, obj, context);
                            keyBuf.flip();
                            keyData.mv_data(keyBuf);
                            int rc = LmdbUtil.E(LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)17));
                            boolean exists = false;
                            while (!exists && rc == 0 && LMDB.mdb_cmp((long)txn, (int)dbi, (MDBVal)keyData, (MDBVal)maxKey) <= 0) {
                                if (!matcher.matches(keyData.mv_data())) {
                                    rc = LmdbUtil.E(LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)8));
                                    continue;
                                }
                                exists = true;
                            }
                            if (!exists) continue;
                            it2.remove();
                        }
                    }
                    finally {
                        if (cursor != 0L) {
                            LMDB.mdb_cursor_close((long)cursor);
                        }
                    }
                }
            }
            return null;
        });
    }

    protected double cardinality(long subj, long pred, long obj, long context) throws IOException {
        TripleIndex index = this.getBestIndex(subj, pred, obj, context);
        int relevantParts = index.getPatternScore(subj, pred, obj, context);
        if (relevantParts == 0) {
            return this.txnManager.doWith((stack, txn) -> {
                double cardinality = 0.0;
                for (boolean explicit : new boolean[]{true, false}) {
                    int dbi = index.getDB(explicit);
                    MDBStat stat = MDBStat.mallocStack((MemoryStack)stack);
                    LMDB.mdb_stat((long)txn, (int)dbi, (MDBStat)stat);
                    cardinality += (double)stat.ms_entries();
                }
                return cardinality;
            });
        }
        return this.txnManager.doWith((stack, txn) -> {
            Statistics s = this.pool.getStatistics();
            try {
                MDBVal maxKey = MDBVal.malloc((MemoryStack)stack);
                ByteBuffer maxKeyBuf = stack.malloc(36);
                index.getMaxKey(maxKeyBuf, subj, pred, obj, context);
                maxKeyBuf.flip();
                maxKey.mv_data(maxKeyBuf);
                PointerBuffer pp = stack.mallocPointer(1);
                MDBVal keyData = MDBVal.mallocStack((MemoryStack)stack);
                ByteBuffer keyBuf = stack.malloc(36);
                MDBVal valueData = MDBVal.mallocStack((MemoryStack)stack);
                double cardinality = 0.0;
                for (boolean explicit : new boolean[]{true, false}) {
                    Arrays.fill(s.avgRowsPerValue, 1.0);
                    Arrays.fill(s.avgRowsPerValueCounts, 0L);
                    keyBuf.clear();
                    index.getMinKey(keyBuf, subj, pred, obj, context);
                    keyBuf.flip();
                    int dbi = index.getDB(explicit);
                    int pos = 0;
                    long cursor = 0L;
                    try {
                        LmdbUtil.E(LMDB.mdb_cursor_open((long)txn, (int)dbi, (PointerBuffer)pp));
                        cursor = pp.get(0);
                        keyData.mv_data(keyBuf);
                        int rc = LmdbUtil.E(LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)17));
                        if (rc != 0 || LMDB.mdb_cmp((long)txn, (int)dbi, (MDBVal)keyData, (MDBVal)maxKey) >= 0) break;
                        Varint.readListUnsigned(keyData.mv_data(), s.minValues);
                        keyData.mv_data(maxKeyBuf);
                        rc = LmdbUtil.E(LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)17));
                        rc = rc != 0 ? LmdbUtil.E(LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)6)) : LmdbUtil.E(LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)12));
                        if (rc != 0) break;
                        Varint.readListUnsigned(keyData.mv_data(), s.maxValues);
                        s.startValues[3] = s.maxValues;
                        long allSamplesCount = 0L;
                        int bucket = 0;
                        boolean endOfRange = false;
                        while (true) {
                            if (bucket >= 3 || endOfRange) break;
                            if (bucket != 0) {
                                this.bucketStart((double)bucket / 3.0, s.minValues, s.maxValues, s.values);
                                keyBuf.clear();
                                Varint.writeListUnsigned(keyBuf, s.values);
                                keyBuf.flip();
                            }
                            keyData.mv_data(keyBuf);
                            int currentSamplesCount = 0;
                            rc = LmdbUtil.E(LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)17));
                            while (rc == 0) {
                                if (currentSamplesCount >= 100) break;
                                if (LMDB.mdb_cmp((long)txn, (int)dbi, (MDBVal)keyData, (MDBVal)maxKey) >= 0) {
                                    endOfRange = true;
                                    break;
                                }
                                ++allSamplesCount;
                                System.arraycopy(s.values, 0, s.lastValues[bucket], 0, s.values.length);
                                Varint.readListUnsigned(keyData.mv_data(), s.values);
                                if (++currentSamplesCount == 1) {
                                    Arrays.fill(s.counts, 1L);
                                    System.arraycopy(s.values, 0, s.startValues[bucket], 0, s.values.length);
                                } else {
                                    for (int i = 0; i < s.values.length; ++i) {
                                        if (s.values[i] == s.lastValues[bucket][i]) {
                                            int n = i;
                                            s.counts[n] = s.counts[n] + 1L;
                                            continue;
                                        }
                                        long diff = s.values[i] - s.lastValues[bucket][i];
                                        int n = i;
                                        s.avgRowsPerValueCounts[n] = s.avgRowsPerValueCounts[n] + 1L;
                                        s.avgRowsPerValue[i] = (s.avgRowsPerValue[i] * (double)(s.avgRowsPerValueCounts[i] - 1L) + (double)s.counts[i] / (double)diff) / (double)s.avgRowsPerValueCounts[i];
                                        s.counts[i] = 0L;
                                    }
                                }
                                if ((rc = LmdbUtil.E(LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)8))) == 0) continue;
                                endOfRange = true;
                            }
                            ++bucket;
                        }
                        cardinality += (double)allSamplesCount;
                        int buckets = bucket;
                        for (bucket = 1; bucket < buckets; ++bucket) {
                            for (pos = 0; pos < s.lastValues[bucket].length && s.startValues[bucket][pos] == s.lastValues[bucket - 1][pos]; ++pos) {
                            }
                            if (pos >= s.lastValues[bucket].length) continue;
                            long diffBetweenGroups = Math.max(s.startValues[bucket][pos] - s.lastValues[bucket - 1][pos], 0L);
                            cardinality += s.avgRowsPerValue[pos] * (double)diffBetweenGroups;
                        }
                    }
                    finally {
                        if (cursor != 0L) {
                            LMDB.mdb_cursor_close((long)cursor);
                        }
                    }
                }
                Double d = cardinality;
                return d;
            }
            finally {
                this.pool.free(s);
            }
        });
    }

    protected TripleIndex getBestIndex(long subj, long pred, long obj, long context) {
        int bestScore = -1;
        TripleIndex bestIndex = null;
        for (TripleIndex index : this.indexes) {
            int score = index.getPatternScore(subj, pred, obj, context);
            if (score <= bestScore) continue;
            bestScore = score;
            bestIndex = index;
        }
        return bestIndex;
    }

    private boolean requiresResize() {
        if (this.autoGrow) {
            return LmdbUtil.requiresResize(this.mapSize, this.pageSize, this.writeTxn, 0L);
        }
        return false;
    }

    public boolean storeTriple(long subj, long pred, long obj, long context, boolean explicit) throws IOException {
        boolean stAdded;
        TripleIndex mainIndex = this.indexes.get(0);
        try (MemoryStack stack = MemoryStack.stackPush();){
            MDBVal keyVal = MDBVal.malloc((MemoryStack)stack);
            MDBVal dataVal = MDBVal.calloc((MemoryStack)stack);
            ByteBuffer keyBuf = stack.malloc(36);
            mainIndex.toKey(keyBuf, subj, pred, obj, context);
            keyBuf.flip();
            keyVal.mv_data(keyBuf);
            if (this.recordCache == null && this.requiresResize()) {
                this.recordCache = new TxnRecordCache(this.dir);
                logger.debug("resize of map size {} required while adding - initialize record cache", (Object)this.mapSize);
            }
            if (this.recordCache != null) {
                long[] quad = new long[]{subj, pred, obj, context};
                if (explicit) {
                    this.recordCache.removeRecord(quad, false);
                }
                boolean bl = this.recordCache.storeRecord(quad, explicit);
                return bl;
            }
            int rc = LmdbUtil.E(LMDB.mdb_put((long)this.writeTxn, (int)mainIndex.getDB(explicit), (MDBVal)keyVal, (MDBVal)dataVal, (int)16));
            if (rc != 0 && rc != -30799) {
                throw new IOException(LMDB.mdb_strerror((int)rc));
            }
            stAdded = rc == 0;
            boolean foundImplicit = false;
            if (explicit && stAdded) {
                boolean bl = foundImplicit = LmdbUtil.E(LMDB.mdb_del((long)this.writeTxn, (int)mainIndex.getDB(false), (MDBVal)keyVal, (MDBVal)dataVal)) == 0;
            }
            if (stAdded) {
                for (int i = 1; i < this.indexes.size(); ++i) {
                    TripleIndex index = this.indexes.get(i);
                    keyBuf.clear();
                    index.toKey(keyBuf, subj, pred, obj, context);
                    keyBuf.flip();
                    keyVal.mv_data(keyBuf);
                    if (foundImplicit) {
                        LmdbUtil.E(LMDB.mdb_del((long)this.writeTxn, (int)mainIndex.getDB(false), (MDBVal)keyVal, (MDBVal)dataVal));
                    }
                    LmdbUtil.E(LMDB.mdb_put((long)this.writeTxn, (int)index.getDB(explicit), (MDBVal)keyVal, (MDBVal)dataVal, (int)0));
                }
                if (stAdded) {
                    this.incrementContext(stack, context);
                }
            }
        }
        return stAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementContext(MemoryStack stack, long context) throws IOException {
        try {
            stack.push();
            MDBVal idVal = MDBVal.calloc((MemoryStack)stack);
            ByteBuffer bb = stack.malloc(9);
            Varint.writeUnsigned(bb, context);
            bb.flip();
            idVal.mv_data(bb);
            MDBVal dataVal = MDBVal.calloc((MemoryStack)stack);
            long newCount = 1L;
            if (LmdbUtil.E(LMDB.mdb_get((long)this.writeTxn, (int)this.contextsDbi, (MDBVal)idVal, (MDBVal)dataVal)) == 0) {
                newCount = Varint.readUnsigned(dataVal.mv_data()) + 1L;
            }
            ByteBuffer countBb = stack.malloc(Varint.calcLengthUnsigned(newCount));
            Varint.writeUnsigned(countBb, newCount);
            dataVal.mv_data(countBb.flip());
            LmdbUtil.E(LMDB.mdb_put((long)this.writeTxn, (int)this.contextsDbi, (MDBVal)idVal, (MDBVal)dataVal, (int)0));
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decrementContext(MemoryStack stack, long context) throws IOException {
        try {
            stack.push();
            MDBVal idVal = MDBVal.calloc((MemoryStack)stack);
            ByteBuffer bb = stack.malloc(9);
            Varint.writeUnsigned(bb, context);
            bb.flip();
            idVal.mv_data(bb);
            MDBVal dataVal = MDBVal.calloc((MemoryStack)stack);
            if (LmdbUtil.E(LMDB.mdb_get((long)this.writeTxn, (int)this.contextsDbi, (MDBVal)idVal, (MDBVal)dataVal)) == 0) {
                long newCount = Varint.readUnsigned(dataVal.mv_data()) - 1L;
                if (newCount <= 0L) {
                    LmdbUtil.E(LMDB.mdb_del((long)this.writeTxn, (int)this.contextsDbi, (MDBVal)idVal, null));
                    boolean bl = true;
                    return bl;
                }
                ByteBuffer countBb = stack.malloc(Varint.calcLengthUnsigned(newCount));
                Varint.writeUnsigned(countBb, newCount);
                dataVal.mv_data(countBb.flip());
                LmdbUtil.E(LMDB.mdb_put((long)this.writeTxn, (int)this.contextsDbi, (MDBVal)idVal, (MDBVal)dataVal, (int)0));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            stack.pop();
        }
    }

    public void removeTriplesByContext(long subj, long pred, long obj, long context, boolean explicit, Consumer<long[]> handler) throws IOException {
        RecordIterator records = this.getTriples(this.txnManager.createTxn(this.writeTxn), subj, pred, obj, context, explicit);
        this.removeTriples(records, explicit, handler);
    }

    public void removeTriples(RecordIterator it, boolean explicit, Consumer<long[]> handler) throws IOException {
        try (RecordIterator recordIterator = it;
             MemoryStack stack = MemoryStack.stackPush();){
            long[] quad;
            MDBVal keyValue = MDBVal.callocStack((MemoryStack)stack);
            ByteBuffer keyBuf = stack.malloc(36);
            while ((quad = it.next()) != null) {
                if (this.recordCache == null && this.requiresResize()) {
                    this.recordCache = new TxnRecordCache(this.dir);
                    logger.debug("resize of map size {} required while removing - initialize record cache", (Object)this.mapSize);
                }
                if (this.recordCache != null) {
                    this.recordCache.removeRecord(quad, explicit);
                    handler.accept(quad);
                    continue;
                }
                for (TripleIndex index : this.indexes) {
                    keyBuf.clear();
                    index.toKey(keyBuf, quad[0], quad[1], quad[2], quad[3]);
                    keyBuf.flip();
                    keyValue.mv_data(keyBuf);
                    LmdbUtil.E(LMDB.mdb_del((long)this.writeTxn, (int)index.getDB(explicit), (MDBVal)keyValue, null));
                }
                this.decrementContext(stack, quad[3]);
                handler.accept(quad);
            }
        }
    }

    protected void updateFromCache() throws IOException {
        this.recordCache.commit();
        for (boolean explicit : new boolean[]{true, false}) {
            TxnRecordCache.RecordCacheIterator it = this.recordCache.getRecords(explicit);
            try (MemoryStack stack = MemoryStack.stackPush();){
                TxnRecordCache.Record r;
                PointerBuffer pp = stack.mallocPointer(1);
                MDBVal keyVal = MDBVal.mallocStack((MemoryStack)stack);
                MDBVal dataVal = MDBVal.callocStack((MemoryStack)stack);
                ByteBuffer keyBuf = stack.malloc(36);
                while ((r = it.next()) != null) {
                    if (this.requiresResize()) {
                        LmdbUtil.E(LMDB.mdb_txn_commit((long)this.writeTxn));
                        this.mapSize = LmdbUtil.autoGrowMapSize(this.mapSize, this.pageSize, 0L);
                        LmdbUtil.E(LMDB.mdb_env_set_mapsize((long)this.env, (long)this.mapSize));
                        logger.debug("resized map to {}", (Object)this.mapSize);
                        LmdbUtil.E(LMDB.mdb_txn_begin((long)this.env, (long)0L, (int)0, (PointerBuffer)pp));
                        this.writeTxn = pp.get(0);
                    }
                    for (int i = 0; i < this.indexes.size(); ++i) {
                        TripleIndex index = this.indexes.get(i);
                        keyBuf.clear();
                        index.toKey(keyBuf, r.quad[0], r.quad[1], r.quad[2], r.quad[3]);
                        keyBuf.flip();
                        keyVal.mv_data(keyBuf);
                        if (r.add) {
                            LmdbUtil.E(LMDB.mdb_put((long)this.writeTxn, (int)index.getDB(explicit), (MDBVal)keyVal, (MDBVal)dataVal, (int)0));
                            continue;
                        }
                        LmdbUtil.E(LMDB.mdb_del((long)this.writeTxn, (int)index.getDB(explicit), (MDBVal)keyVal, null));
                    }
                }
            }
        }
        this.recordCache.close();
    }

    public void startTransaction() throws IOException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            LmdbUtil.E(LMDB.mdb_txn_begin((long)this.env, (long)0L, (int)0, (PointerBuffer)pp));
            this.writeTxn = pp.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endTransaction(boolean commit) throws IOException {
        block29: {
            if (this.writeTxn != 0L) {
                try {
                    if (commit) {
                        try {
                            LmdbUtil.E(LMDB.mdb_txn_commit((long)this.writeTxn));
                            if (this.recordCache != null) {
                                StampedLock lock = this.txnManager.lock();
                                long stamp = lock.writeLock();
                                try {
                                    this.txnManager.deactivate();
                                    this.mapSize = LmdbUtil.autoGrowMapSize(this.mapSize, this.pageSize, 0L);
                                    LmdbUtil.E(LMDB.mdb_env_set_mapsize((long)this.env, (long)this.mapSize));
                                    logger.debug("resized map to {}", (Object)this.mapSize);
                                    try (MemoryStack stack = MemoryStack.stackPush();){
                                        PointerBuffer pp = stack.mallocPointer(1);
                                        LMDB.mdb_txn_begin((long)this.env, (long)0L, (int)0, (PointerBuffer)pp);
                                        this.writeTxn = pp.get(0);
                                    }
                                    this.updateFromCache();
                                    LmdbUtil.E(LMDB.mdb_txn_commit((long)this.writeTxn));
                                    break block29;
                                }
                                finally {
                                    this.recordCache = null;
                                    try {
                                        this.txnManager.activate();
                                    }
                                    finally {
                                        lock.unlockWrite(stamp);
                                    }
                                }
                            }
                            this.txnManager.reset();
                            break block29;
                        }
                        catch (IOException e) {
                            LMDB.mdb_txn_abort((long)this.writeTxn);
                            throw e;
                        }
                    }
                    LMDB.mdb_txn_abort((long)this.writeTxn);
                }
                finally {
                    this.writeTxn = 0L;
                    if (this.recordCache != null) {
                        try {
                            this.recordCache.close();
                        }
                        finally {
                            this.recordCache = null;
                        }
                    }
                }
            }
        }
    }

    public void commit() throws IOException {
        this.endTransaction(true);
    }

    public void rollback() throws IOException {
        this.endTransaction(false);
    }

    private Properties loadProperties(File propFile) throws IOException {
        try (FileInputStream in = new FileInputStream(propFile);){
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
    }

    private void storeProperties(File propFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(propFile);){
            this.properties.store(out, "triple indexes meta-data, DO NOT EDIT!");
        }
    }

    class TripleIndex {
        private final char[] fieldSeq;
        private final int dbiExplicit;
        private final int dbiInferred;
        private final int[] indexMap;

        public TripleIndex(String fieldSeq) throws IOException {
            this.fieldSeq = fieldSeq.toCharArray();
            this.indexMap = this.getIndexes(this.fieldSeq);
            this.dbiExplicit = LmdbUtil.openDatabase(TripleStore.this.env, fieldSeq, 262144, null);
            this.dbiInferred = LmdbUtil.openDatabase(TripleStore.this.env, fieldSeq + "-inf", 262144, null);
        }

        public char[] getFieldSeq() {
            return this.fieldSeq;
        }

        public int getDB(boolean explicit) {
            return explicit ? this.dbiExplicit : this.dbiInferred;
        }

        protected int[] getIndexes(char[] fieldSeq) {
            int[] indexes = new int[fieldSeq.length];
            for (int i = 0; i < fieldSeq.length; ++i) {
                int fieldIdx;
                char field = fieldSeq[i];
                switch (field) {
                    case 's': {
                        fieldIdx = 0;
                        break;
                    }
                    case 'p': {
                        fieldIdx = 1;
                        break;
                    }
                    case 'o': {
                        fieldIdx = 2;
                        break;
                    }
                    case 'c': {
                        fieldIdx = 3;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid character '" + field + "' in field sequence: " + new String(fieldSeq));
                    }
                }
                indexes[i] = fieldIdx;
            }
            return indexes;
        }

        public int getPatternScore(long subj, long pred, long obj, long context) {
            int score = 0;
            block6: for (char field : this.fieldSeq) {
                switch (field) {
                    case 's': {
                        if (subj >= 0L) {
                            ++score;
                            continue block6;
                        }
                        return score;
                    }
                    case 'p': {
                        if (pred >= 0L) {
                            ++score;
                            continue block6;
                        }
                        return score;
                    }
                    case 'o': {
                        if (obj >= 0L) {
                            ++score;
                            continue block6;
                        }
                        return score;
                    }
                    case 'c': {
                        if (context >= 0L) {
                            ++score;
                            continue block6;
                        }
                        return score;
                    }
                    default: {
                        throw new RuntimeException("invalid character '" + field + "' in field sequence: " + new String(this.fieldSeq));
                    }
                }
            }
            return score;
        }

        void getMinKey(ByteBuffer bb, long subj, long pred, long obj, long context) {
            subj = subj <= 0L ? 0L : subj;
            pred = pred <= 0L ? 0L : pred;
            obj = obj <= 0L ? 0L : obj;
            context = context <= 0L ? 0L : context;
            this.toKey(bb, subj, pred, obj, context);
        }

        void getMaxKey(ByteBuffer bb, long subj, long pred, long obj, long context) {
            subj = subj <= 0L ? Long.MAX_VALUE : subj;
            pred = pred <= 0L ? Long.MAX_VALUE : pred;
            obj = obj <= 0L ? Long.MAX_VALUE : obj;
            context = context < 0L ? Long.MAX_VALUE : context;
            this.toKey(bb, subj, pred, obj, context);
        }

        Varint.GroupMatcher createMatcher(long subj, long pred, long obj, long context) {
            ByteBuffer bb = ByteBuffer.allocate(36);
            this.toKey(bb, subj == -1L ? 0L : subj, pred == -1L ? 0L : pred, obj == -1L ? 0L : obj, context == -1L ? 0L : context);
            bb.flip();
            boolean[] shouldMatch = new boolean[4];
            block6: for (int i = 0; i < this.fieldSeq.length; ++i) {
                switch (this.fieldSeq[i]) {
                    case 's': {
                        shouldMatch[i] = subj > 0L;
                        continue block6;
                    }
                    case 'p': {
                        shouldMatch[i] = pred > 0L;
                        continue block6;
                    }
                    case 'o': {
                        shouldMatch[i] = obj > 0L;
                        continue block6;
                    }
                    case 'c': {
                        shouldMatch[i] = context >= 0L;
                    }
                }
            }
            return new Varint.GroupMatcher(bb, shouldMatch);
        }

        void toKey(ByteBuffer bb, long subj, long pred, long obj, long context) {
            block6: for (int i = 0; i < this.fieldSeq.length; ++i) {
                switch (this.fieldSeq[i]) {
                    case 's': {
                        Varint.writeUnsigned(bb, subj);
                        continue block6;
                    }
                    case 'p': {
                        Varint.writeUnsigned(bb, pred);
                        continue block6;
                    }
                    case 'o': {
                        Varint.writeUnsigned(bb, obj);
                        continue block6;
                    }
                    case 'c': {
                        Varint.writeUnsigned(bb, context);
                    }
                }
            }
        }

        void keyToQuad(ByteBuffer key, long[] quad) {
            Varint.readListUnsigned(key, this.indexMap, quad);
        }

        public String toString() {
            return new String(this.getFieldSeq());
        }

        void close() {
            LMDB.mdb_dbi_close((long)TripleStore.this.env, (int)this.dbiExplicit);
            LMDB.mdb_dbi_close((long)TripleStore.this.env, (int)this.dbiInferred);
            TripleStore.this.pool.close();
        }

        void clear(long txn) {
            LMDB.mdb_drop((long)txn, (int)this.dbiExplicit, (boolean)false);
            LMDB.mdb_drop((long)txn, (int)this.dbiInferred, (boolean)false);
        }

        void destroy(long txn) {
            LMDB.mdb_drop((long)txn, (int)this.dbiExplicit, (boolean)true);
            LMDB.mdb_drop((long)txn, (int)this.dbiInferred, (boolean)true);
        }
    }
}

