/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.UnionIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.BackingSailSource;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.lmdb.ContextStore;
import org.eclipse.rdf4j.sail.lmdb.LmdbEvaluationStatistics;
import org.eclipse.rdf4j.sail.lmdb.LmdbStatementIterator;
import org.eclipse.rdf4j.sail.lmdb.NamespaceStore;
import org.eclipse.rdf4j.sail.lmdb.RecordIterator;
import org.eclipse.rdf4j.sail.lmdb.TripleStore;
import org.eclipse.rdf4j.sail.lmdb.TxnManager;
import org.eclipse.rdf4j.sail.lmdb.ValueStore;
import org.eclipse.rdf4j.sail.lmdb.config.LmdbStoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LmdbSailStore
implements SailStore {
    final Logger logger = LoggerFactory.getLogger(LmdbSailStore.class);
    private final TripleStore tripleStore;
    private final ValueStore valueStore;
    private final ExecutorService tripleStoreExecutor = Executors.newCachedThreadPool();
    private final CircularBuffer<Operation> opQueue = new CircularBuffer(1024);
    private volatile Throwable tripleStoreException;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private boolean multiThreadingActive;
    private volatile boolean asyncTransactionFinished;
    private volatile boolean nextTransactionAsync;
    private final boolean enableMultiThreading = true;
    static final Operation COMMIT_TRANSACTION = () -> {};
    static final Operation ROLLBACK_TRANSACTION = () -> {};
    private final NamespaceStore namespaceStore;
    private final ContextStore contextStore;
    private final ReentrantLock sinkStoreAccessLock = new ReentrantLock();
    private final AtomicBoolean storeTxnStarted = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LmdbSailStore(File dataDir, LmdbStoreConfig config) throws IOException, SailException {
        boolean initialized = false;
        try {
            this.namespaceStore = new NamespaceStore(dataDir);
            this.valueStore = new ValueStore(new File(dataDir, "values"), config);
            this.tripleStore = new TripleStore(new File(dataDir, "triples"), config);
            this.contextStore = new ContextStore(this, dataDir);
            initialized = true;
        }
        finally {
            if (!initialized) {
                this.close();
            }
        }
    }

    public ValueFactory getValueFactory() {
        return this.valueStore;
    }

    void rollback() throws SailException {
        this.sinkStoreAccessLock.lock();
        try {
            try {
                this.valueStore.rollback();
            }
            finally {
                if (this.multiThreadingActive) {
                    while (!this.opQueue.add(ROLLBACK_TRANSACTION)) {
                        if (this.tripleStoreException != null) {
                            throw this.wrapTripleStoreException();
                        }
                        Thread.yield();
                    }
                } else {
                    this.tripleStore.rollback();
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to rollback LMDB transaction", (Throwable)e);
            throw e instanceof SailException ? (SailException)e : new SailException((Throwable)e);
        }
        finally {
            this.tripleStoreException = null;
            this.sinkStoreAccessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SailException {
        try {
            try {
                if (this.namespaceStore != null) {
                    this.namespaceStore.close();
                }
            }
            finally {
                try {
                    if (this.contextStore != null) {
                        this.contextStore.close();
                    }
                }
                finally {
                    try {
                        if (this.valueStore != null) {
                            this.valueStore.close();
                        }
                    }
                    finally {
                        if (this.tripleStore != null) {
                            this.running.set(false);
                            this.tripleStoreExecutor.shutdown();
                            while (!this.tripleStoreExecutor.isTerminated()) {
                                Thread.yield();
                            }
                            this.tripleStore.close();
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.warn("Failed to close store", (Throwable)e);
            throw new SailException((Throwable)e);
        }
    }

    SailException wrapTripleStoreException() {
        return this.tripleStoreException instanceof SailException ? (SailException)this.tripleStoreException : new SailException(this.tripleStoreException);
    }

    public EvaluationStatistics getEvaluationStatistics() {
        return new LmdbEvaluationStatistics(this.valueStore, this.tripleStore);
    }

    public SailSource getExplicitSailSource() {
        return new LmdbSailSource(true);
    }

    public SailSource getInferredSailSource() {
        return new LmdbSailSource(false);
    }

    CloseableIteration<Resource> getContexts() throws IOException {
        final TxnManager.Txn txn = this.tripleStore.getTxnManager().createReadTxn();
        RecordIterator records = this.tripleStore.getAllTriplesSortedByContext(txn);
        CloseableIteration<? extends Statement> stIter1 = records == null ? this.createStatementIterator(txn, null, null, null, true, new Resource[0]) : new CloseableIteration<Statement>(records, this.valueStore);
        FilterIteration<Statement> stIter2 = new FilterIteration<Statement>(stIter1){

            protected boolean accept(Statement st) {
                return st.getContext() != null;
            }
        };
        return new ConvertingIteration<Statement, Resource>((CloseableIteration)stIter2){

            protected Resource convert(Statement sourceObject) throws SailException {
                return sourceObject.getContext();
            }

            protected void handleClose() throws SailException {
                txn.close();
                super.handleClose();
            }
        };
    }

    CloseableIteration<? extends Statement> createStatementIterator(TxnManager.Txn txn, Resource subj, IRI pred, Value obj, boolean explicit, Resource ... contexts) throws IOException {
        long subjID = -1L;
        if (subj != null && (subjID = this.valueStore.getId((Value)subj)) == -1L) {
            return new EmptyIteration();
        }
        long predID = -1L;
        if (pred != null && (predID = this.valueStore.getId((Value)pred)) == -1L) {
            return new EmptyIteration();
        }
        long objID = -1L;
        if (obj != null && (objID = this.valueStore.getId(obj)) == -1L) {
            return new EmptyIteration();
        }
        ArrayList<Long> contextIDList = new ArrayList<Long>(contexts.length);
        if (contexts.length == 0) {
            contextIDList.add(-1L);
        } else {
            for (Resource context : contexts) {
                long contextID;
                if (context == null) {
                    contextIDList.add(0L);
                    continue;
                }
                if (context.isTriple() || (contextID = this.valueStore.getId((Value)context)) == -1L) continue;
                contextIDList.add(contextID);
            }
        }
        ArrayList<LmdbStatementIterator> perContextIterList = new ArrayList<LmdbStatementIterator>(contextIDList.size());
        Iterator iterator = contextIDList.iterator();
        while (iterator.hasNext()) {
            long contextID = (Long)iterator.next();
            RecordIterator records = this.tripleStore.getTriples(txn, subjID, predID, objID, contextID, explicit);
            perContextIterList.add(new LmdbStatementIterator(records, this.valueStore));
        }
        if (perContextIterList.size() == 1) {
            return (CloseableIteration)perContextIterList.get(0);
        }
        return new UnionIteration(perContextIterList);
    }

    private final class LmdbSailDataset
    implements SailDataset {
        private final boolean explicit;
        private final TxnManager.Txn txn;

        public LmdbSailDataset(boolean explicit) throws SailException {
            this.explicit = explicit;
            try {
                this.txn = LmdbSailStore.this.tripleStore.getTxnManager().createReadTxn();
            }
            catch (IOException e) {
                throw new SailException((Throwable)e);
            }
        }

        public void close() {
            this.txn.close();
        }

        public String getNamespace(String prefix) throws SailException {
            return LmdbSailStore.this.namespaceStore.getNamespace(prefix);
        }

        public CloseableIteration<? extends Namespace> getNamespaces() {
            return new CloseableIteratorIteration(LmdbSailStore.this.namespaceStore.iterator());
        }

        public CloseableIteration<? extends Resource> getContextIDs() throws SailException {
            return new CloseableIteratorIteration(LmdbSailStore.this.contextStore.iterator());
        }

        public CloseableIteration<? extends Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
            try {
                return LmdbSailStore.this.createStatementIterator(this.txn, subj, pred, obj, this.explicit, contexts);
            }
            catch (IOException e) {
                throw new SailException("Unable to get statements", (Throwable)e);
            }
        }
    }

    private final class LmdbSailSink
    implements SailSink {
        private final boolean explicit;

        public LmdbSailSink(boolean explicit) throws SailException {
            this.explicit = explicit;
        }

        public void close() {
        }

        public void prepare() throws SailException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws SailException {
            LmdbSailStore.this.sinkStoreAccessLock.lock();
            boolean activeTxn = LmdbSailStore.this.storeTxnStarted.get();
            try {
                if (LmdbSailStore.this.multiThreadingActive) {
                    while (!LmdbSailStore.this.opQueue.add(COMMIT_TRANSACTION)) {
                        if (LmdbSailStore.this.tripleStoreException != null) {
                            throw LmdbSailStore.this.wrapTripleStoreException();
                        }
                        Thread.yield();
                    }
                }
                try {
                    LmdbSailStore.this.namespaceStore.sync();
                }
                finally {
                    if (LmdbSailStore.this.multiThreadingActive) {
                        while (!LmdbSailStore.this.asyncTransactionFinished) {
                            if (LmdbSailStore.this.tripleStoreException != null) {
                                throw LmdbSailStore.this.wrapTripleStoreException();
                            }
                            Thread.yield();
                        }
                    }
                    try {
                        LmdbSailStore.this.contextStore.sync();
                    }
                    finally {
                        if (activeTxn) {
                            LmdbSailStore.this.valueStore.commit();
                            if (!LmdbSailStore.this.multiThreadingActive) {
                                LmdbSailStore.this.tripleStore.commit();
                            }
                            LmdbSailStore.this.storeTxnStarted.set(false);
                        }
                    }
                }
            }
            catch (IOException e) {
                LmdbSailStore.this.rollback();
                LmdbSailStore.this.running.set(false);
                LmdbSailStore.this.logger.error("Encountered an unexpected problem while trying to commit", (Throwable)e);
                throw new SailException((Throwable)e);
            }
            catch (RuntimeException e) {
                LmdbSailStore.this.rollback();
                LmdbSailStore.this.running.set(false);
                LmdbSailStore.this.logger.error("Encountered an unexpected problem while trying to commit", (Throwable)e);
                throw e;
            }
            finally {
                LmdbSailStore.this.multiThreadingActive = false;
                LmdbSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        public void setNamespace(String prefix, String name) throws SailException {
            LmdbSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTransaction(true);
                LmdbSailStore.this.namespaceStore.setNamespace(prefix, name);
            }
            finally {
                LmdbSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        public void removeNamespace(String prefix) throws SailException {
            LmdbSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTransaction(true);
                LmdbSailStore.this.namespaceStore.removeNamespace(prefix);
            }
            finally {
                LmdbSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        public void clearNamespaces() throws SailException {
            LmdbSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTransaction(true);
                LmdbSailStore.this.namespaceStore.clear();
            }
            finally {
                LmdbSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        public void observe(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        }

        public void clear(Resource ... contexts) throws SailException {
            this.removeStatements(null, null, null, this.explicit, contexts);
        }

        public void approve(Resource subj, IRI pred, Value obj, Resource ctx) throws SailException {
            this.addStatement(subj, pred, obj, this.explicit, ctx);
        }

        public void deprecate(Statement statement) throws SailException {
            this.removeStatements(statement.getSubject(), statement.getPredicate(), statement.getObject(), this.explicit, statement.getContext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startTransaction(boolean preferThreading) throws SailException {
            AtomicBoolean atomicBoolean = LmdbSailStore.this.storeTxnStarted;
            synchronized (atomicBoolean) {
                if (LmdbSailStore.this.storeTxnStarted.compareAndSet(false, true)) {
                    LmdbSailStore.this.nextTransactionAsync = LmdbSailStore.this.multiThreadingActive = preferThreading;
                    LmdbSailStore.this.asyncTransactionFinished = false;
                    try {
                        if (LmdbSailStore.this.multiThreadingActive) {
                            if (LmdbSailStore.this.running.compareAndSet(false, true)) {
                                LmdbSailStore.this.tripleStoreException = null;
                                LmdbSailStore.this.tripleStoreExecutor.submit(() -> {
                                    try {
                                        while (LmdbSailStore.this.running.get()) {
                                            LmdbSailStore.this.tripleStore.startTransaction();
                                            while (true) {
                                                Operation op;
                                                if ((op = LmdbSailStore.this.opQueue.remove()) != null) {
                                                    if (op == COMMIT_TRANSACTION) {
                                                        LmdbSailStore.this.tripleStore.commit();
                                                        LmdbSailStore.this.nextTransactionAsync = false;
                                                        LmdbSailStore.this.asyncTransactionFinished = true;
                                                        break;
                                                    }
                                                    if (op == ROLLBACK_TRANSACTION) {
                                                        LmdbSailStore.this.tripleStore.rollback();
                                                        LmdbSailStore.this.nextTransactionAsync = false;
                                                        LmdbSailStore.this.asyncTransactionFinished = true;
                                                        break;
                                                    }
                                                    op.execute();
                                                    continue;
                                                }
                                                Thread.yield();
                                            }
                                            long start = System.currentTimeMillis();
                                            while (LmdbSailStore.this.running.get() && !LmdbSailStore.this.nextTransactionAsync) {
                                                if (System.currentTimeMillis() - start > 2L) {
                                                    AtomicBoolean atomicBoolean = LmdbSailStore.this.storeTxnStarted;
                                                    synchronized (atomicBoolean) {
                                                        if (!LmdbSailStore.this.nextTransactionAsync) {
                                                            LmdbSailStore.this.running.set(false);
                                                            return;
                                                        }
                                                        continue;
                                                    }
                                                }
                                                Thread.yield();
                                            }
                                        }
                                    }
                                    catch (Throwable e) {
                                        LmdbSailStore.this.tripleStoreException = e;
                                        AtomicBoolean atomicBoolean = LmdbSailStore.this.storeTxnStarted;
                                        synchronized (atomicBoolean) {
                                            LmdbSailStore.this.running.set(false);
                                        }
                                    }
                                });
                            }
                        } else {
                            LmdbSailStore.this.tripleStore.startTransaction();
                        }
                        LmdbSailStore.this.valueStore.startTransaction();
                    }
                    catch (Exception e) {
                        LmdbSailStore.this.storeTxnStarted.set(false);
                        throw new SailException((Throwable)e);
                    }
                }
            }
        }

        private void addStatement(Resource subj, IRI pred, Value obj, boolean explicit, Resource context) throws SailException {
            LmdbSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTransaction(true);
                AddQuadOperation q = new AddQuadOperation();
                q.s = LmdbSailStore.this.valueStore.storeValue((Value)subj);
                q.p = LmdbSailStore.this.valueStore.storeValue((Value)pred);
                q.o = LmdbSailStore.this.valueStore.storeValue(obj);
                q.c = context == null ? 0L : LmdbSailStore.this.valueStore.storeValue((Value)context);
                q.context = context;
                q.explicit = explicit;
                if (LmdbSailStore.this.multiThreadingActive) {
                    while (!LmdbSailStore.this.opQueue.add(q)) {
                        if (LmdbSailStore.this.tripleStoreException != null) {
                            throw LmdbSailStore.this.wrapTripleStoreException();
                        }
                        Thread.yield();
                    }
                } else {
                    q.execute();
                }
            }
            catch (IOException e) {
                LmdbSailStore.this.rollback();
                throw new SailException((Throwable)e);
            }
            catch (RuntimeException e) {
                LmdbSailStore.this.rollback();
                LmdbSailStore.this.logger.error("Encountered an unexpected problem while trying to add a statement", (Throwable)e);
                throw e;
            }
            finally {
                LmdbSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        private long removeStatements(long subj, long pred, long obj, boolean explicit, long[] contexts) throws IOException {
            long removeCount = 0L;
            for (long contextId : contexts) {
                Map<Long, Long> result = LmdbSailStore.this.tripleStore.removeTriplesByContext(subj, pred, obj, contextId, explicit);
                for (Map.Entry<Long, Long> entry : result.entrySet()) {
                    Long entryContextId = entry.getKey();
                    if (entryContextId > 0L) {
                        Resource modifiedContext = (Resource)LmdbSailStore.this.valueStore.getValue(entryContextId);
                        LmdbSailStore.this.contextStore.decrementBy(modifiedContext, entry.getValue());
                    }
                    removeCount += entry.getValue().longValue();
                }
            }
            return removeCount;
        }

        private long removeStatements(Resource subj, IRI pred, Value obj, final boolean explicit, Resource ... contexts) throws SailException {
            Objects.requireNonNull(contexts, "contexts argument may not be null; either the value should be cast to Resource or an empty array should be supplied");
            LmdbSailStore.this.sinkStoreAccessLock.lock();
            try {
                long objID;
                long predID;
                long subjID;
                this.startTransaction(false);
                if (subj != null) {
                    subjID = LmdbSailStore.this.valueStore.getId((Value)subj);
                    if (subjID == -1L) {
                        long l = 0L;
                        return l;
                    }
                } else {
                    subjID = -1L;
                }
                if (pred != null) {
                    predID = LmdbSailStore.this.valueStore.getId((Value)pred);
                    if (predID == -1L) {
                        long l = 0L;
                        return l;
                    }
                } else {
                    predID = -1L;
                }
                if (obj != null) {
                    objID = LmdbSailStore.this.valueStore.getId(obj);
                    if (objID == -1L) {
                        long l = 0L;
                        return l;
                    }
                } else {
                    objID = -1L;
                }
                final long[] contextIds = new long[contexts.length == 0 ? 1 : contexts.length];
                if (contexts.length == 0) {
                    contextIds[0] = -1L;
                } else {
                    for (int i = 0; i < contexts.length; ++i) {
                        long id;
                        Resource context = contexts[i];
                        contextIds[i] = context == null ? 0L : ((id = LmdbSailStore.this.valueStore.getId((Value)context)) != -1L ? id : Long.MAX_VALUE);
                    }
                }
                if (LmdbSailStore.this.multiThreadingActive) {
                    final long[] removeCount = new long[1];
                    StatefulOperation removeOp = new StatefulOperation(){

                        @Override
                        public void execute() throws Exception {
                            try {
                                removeCount[0] = LmdbSailSink.this.removeStatements(subjID, predID, objID, explicit, contextIds);
                            }
                            finally {
                                this.finished = true;
                            }
                        }
                    };
                    while (!LmdbSailStore.this.opQueue.add(removeOp)) {
                        if (LmdbSailStore.this.tripleStoreException != null) {
                            throw LmdbSailStore.this.wrapTripleStoreException();
                        }
                        Thread.yield();
                    }
                    while (!removeOp.finished) {
                        if (LmdbSailStore.this.tripleStoreException != null) {
                            throw LmdbSailStore.this.wrapTripleStoreException();
                        }
                        Thread.yield();
                    }
                    long l = removeCount[0];
                    return l;
                }
                long l = this.removeStatements(subjID, predID, objID, explicit, contextIds);
                return l;
            }
            catch (IOException e) {
                LmdbSailStore.this.rollback();
                throw new SailException((Throwable)e);
            }
            catch (RuntimeException e) {
                LmdbSailStore.this.rollback();
                LmdbSailStore.this.logger.error("Encountered an unexpected problem while trying to remove statements", (Throwable)e);
                throw e;
            }
            finally {
                LmdbSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        public boolean deprecateByQuery(Resource subj, IRI pred, Value obj, Resource[] contexts) {
            return this.removeStatements(subj, pred, obj, this.explicit, contexts) > 0L;
        }

        public boolean supportsDeprecateByQuery() {
            return true;
        }
    }

    private final class LmdbSailSource
    extends BackingSailSource {
        private final boolean explicit;

        public LmdbSailSource(boolean explicit) {
            this.explicit = explicit;
        }

        public SailSource fork() {
            throw new UnsupportedOperationException("This store does not support multiple datasets");
        }

        public SailSink sink(IsolationLevel level) throws SailException {
            return new LmdbSailSink(this.explicit);
        }

        public LmdbSailDataset dataset(IsolationLevel level) throws SailException {
            return new LmdbSailDataset(this.explicit);
        }
    }

    static abstract class StatefulOperation
    implements Operation {
        volatile boolean finished = false;

        StatefulOperation() {
        }
    }

    class AddQuadOperation
    implements Operation {
        long s;
        long p;
        long o;
        long c;
        boolean explicit;
        Resource context;

        AddQuadOperation() {
        }

        @Override
        public void execute() throws IOException {
            boolean wasNew = LmdbSailStore.this.tripleStore.storeTriple(this.s, this.p, this.o, this.c, this.explicit);
            if (wasNew && this.context != null) {
                LmdbSailStore.this.contextStore.increment(this.context);
            }
        }
    }

    static interface Operation {
        public void execute() throws Exception;
    }

    final class CircularBuffer<T> {
        private final T[] elements;
        private volatile int head = 0;
        private volatile int tail = 0;

        CircularBuffer(int size) {
            this.elements = new Object[size];
        }

        boolean add(T element) {
            if (this.head > 0 ? this.tail == this.head - 1 : this.tail == this.elements.length - 1) {
                return false;
            }
            this.elements[this.tail] = element;
            this.tail = (this.tail + 1) % this.elements.length;
            return true;
        }

        T remove() {
            T result = null;
            if (this.tail != this.head) {
                result = this.elements[this.head];
                this.head = (this.head + 1) % this.elements.length;
            }
            return result;
        }
    }
}

