/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;

public class StatementConversionIteration
extends AbstractCloseableIteration<BindingSet> {
    protected final RepositoryResult<Statement> repoResult;
    protected final BindingSet bindings;
    protected final StatementPattern stmt;
    protected boolean updateSubj = false;
    protected boolean updatePred = false;
    protected boolean updateObj = false;
    protected boolean updateContext = false;

    public StatementConversionIteration(RepositoryResult<Statement> repoResult, BindingSet bindings, StatementPattern stmt) {
        this.repoResult = repoResult;
        this.bindings = bindings;
        this.stmt = stmt;
        this.init();
    }

    protected void init() {
        this.updateSubj = this.stmt.getSubjectVar() != null && !this.bindings.hasBinding(this.stmt.getSubjectVar().getName());
        this.updatePred = this.stmt.getPredicateVar() != null && !this.bindings.hasBinding(this.stmt.getPredicateVar().getName());
        this.updateObj = this.stmt.getObjectVar() != null && !this.bindings.hasBinding(this.stmt.getObjectVar().getName());
        this.updateContext = this.stmt.getContextVar() != null && !this.bindings.hasBinding(this.stmt.getContextVar().getName());
    }

    public boolean hasNext() throws QueryEvaluationException {
        try {
            return this.repoResult.hasNext();
        }
        catch (RepositoryException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    public BindingSet next() throws QueryEvaluationException {
        try {
            return this.convert((Statement)this.repoResult.next());
        }
        catch (IllegalStateException | NoSuchElementException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    public void remove() throws QueryEvaluationException {
        try {
            this.repoResult.remove();
        }
        catch (IllegalStateException | UnsupportedOperationException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            this.repoResult.close();
        }
    }

    protected BindingSet convert(Statement st) {
        QueryBindingSet result = new QueryBindingSet(this.bindings);
        if (this.updateSubj) {
            result.addBinding(this.stmt.getSubjectVar().getName(), (Value)st.getSubject());
        }
        if (this.updatePred) {
            result.addBinding(this.stmt.getPredicateVar().getName(), (Value)st.getPredicate());
        }
        if (this.updateObj) {
            result.addBinding(this.stmt.getObjectVar().getName(), st.getObject());
        }
        if (this.updateContext && st.getContext() != null) {
            result.addBinding(this.stmt.getContextVar().getName(), (Value)st.getContext());
        }
        return result;
    }

    protected QueryEvaluationException convertException(Exception e) {
        return new QueryEvaluationException((Throwable)e);
    }
}

