/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.federation;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.impl.QueueCursor;

public abstract class JoinExecutorBase<T>
extends LookAheadIteration<T> {
    protected static int NEXT_JOIN_ID = 1;
    protected final TupleExpr rightArg;
    protected final BindingSet bindings;
    protected final CloseableIteration<T> leftIter;
    protected volatile CloseableIteration<T> rightIter;
    protected volatile boolean closed = false;
    protected volatile boolean finished = false;
    protected final QueueCursor<CloseableIteration<T>> rightQueue = new QueueCursor(1024);

    protected JoinExecutorBase(CloseableIteration<T> leftIter, TupleExpr rightArg, BindingSet bindings) throws QueryEvaluationException {
        this.leftIter = leftIter;
        this.rightArg = rightArg;
        this.bindings = bindings;
    }

    public final void run() {
        try {
            this.handleBindings();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.toss(e);
        }
        finally {
            this.finished = true;
            this.rightQueue.done();
        }
    }

    protected abstract void handleBindings() throws Exception;

    public void addResult(CloseableIteration<T> res) {
        if (res instanceof EmptyIteration) {
            return;
        }
        try {
            this.rightQueue.put(res);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Error adding element to right queue", e);
        }
    }

    public void done() {
    }

    public void toss(Exception e) {
        this.rightQueue.toss(e);
    }

    @Override
    public T getNextElement() throws QueryEvaluationException {
        while (this.rightIter != null || this.rightQueue.hasNext()) {
            CloseableIteration nextRightIter = this.rightIter;
            if (nextRightIter == null) {
                nextRightIter = this.rightIter = (CloseableIteration)this.rightQueue.next();
            }
            if (nextRightIter == null) continue;
            if (nextRightIter.hasNext()) {
                return (T)nextRightIter.next();
            }
            this.rightIter = null;
            nextRightIter.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleClose() throws QueryEvaluationException {
        this.closed = true;
        try {
            super.handleClose();
        }
        finally {
            try {
                this.rightQueue.close();
            }
            finally {
                try {
                    CloseableIteration<T> toCloseRightIter = this.rightIter;
                    this.rightIter = null;
                    if (toCloseRightIter != null) {
                        toCloseRightIter.close();
                    }
                }
                finally {
                    CloseableIteration<T> toCloseLeftIter = this.leftIter;
                    if (toCloseLeftIter != null) {
                        toCloseLeftIter.close();
                    }
                }
            }
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

