/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.SimpleAbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LiteralComparatorFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;

public class MaxExclusiveConstraintComponent
extends SimpleAbstractConstraintComponent {
    Literal maxExclusive;

    public MaxExclusiveConstraintComponent(Literal maxExclusive) {
        this.maxExclusive = maxExclusive;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.MAX_EXCLUSIVE, this.maxExclusive, new Resource[0]);
    }

    @Override
    String getSparqlFilterExpression(StatementMatcher.Variable<Value> variable, boolean negated) {
        if (negated) {
            return this.literalToString(this.maxExclusive) + " > " + variable.asSparqlVariable();
        }
        return this.literalToString(this.maxExclusive) + " <= " + variable.asSparqlVariable();
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.MaxExclusiveConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new MaxExclusiveConstraintComponent(this.maxExclusive);
    }

    @Override
    Function<PlanNode, FilterPlanNode> getFilterAttacher() {
        return parent -> new LiteralComparatorFilter((PlanNode)parent, this.maxExclusive, Compare.CompareOp.GT);
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaxExclusiveConstraintComponent that = (MaxExclusiveConstraintComponent)o;
        return this.maxExclusive.equals(that.maxExclusive);
    }

    public int hashCode() {
        return this.maxExclusive.hashCode() + "MaxExclusiveConstraintComponent".hashCode();
    }
}

