/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.paths;

import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TupleMapper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class InversePath
extends Path {
    private final Path inversePath;

    public InversePath(Resource id, Resource inversePath, ShapeSource shapeSource) {
        super(id);
        this.inversePath = Path.buildPath(shapeSource, inversePath);
    }

    public String toString() {
        return "InversePath{ " + this.inversePath + " }";
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.INVERSE_PATH, this.inversePath.getId(), new Resource[0]);
        this.inversePath.toModel(this.inversePath.getId(), null, model, cycleDetection);
    }

    @Override
    public PlanNode getAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNodeWrapper planNodeWrapper) {
        PlanNode added = this.inversePath.getAdded(connectionsGroup, dataGraph, null);
        added = new TupleMapper(added, t -> new ValidationTuple(t.getValue(), t.getActiveTarget(), ConstraintComponent.Scope.propertyShape, true, dataGraph));
        if (planNodeWrapper != null) {
            added = (PlanNode)planNodeWrapper.apply(added);
        }
        return connectionsGroup.getCachedNodeFor(added);
    }

    @Override
    public boolean isSupported() {
        return this.inversePath.isSupported();
    }

    @Override
    public Stream<StatementMatcher> getStatementMatcher(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        return Stream.of(new StatementMatcher(object, new StatementMatcher.Variable(this.inversePath.getId()), subject));
    }

    @Override
    public String getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        return this.inversePath.getTargetQueryFragment(object, subject, rdfsSubClassOfReasoner, stableRandomVariableProvider);
    }
}

