/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.DynamicModel;
import org.eclipse.rdf4j.model.impl.DynamicModelFactory;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;

public class ContextWithShapes {
    private final Resource[] dataGraph;
    private final Resource[] shapeGraph;
    private final List<Shape> shapes;

    public ContextWithShapes(Resource[] dataGraph, Resource[] shapeGraph, List<Shape> shapes) {
        this.shapeGraph = shapeGraph;
        this.dataGraph = dataGraph;
        this.shapes = shapes;
    }

    public Resource[] getShapeGraph() {
        return this.shapeGraph;
    }

    public List<Shape> getShapes() {
        return this.shapes;
    }

    public Resource[] getDataGraph() {
        return this.dataGraph;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextWithShapes that = (ContextWithShapes)o;
        return Arrays.equals(this.dataGraph, that.dataGraph) && Arrays.equals(this.shapeGraph, that.shapeGraph) && this.shapes.equals(that.shapes);
    }

    public int hashCode() {
        int result = Objects.hash(this.shapes);
        result = 31 * result + Arrays.hashCode(this.dataGraph);
        result = 31 * result + Arrays.hashCode(this.shapeGraph);
        return result;
    }

    public void toModel(Model model) {
        DynamicModel emptyModel = new DynamicModelFactory().createEmptyModel();
        for (Shape shape : this.shapes) {
            shape.toModel((Model)emptyModel);
        }
        for (Statement statement : emptyModel) {
            for (Resource context : this.shapeGraph) {
                model.add(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{context});
            }
        }
    }
}

