/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.util.function.Supplier;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.sail.lucene.AbstractSearchQueryEvaluator;

public class QuerySpec
extends AbstractSearchQueryEvaluator {
    private final StatementPattern matchesPattern;
    private final StatementPattern queryPattern;
    private final StatementPattern propertyPattern;
    private final StatementPattern scorePattern;
    private final StatementPattern snippetPattern;
    private final StatementPattern typePattern;
    private final StatementPattern idPattern;
    private final Resource subject;
    private final String queryString;
    private final IRI propertyURI;
    private final String matchesVarName;
    private final String propertyVarName;
    private final String scoreVarName;
    private final String snippetVarName;

    public QuerySpec(StatementPattern matchesPattern, StatementPattern queryPattern, StatementPattern propertyPattern, StatementPattern scorePattern, StatementPattern snippetPattern, StatementPattern typePattern, Resource subject, String queryString, IRI propertyURI) {
        this(matchesPattern, queryPattern, propertyPattern, scorePattern, snippetPattern, typePattern, null, subject, queryString, propertyURI);
    }

    public QuerySpec(StatementPattern matchesPattern, StatementPattern queryPattern, StatementPattern propertyPattern, StatementPattern scorePattern, StatementPattern snippetPattern, StatementPattern typePattern, StatementPattern idPattern, Resource subject, String queryString, IRI propertyURI) {
        this.matchesPattern = matchesPattern;
        this.queryPattern = queryPattern;
        this.propertyPattern = propertyPattern;
        this.scorePattern = scorePattern;
        this.snippetPattern = snippetPattern;
        this.typePattern = typePattern;
        this.idPattern = idPattern;
        this.subject = subject;
        this.queryString = queryString;
        this.propertyURI = propertyURI;
        this.matchesVarName = matchesPattern != null ? matchesPattern.getSubjectVar().getName() : null;
        this.propertyVarName = propertyPattern != null ? propertyPattern.getObjectVar().getName() : null;
        this.scoreVarName = scorePattern != null ? scorePattern.getObjectVar().getName() : null;
        this.snippetVarName = snippetPattern != null ? snippetPattern.getObjectVar().getName() : null;
    }

    public QuerySpec(String matchesVarName, String propertyVarName, String scoreVarName, String snippetVarName, Resource subject, String queryString, IRI propertyURI) {
        this.matchesVarName = matchesVarName;
        this.propertyVarName = propertyVarName;
        this.scoreVarName = scoreVarName;
        this.snippetVarName = snippetVarName;
        this.matchesPattern = null;
        this.propertyPattern = null;
        this.scorePattern = null;
        this.snippetPattern = null;
        this.typePattern = null;
        this.queryPattern = null;
        this.idPattern = null;
        this.subject = subject;
        this.queryString = queryString;
        this.propertyURI = propertyURI;
    }

    @Override
    public QueryModelNode getParentQueryModelNode() {
        return this.getMatchesPattern();
    }

    @Override
    public QueryModelNode removeQueryPatterns() {
        Supplier<QueryModelNode> replacement = SingletonSet::new;
        this.replace((QueryModelNode)this.getQueryPattern(), replacement);
        this.replace((QueryModelNode)this.getScorePattern(), replacement);
        this.replace((QueryModelNode)this.getPropertyPattern(), replacement);
        this.replace((QueryModelNode)this.getSnippetPattern(), replacement);
        this.replace((QueryModelNode)this.getTypePattern(), replacement);
        this.replace((QueryModelNode)this.getIdPattern(), replacement);
        SingletonSet placeholder = new SingletonSet();
        this.getMatchesPattern().replaceWith((QueryModelNode)placeholder);
        return placeholder;
    }

    private void replace(QueryModelNode pattern, Supplier<? extends QueryModelNode> replacement) {
        if (pattern != null) {
            pattern.replaceWith(replacement.get());
        }
    }

    public StatementPattern getMatchesPattern() {
        return this.matchesPattern;
    }

    public String getMatchesVariableName() {
        return this.matchesVarName;
    }

    public StatementPattern getQueryPattern() {
        return this.queryPattern;
    }

    public StatementPattern getPropertyPattern() {
        return this.propertyPattern;
    }

    public StatementPattern getIdPattern() {
        return this.idPattern;
    }

    public String getPropertyVariableName() {
        return this.propertyVarName;
    }

    public StatementPattern getScorePattern() {
        return this.scorePattern;
    }

    public String getScoreVariableName() {
        return this.scoreVarName;
    }

    public StatementPattern getSnippetPattern() {
        return this.snippetPattern;
    }

    public String getSnippetVariableName() {
        return this.snippetVarName;
    }

    public StatementPattern getTypePattern() {
        return this.typePattern;
    }

    public IRI getQueryType() {
        if (this.typePattern != null) {
            return (IRI)this.typePattern.getObjectVar().getValue();
        }
        return null;
    }

    public Resource getSubject() {
        return this.subject;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public IRI getPropertyURI() {
        return this.propertyURI;
    }

    public boolean isEvaluable() {
        return this.queryString != null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("QuerySpec\n");
        buffer.append("   queryString=\"" + this.queryString + "\"\n");
        buffer.append("   propertyURI=" + this.propertyURI + "\n");
        buffer.append("   subject=" + this.subject + "\n");
        this.append(this.matchesPattern, buffer);
        this.append(this.queryPattern, buffer);
        this.append(this.propertyPattern, buffer);
        this.append(this.scorePattern, buffer);
        this.append(this.snippetPattern, buffer);
        this.append(this.typePattern, buffer);
        return buffer.toString();
    }

    private void append(StatementPattern pattern, StringBuilder buffer) {
        if (pattern == null) {
            return;
        }
        buffer.append("   ");
        buffer.append("StatementPattern\n");
        this.append(pattern.getSubjectVar(), buffer);
        this.append(pattern.getPredicateVar(), buffer);
        this.append(pattern.getObjectVar(), buffer);
    }

    private void append(Var var, StringBuilder buffer) {
        buffer.append("      ");
        buffer.append(var.toString());
    }
}

