/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.concurrent;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.algebra.FedXService;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ControlledWorkerScheduler;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutor;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTaskBase;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.repository.sparql.federation.CollectionIteration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelServiceExecutor
extends LookAheadIteration<BindingSet, QueryEvaluationException>
implements ParallelExecutor<BindingSet> {
    protected static final Logger log = LoggerFactory.getLogger(ParallelServiceExecutor.class);
    protected final FedXService service;
    protected final FederationEvalStrategy strategy;
    protected final BindingSet bindings;
    protected final FederationContext federationContext;
    protected CloseableIteration<BindingSet, QueryEvaluationException> rightIter = null;
    protected boolean finished = false;
    protected Exception error = null;
    private CountDownLatch latch = null;

    public ParallelServiceExecutor(FedXService service, FederationEvalStrategy strategy, BindingSet bindings, FederationContext federationContext) {
        this.service = service;
        this.strategy = strategy;
        this.bindings = bindings;
        this.federationContext = federationContext;
    }

    @Override
    public void run() {
        this.latch = new CountDownLatch(1);
        ControlledWorkerScheduler<BindingSet> scheduler = this.federationContext.getManager().getUnionScheduler();
        scheduler.schedule(new ParallelServiceTask());
    }

    @Override
    public void addResult(CloseableIteration<BindingSet, QueryEvaluationException> res) {
        this.rightIter = res;
        this.latch.countDown();
    }

    @Override
    public void toss(Exception e) {
        this.error = e;
        this.latch.countDown();
    }

    @Override
    public void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        ParallelServiceExecutor parallelServiceExecutor = this;
        synchronized (parallelServiceExecutor) {
            return this.finished;
        }
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.service.getQueryInfo();
    }

    protected BindingSet getNextElement() throws QueryEvaluationException {
        if (this.error != null) {
            if (this.error instanceof QueryEvaluationException) {
                throw (QueryEvaluationException)this.error;
            }
            throw new QueryEvaluationException((Throwable)this.error);
        }
        if (this.rightIter == null) {
            try {
                boolean completed = this.latch.await(this.getQueryInfo().getMaxRemainingTimeMS(), TimeUnit.MILLISECONDS);
                if (!completed) {
                    throw new QueryInterruptedException("Timeout during service evaluation");
                }
            }
            catch (InterruptedException e) {
                log.debug("Error while evaluating service expression. Thread got interrupted.");
                this.error = e;
            }
        }
        if (this.error != null) {
            if (this.error instanceof QueryEvaluationException) {
                throw (QueryEvaluationException)this.error;
            }
            throw new QueryEvaluationException((Throwable)this.error);
        }
        if (this.rightIter.hasNext()) {
            return (BindingSet)this.rightIter.next();
        }
        return null;
    }

    private class ParallelServiceTask
    extends ParallelTaskBase<BindingSet> {
        private ParallelServiceTask() {
        }

        @Override
        protected CloseableIteration<BindingSet, QueryEvaluationException> performTaskInternal() throws Exception {
            return new CollectionIteration((Collection)Iterations.asList((Iteration)ParallelServiceExecutor.this.strategy.evaluate(ParallelServiceExecutor.this.service.getService(), ParallelServiceExecutor.this.bindings)));
        }

        @Override
        public ParallelExecutor<BindingSet> getControl() {
            return ParallelServiceExecutor.this;
        }
    }
}

