/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.base.AbstractLiteral;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public class SimpleLiteral
extends AbstractLiteral {
    private static final long serialVersionUID = -1649571784782592271L;
    private String label;
    private String language;
    private transient Optional<String> optionalLanguageCache = null;
    private IRI datatype;
    private CoreDatatype coreDatatype = null;

    protected SimpleLiteral() {
    }

    protected SimpleLiteral(String label) {
        this.setLabel(label);
        this.setDatatype(XSD.STRING);
        this.optionalLanguageCache = Optional.empty();
    }

    protected SimpleLiteral(String label, String language) {
        this.setLabel(label);
        this.setLanguage(language);
    }

    protected SimpleLiteral(String label, IRI datatype) {
        this.setLabel(label);
        if (RDF.LANGSTRING.equals((Object)datatype)) {
            throw new IllegalArgumentException("datatype rdf:langString requires a language tag");
        }
        if (datatype == null) {
            this.setDatatype((CoreDatatype)CoreDatatype.XSD.STRING);
        } else {
            this.setDatatype(datatype);
        }
        this.optionalLanguageCache = Optional.empty();
    }

    protected SimpleLiteral(String label, IRI datatype, CoreDatatype coreDatatype) {
        assert (coreDatatype != null);
        assert (datatype != null);
        assert (coreDatatype == CoreDatatype.NONE || datatype == coreDatatype.getIri());
        if (CoreDatatype.RDF.LANGSTRING == coreDatatype) {
            throw new IllegalArgumentException("datatype rdf:langString requires a language tag");
        }
        this.setLabel(label);
        this.setDatatype(datatype, coreDatatype);
        this.optionalLanguageCache = Optional.empty();
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    protected SimpleLiteral(String label, XSD.Datatype datatype) {
        this.setLabel(label);
        if (RDF.LANGSTRING.equals((Object)datatype.getIri())) {
            throw new IllegalArgumentException("datatype rdf:langString requires a language tag");
        }
        if (datatype == null) {
            this.setDatatype((CoreDatatype)CoreDatatype.XSD.STRING);
        } else {
            this.setDatatype(datatype.getCoreDatatype());
        }
    }

    protected SimpleLiteral(String label, CoreDatatype datatype) {
        this.setLabel(label);
        if (datatype == CoreDatatype.RDF.LANGSTRING) {
            throw new IllegalArgumentException("datatype rdf:langString requires a language tag");
        }
        this.setDatatype(datatype);
        this.optionalLanguageCache = Optional.empty();
    }

    protected void setLabel(String label) {
        Objects.requireNonNull(label, "Literal label cannot be null");
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    protected void setLanguage(String language) {
        Objects.requireNonNull(language);
        if (language.isEmpty()) {
            throw new IllegalArgumentException("Language tag cannot be empty");
        }
        this.language = language;
        this.optionalLanguageCache = Optional.of(language);
        this.setDatatype((CoreDatatype)CoreDatatype.RDF.LANGSTRING);
    }

    public Optional<String> getLanguage() {
        if (this.optionalLanguageCache == null) {
            this.optionalLanguageCache = Optional.ofNullable(this.language);
        }
        return this.optionalLanguageCache;
    }

    protected void setDatatype(IRI datatype) {
        this.datatype = datatype;
        this.coreDatatype = CoreDatatype.from((IRI)datatype);
    }

    protected void setDatatype(IRI datatype, CoreDatatype coreDatatype) {
        assert (datatype != null);
        assert (coreDatatype != null);
        assert (coreDatatype == CoreDatatype.NONE || datatype == coreDatatype.getIri());
        this.datatype = datatype;
        this.coreDatatype = coreDatatype;
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    protected void setDatatype(XSD.Datatype datatype) {
        this.datatype = datatype.getIri();
        this.coreDatatype = datatype.getCoreDatatype();
    }

    protected void setDatatype(CoreDatatype datatype) {
        Objects.requireNonNull(datatype);
        this.datatype = datatype.getIri();
        this.coreDatatype = datatype;
    }

    public IRI getDatatype() {
        return this.datatype;
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    public Optional<XSD.Datatype> getXsdDatatype() {
        CoreDatatype coreDatatype = this.getCoreDatatype();
        return XSD.Datatype.from((CoreDatatype.XSD)coreDatatype.asXSDDatatype().orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Literal) {
            Literal other = (Literal)o;
            CoreDatatype coreDatatype = this.getCoreDatatype();
            if (coreDatatype != ((Literal)o).getCoreDatatype()) {
                return false;
            }
            if (coreDatatype == CoreDatatype.NONE && !this.datatype.equals((Object)other.getDatatype())) {
                return false;
            }
            if (!this.label.equals(other.getLabel())) {
                return false;
            }
            Optional<String> language = this.getLanguage();
            Optional otherLanguage = other.getLanguage();
            if (language.isPresent() && otherLanguage.isPresent()) {
                return language.get().equalsIgnoreCase((String)otherLanguage.get());
            }
            return language.isEmpty() && otherLanguage.isEmpty();
        }
        return false;
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public String toString() {
        if (Literals.isLanguageLiteral((Literal)this)) {
            StringBuilder sb = new StringBuilder(this.label.length() + this.language.length() + 3);
            sb.append('\"').append(this.label).append('\"');
            sb.append('@').append(this.language);
            return sb.toString();
        }
        if (XSD.STRING.equals((Object)this.datatype) || this.datatype == null) {
            StringBuilder sb = new StringBuilder(this.label.length() + 2);
            sb.append('\"').append(this.label).append('\"');
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(this.label.length() + this.datatype.stringValue().length() + 6);
        sb.append('\"').append(this.label).append('\"');
        sb.append("^^<").append(this.datatype.toString()).append(">");
        return sb.toString();
    }

    public String stringValue() {
        return this.label;
    }

    public boolean booleanValue() {
        return XMLDatatypeUtil.parseBoolean(this.label);
    }

    public byte byteValue() {
        return XMLDatatypeUtil.parseByte(this.label);
    }

    public short shortValue() {
        return XMLDatatypeUtil.parseShort(this.label);
    }

    public int intValue() {
        return XMLDatatypeUtil.parseInt(this.label);
    }

    public long longValue() {
        return XMLDatatypeUtil.parseLong(this.label);
    }

    public float floatValue() {
        return XMLDatatypeUtil.parseFloat(this.label);
    }

    public double doubleValue() {
        return XMLDatatypeUtil.parseDouble(this.label);
    }

    public BigInteger integerValue() {
        return XMLDatatypeUtil.parseInteger(this.label);
    }

    public BigDecimal decimalValue() {
        return XMLDatatypeUtil.parseDecimal(this.label);
    }

    public XMLGregorianCalendar calendarValue() {
        return XMLDatatypeUtil.parseCalendar(this.label);
    }

    public CoreDatatype getCoreDatatype() {
        if (this.coreDatatype == null) {
            this.coreDatatype = CoreDatatype.from((IRI)this.datatype);
        }
        return this.coreDatatype;
    }
}

