/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.function.Consumer;
import org.apache.zookeeper.server.ZooKeeperThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileChangeWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(FileChangeWatcher.class);
    private final WatcherThread watcherThread;
    private State state;

    public FileChangeWatcher(Path dirPath, Consumer<WatchEvent<?>> callback) throws IOException {
        FileSystem fs = dirPath.getFileSystem();
        WatchService watchService = fs.newWatchService();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering with watch service: " + dirPath);
        }
        dirPath.register(watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW}, SensitivityWatchEventModifier.HIGH);
        this.state = State.NEW;
        this.watcherThread = new WatcherThread(watchService, callback);
        this.watcherThread.setDaemon(true);
    }

    public synchronized State getState() {
        return this.state;
    }

    synchronized void waitForState(State desiredState) throws InterruptedException {
        while (this.state != desiredState) {
            this.wait();
        }
    }

    private synchronized void setState(State newState) {
        this.state = newState;
        this.notifyAll();
    }

    private synchronized boolean compareAndSetState(State expected, State update) {
        if (this.state == expected) {
            this.setState(update);
            return true;
        }
        return false;
    }

    private synchronized boolean compareAndSetState(State[] expectedStates, State update) {
        for (State expected : expectedStates) {
            if (this.state != expected) continue;
            this.setState(update);
            return true;
        }
        return false;
    }

    public void start() {
        if (!this.compareAndSetState(State.NEW, State.STARTING)) {
            return;
        }
        this.watcherThread.start();
    }

    public void stop() {
        if (this.compareAndSetState(new State[]{State.RUNNING, State.STARTING}, State.STOPPING)) {
            this.watcherThread.interrupt();
        }
    }

    private class WatcherThread
    extends ZooKeeperThread {
        private static final String THREAD_NAME = "FileChangeWatcher";
        final WatchService watchService;
        final Consumer<WatchEvent<?>> callback;

        WatcherThread(WatchService watchService, Consumer<WatchEvent<?>> callback) {
            super(THREAD_NAME);
            this.watchService = watchService;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                LOG.info(this.getName() + " thread started");
                if (!FileChangeWatcher.this.compareAndSetState(State.STARTING, State.RUNNING)) {
                    State state = FileChangeWatcher.this.getState();
                    if (state != State.STOPPING) {
                        throw new IllegalStateException("Unexpected state: " + (Object)((Object)state));
                    }
                    return;
                }
                this.runLoop();
            }
            catch (Exception e) {
                LOG.warn("Error in runLoop()", (Throwable)e);
                throw e;
            }
            finally {
                try {
                    this.watchService.close();
                }
                catch (IOException e) {
                    LOG.warn("Error closing watch service", (Throwable)e);
                }
                LOG.info(this.getName() + " thread finished");
                FileChangeWatcher.this.setState(State.STOPPED);
            }
        }

        private void runLoop() {
            while (FileChangeWatcher.this.getState() == State.RUNNING) {
                WatchKey key;
                try {
                    key = this.watchService.take();
                }
                catch (InterruptedException | ClosedWatchServiceException e) {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug(this.getName() + " was interrupted and is shutting down ...");
                    break;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Got file changed event: " + event.kind() + " with context: " + event.context());
                    }
                    try {
                        this.callback.accept(event);
                    }
                    catch (Throwable e) {
                        LOG.error("Error from callback", e);
                    }
                }
                boolean isKeyValid = key.reset();
                if (isKeyValid) continue;
                LOG.error("Watch key no longer valid, maybe the directory is inaccessible?");
                break;
            }
        }
    }

    public static enum State {
        NEW,
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED;

    }
}

