/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.optimizer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.federated.algebra.EmptyResult;
import org.eclipse.rdf4j.federated.algebra.ExclusiveGroup;
import org.eclipse.rdf4j.federated.algebra.FilterExpr;
import org.eclipse.rdf4j.federated.algebra.FilterTuple;
import org.eclipse.rdf4j.federated.algebra.NUnion;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.exception.OptimizationException;
import org.eclipse.rdf4j.federated.optimizer.FedXOptimizer;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterOptimizer
extends AbstractQueryModelVisitor<OptimizationException>
implements FedXOptimizer {
    private static final Logger log = LoggerFactory.getLogger(FilterOptimizer.class);

    @Override
    public void optimize(TupleExpr tupleExpr) {
        tupleExpr.visit((QueryModelVisitor)this);
    }

    public void meet(Filter filter) {
        if (filter.getArg() instanceof EmptyResult) {
            log.debug("Argument of filter expression does not yield results at the provided sources, replacing Filter node.");
            filter.replaceWith((QueryModelNode)filter.getArg());
            return;
        }
        ValueExpr valueExpr = filter.getCondition();
        ArrayList<ValueExpr> conjunctiveExpressions = new ArrayList<ValueExpr>();
        this.getConjunctiveExpressions(valueExpr, conjunctiveExpressions);
        FilterExprInsertVisitor filterExprVst = new FilterExprInsertVisitor();
        ArrayList<ValueExpr> remainingExpr = new ArrayList<ValueExpr>(conjunctiveExpressions.size());
        for (ValueExpr cond : conjunctiveExpressions) {
            if (this.isCompatibleExpr(cond)) {
                HashSet<String> exprVars = new VarFinder().findVars(cond);
                FilterExpr filterExpr = new FilterExpr(cond, exprVars);
                if (new FilterBindingFinder().isFilterOnAssignedBinding((TupleExpr)filter, filterExpr.getVars())) {
                    remainingExpr.add(filterExpr.getExpression());
                    continue;
                }
                filterExprVst.initialize(filterExpr);
                filter.getArg().visit((QueryModelVisitor)filterExprVst);
                if (filterExprVst.canRemove()) continue;
                remainingExpr.add(filterExpr.getExpression());
                continue;
            }
            remainingExpr.add(cond);
        }
        if (remainingExpr.isEmpty()) {
            filter.replaceWith((QueryModelNode)filter.getArg());
        } else if (remainingExpr.size() == 1) {
            filter.setCondition((ValueExpr)remainingExpr.get(0));
        } else {
            And root = new And();
            root.setLeftArg((ValueExpr)remainingExpr.get(0));
            And tmp = root;
            for (int i = 1; i < remainingExpr.size() - 1; ++i) {
                And _a = new And();
                _a.setLeftArg((ValueExpr)remainingExpr.get(i));
                tmp.setRightArg((ValueExpr)_a);
                tmp = _a;
            }
            tmp.setRightArg((ValueExpr)remainingExpr.get(remainingExpr.size() - 1));
            filter.setCondition((ValueExpr)root);
        }
        super.meet(filter);
    }

    public void meet(Service node) throws OptimizationException {
    }

    protected void getConjunctiveExpressions(ValueExpr expr, List<ValueExpr> conjExpr) {
        if (expr instanceof And) {
            And and = (And)expr;
            this.getConjunctiveExpressions(and.getLeftArg(), conjExpr);
            this.getConjunctiveExpressions(and.getRightArg(), conjExpr);
        } else {
            conjExpr.add(expr);
        }
    }

    protected boolean isCompatibleExpr(ValueExpr e) {
        if (e instanceof And || e instanceof Or) {
            return false;
        }
        if (e instanceof Not) {
            return this.isCompatibleExpr(((Not)e).getArg());
        }
        return true;
    }

    protected static class FilterExprInsertVisitor
    extends AbstractQueryModelVisitor<OptimizationException> {
        protected FilterExpr filterExpr = null;
        protected int added = 0;
        protected boolean isStatic = false;

        protected FilterExprInsertVisitor() {
        }

        public void initialize(FilterExpr filterExpr) {
            this.added = 0;
            this.filterExpr = filterExpr;
            this.isStatic = false;
        }

        public boolean canRemove() {
            return this.added > 0 && !this.isStatic;
        }

        public void meet(LeftJoin node) {
            this.isStatic = true;
            super.meet(node);
        }

        public void meet(Union node) {
            this.isStatic = true;
            super.meet(node);
        }

        public void meet(Difference node) {
            this.isStatic = true;
            super.meet(node);
        }

        public void meetOther(QueryModelNode node) {
            if (node instanceof FilterTuple) {
                if (node instanceof ExclusiveGroup) {
                    node.visitChildren((QueryModelVisitor)this);
                }
                this.handleFilter((FilterTuple)node, this.filterExpr);
            } else {
                if (node instanceof StatementTupleExpr) {
                    return;
                }
                super.meetOther(node);
            }
        }

        private void handleFilter(FilterTuple filterTuple, FilterExpr expr) {
            int intersected = 0;
            for (String filterVar : expr.getVars()) {
                if (!filterTuple.getFreeVars().contains(filterVar)) continue;
                ++intersected;
            }
            if (intersected == 0) {
                return;
            }
            if (expr.isCompareEq() && this.bindCompareInExpression(filterTuple, (Compare)expr.getExpression())) {
                ++this.added;
                return;
            }
            if (intersected == expr.getVars().size() && this.shouldAddFilter(filterTuple)) {
                filterTuple.addFilterExpr(expr);
                ++this.added;
            }
        }

        public boolean shouldAddFilter(FilterTuple filterTuple) {
            if (filterTuple.getParentNode() instanceof ExclusiveGroup) {
                return false;
            }
            if (this.hasUnionParent(filterTuple)) {
                return true;
            }
            if (this.added > 0) {
                return false;
            }
            return this.added == 0;
        }

        private boolean hasUnionParent(FilterTuple pattern) {
            for (QueryModelNode node = pattern.getParentNode(); node != null && node != this.filterExpr; node = node.getParentNode()) {
                if (!(node instanceof Union) && !(node instanceof NUnion)) continue;
                return true;
            }
            return false;
        }

        private boolean bindCompareInExpression(FilterTuple filterTuple, Compare cmp) {
            boolean isVarLeft = cmp.getLeftArg() instanceof Var;
            boolean isVarRight = cmp.getRightArg() instanceof Var;
            if (isVarLeft && isVarRight) {
                return false;
            }
            if (isVarLeft && cmp.getRightArg() instanceof ValueConstant) {
                String varName = ((Var)cmp.getLeftArg()).getName();
                Value value = ((ValueConstant)cmp.getRightArg()).getValue();
                filterTuple.addBoundFilter(varName, value);
                return true;
            }
            if (isVarRight && cmp.getLeftArg() instanceof ValueConstant) {
                String varName = ((Var)cmp.getRightArg()).getName();
                Value value = ((ValueConstant)cmp.getLeftArg()).getValue();
                filterTuple.addBoundFilter(varName, value);
                return true;
            }
            return false;
        }
    }

    protected static class FilterBindingFinder
    extends AbstractQueryModelVisitor<OptimizationException> {
        protected Set<String> vars;
        protected boolean isFilterOnAssignedBinding;

        protected FilterBindingFinder() {
        }

        public boolean isFilterOnAssignedBinding(TupleExpr expr, Set<String> filterArgs) {
            this.vars = filterArgs;
            expr.visit((QueryModelVisitor)this);
            return this.isFilterOnAssignedBinding;
        }

        public void meet(Extension node) {
            for (String var : this.vars) {
                if (!node.getBindingNames().contains(var)) continue;
                this.isFilterOnAssignedBinding = true;
                return;
            }
            super.meet(node);
        }

        public void meet(BindingSetAssignment node) {
            for (String var : this.vars) {
                if (!node.getBindingNames().contains(var)) continue;
                this.isFilterOnAssignedBinding = true;
                return;
            }
            super.meet(node);
        }
    }

    protected static class VarFinder
    extends AbstractQueryModelVisitor<OptimizationException> {
        protected HashSet<String> vars;

        protected VarFinder() {
        }

        public HashSet<String> findVars(ValueExpr expr) {
            this.vars = new HashSet();
            expr.visit((QueryModelVisitor)this);
            return this.vars;
        }

        public void meet(Var var) {
            if (var.getValue() == null) {
                this.vars.add(var.getName());
            }
            super.meet(var);
        }
    }
}

