/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.string;

import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public class StrAfter
implements Function {
    @Override
    public String getURI() {
        return FN.SUBSTRING_AFTER.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException("Incorrect number of arguments for STRAFTER: " + args.length);
        }
        Value leftArg = args[0];
        Value rightArg = args[1];
        if (leftArg instanceof Literal && rightArg instanceof Literal) {
            Literal leftLit = (Literal)leftArg;
            Literal rightLit = (Literal)rightArg;
            if (QueryEvaluationUtil.compatibleArguments(leftLit, rightLit)) {
                String lexicalValue = leftLit.getLabel();
                String substring = rightLit.getLabel();
                Optional leftLanguage = leftLit.getLanguage();
                IRI leftDt = leftLit.getDatatype();
                int index = lexicalValue.indexOf(substring);
                String substringAfter = "";
                if (index > -1) {
                    substringAfter = lexicalValue.substring((index += substring.length() - 1) + 1, lexicalValue.length());
                } else {
                    leftLanguage = Optional.empty();
                    leftDt = null;
                }
                if (leftLanguage.isPresent()) {
                    return valueFactory.createLiteral(substringAfter, (String)leftLanguage.get());
                }
                if (leftDt != null) {
                    return valueFactory.createLiteral(substringAfter, leftDt);
                }
                return valueFactory.createLiteral(substringAfter);
            }
            throw new ValueExprEvaluationException("incompatible operands for STRAFTER: " + leftArg + ", " + rightArg);
        }
        throw new ValueExprEvaluationException("incompatible operands for STRAFTER: " + leftArg + ", " + rightArg);
    }
}

