/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;

public class SparqlFragment {
    static final Pattern REGEX_INDENT = Pattern.compile("(?m)^");
    private final String fragment;
    private final List<String> unionFragments = new ArrayList<String>();
    private boolean filterCondition;
    private boolean bgp;
    private boolean union;
    private static final boolean USE_UNION_PRESERVING_JOIN = false;
    private final List<StatementMatcher> statementMatchers = new ArrayList<StatementMatcher>();

    private SparqlFragment(List<String> unionFragments, List<StatementMatcher> statementMatchers) {
        this.fragment = null;
        this.unionFragments.addAll(unionFragments);
        this.union = true;
        this.statementMatchers.addAll(statementMatchers);
    }

    private SparqlFragment(String fragment, boolean filterCondition, boolean bgp, List<StatementMatcher> statementMatchers) {
        this.fragment = fragment;
        this.filterCondition = filterCondition;
        this.bgp = bgp;
        this.statementMatchers.addAll(statementMatchers);
        assert (filterCondition != bgp);
    }

    public static SparqlFragment filterCondition(String fragment, List<StatementMatcher> statementMatchers) {
        return new SparqlFragment(fragment, true, false, statementMatchers);
    }

    public static SparqlFragment bgp(String fragment, List<StatementMatcher> statementMatchers) {
        return new SparqlFragment(fragment, false, true, statementMatchers);
    }

    public static SparqlFragment and(List<SparqlFragment> sparqlFragments) {
        String collect = sparqlFragments.stream().peek(s -> {
            assert (s.filterCondition);
        }).map(SparqlFragment::getFragment).collect(Collectors.joining(" ) && ( ", "( ", " )"));
        return SparqlFragment.filterCondition(collect, SparqlFragment.getStatementMatchers(sparqlFragments));
    }

    public static SparqlFragment or(List<SparqlFragment> sparqlFragments) {
        String collect = sparqlFragments.stream().peek(s -> {
            assert (s.filterCondition);
        }).map(SparqlFragment::getFragment).collect(Collectors.joining(" ) || ( ", "( ", " )"));
        return SparqlFragment.filterCondition(collect, SparqlFragment.getStatementMatchers(sparqlFragments));
    }

    public static SparqlFragment join(List<SparqlFragment> sparqlFragments) {
        String collect = sparqlFragments.stream().peek(s -> {
            assert (!s.filterCondition);
        }).map(SparqlFragment::getFragment).map(SparqlFragment::indent).reduce((a, b) -> a + " \n " + b).orElse("");
        return SparqlFragment.bgp(collect, SparqlFragment.getStatementMatchers(sparqlFragments));
    }

    private static SparqlFragment unionPreservingJoin(List<SparqlFragment> sparqlFragments) {
        List<Object> workingSet = new ArrayList<String>();
        SparqlFragment firstSparqlFragment = sparqlFragments.get(0);
        if (firstSparqlFragment.union) {
            workingSet.addAll(firstSparqlFragment.unionFragments);
        } else {
            assert (firstSparqlFragment.bgp);
            workingSet.add(firstSparqlFragment.fragment);
        }
        for (int i = 1; i < sparqlFragments.size(); ++i) {
            SparqlFragment sparqlFragment = sparqlFragments.get(i);
            if (sparqlFragment.union) {
                ArrayList<String> newWorkingSet = new ArrayList<String>();
                for (String unionFragment : sparqlFragment.unionFragments) {
                    for (String string : workingSet) {
                        newWorkingSet.add(string + "\n" + unionFragment);
                    }
                }
                workingSet = newWorkingSet;
                continue;
            }
            assert (sparqlFragment.bgp);
            workingSet = workingSet.stream().map(s -> sparqlFragment.fragment + "\n" + s).collect(Collectors.toList());
        }
        SparqlFragment union = SparqlFragment.union(workingSet.toArray(new String[0]));
        union.addStatementMatchers(SparqlFragment.getStatementMatchers(sparqlFragments));
        return union;
    }

    public static boolean isFilterCondition(List<SparqlFragment> sparqlFragments) {
        boolean isFilterCondtion = sparqlFragments.stream().anyMatch(SparqlFragment::isFilterCondition);
        assert (!isFilterCondtion || sparqlFragments.stream().allMatch(SparqlFragment::isFilterCondition));
        return isFilterCondtion;
    }

    public static SparqlFragment union(List<SparqlFragment> sparqlFragments) {
        List<String> sparqlFragmentString = sparqlFragments.stream().map(SparqlFragment::getFragment).collect(Collectors.toList());
        return new SparqlFragment(sparqlFragmentString, SparqlFragment.getStatementMatchers(sparqlFragments));
    }

    public static List<StatementMatcher> getStatementMatchers(List<SparqlFragment> sparqlFragments) {
        return sparqlFragments.stream().flatMap(s -> s.statementMatchers.stream()).collect(Collectors.toList());
    }

    public static SparqlFragment union(String ... query) {
        return new SparqlFragment(Arrays.asList(query), Collections.emptyList());
    }

    public String getFragment() {
        if (this.union) {
            return this.unionFragments.stream().map(SparqlFragment::indent).collect(Collectors.joining("\n} UNION {\n#VALUES_INJECTION_POINT#\n", "{\n#VALUES_INJECTION_POINT#\n", "\n}"));
        }
        return this.fragment;
    }

    public boolean isFilterCondition() {
        return this.filterCondition;
    }

    public List<StatementMatcher> getStatementMatchers() {
        return this.statementMatchers;
    }

    public void addStatementMatchers(List<StatementMatcher> statementMatchers) {
        this.statementMatchers.addAll(statementMatchers);
    }

    public static String indent(String toIndent) {
        return REGEX_INDENT.matcher(toIndent).replaceAll("\t");
    }

    private static /* synthetic */ boolean lambda$join$2(SparqlFragment s1) {
        return s1.union;
    }
}

