/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.logging.file.logback;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.common.logging.LogReader;
import org.eclipse.rdf4j.common.logging.LogRecord;
import org.eclipse.rdf4j.common.logging.base.AbstractLogReader;
import org.eclipse.rdf4j.common.logging.file.logback.FileLogReader;

public class MultipleFileLogReader
extends AbstractLogReader
implements LogReader {
    private Date startDate = null;
    private Date endDate = null;
    private Date minDate = new Date();
    private Date maxDate = new Date();
    private String fileNamePattern = null;
    private Vector<File> logFiles = new Vector();
    private Iterator<File> logFilesIterator = null;
    private LogRecord next = null;
    private int count = 0;
    private FileLogReader currentReader = null;

    @Override
    public boolean supportsDateRanges() {
        return true;
    }

    @Override
    public void setAppender(Appender<?> appender) {
        RollingPolicy rp;
        super.setAppender(appender);
        if (appender instanceof RollingFileAppender) {
            rp = ((RollingFileAppender)appender).getRollingPolicy();
            if (!(rp instanceof TimeBasedRollingPolicy)) {
                throw new UnsupportedOperationException("Must be TimeBasedRollingPolicy!");
            }
        } else {
            throw new RuntimeException("MultipleFileLogReader appender must be an instance of RollingFileAppender!");
        }
        this.fileNamePattern = ((TimeBasedRollingPolicy)rp).getFileNamePattern();
    }

    @Override
    public void init() throws Exception {
        Pattern dfPattern;
        Matcher dfMatcher;
        if (this.getAppender() == null) {
            throw new RuntimeException("Appender must be set before initialization!");
        }
        this.count = 0;
        this.logFiles = new Vector();
        Calendar startCal = null;
        Calendar endCal = null;
        if (this.startDate != null) {
            startCal = Calendar.getInstance();
            startCal.setTime(this.startDate);
        }
        if (this.endDate != null) {
            endCal = Calendar.getInstance();
            endCal.setTime(this.endDate);
        }
        if (!(dfMatcher = (dfPattern = Pattern.compile("(.+)%d\\{(.+)\\}")).matcher(this.fileNamePattern)).matches()) {
            throw new RuntimeException("Wrong filename pattern: " + this.fileNamePattern);
        }
        String dfs = dfMatcher.group(2);
        SimpleDateFormat df = new SimpleDateFormat(dfs);
        String spattern = new File(this.fileNamePattern).getName();
        spattern = spattern.replace(".", "\\.");
        spattern = spattern.replace("%d{" + dfs + "}", "(.*)");
        Pattern pattern = Pattern.compile(spattern);
        File dir = new File(this.fileNamePattern).getParentFile();
        Object[] files = dir.list(new DateRangeFilenameFilter(pattern, df, startCal, endCal));
        Arrays.sort(files);
        for (int i = files.length - 1; i >= 0; --i) {
            File f = new File(dir, (String)files[i]);
            this.logFiles.add(f);
            System.out.println(f.getAbsolutePath());
        }
        this.logFilesIterator = this.logFiles.iterator();
        if (this.logFilesIterator.hasNext()) {
            this.currentReader = new FileLogReader(this.logFilesIterator.next());
            this.currentReader.init();
            this.next = this.getNext();
            if (this.getOffset() > 0) {
                this.doSkip(this.getOffset());
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.getLimit() == 0) {
            return this.isMoreAvailable();
        }
        return this.isMoreAvailable() && this.count < this.getOffset() + this.getLimit();
    }

    @Override
    public boolean isMoreAvailable() {
        return this.next != null;
    }

    @Override
    public LogRecord next() {
        LogRecord result = this.next;
        try {
            this.next = this.getNext();
            ++this.count;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to get next log record.", ex);
        }
        if (!this.hasNext()) {
            try {
                this.destroy();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private LogRecord getNext() throws Exception {
        if (this.currentReader.hasNext()) {
            return this.currentReader.next();
        }
        if (this.logFilesIterator.hasNext()) {
            this.currentReader = new FileLogReader(this.logFilesIterator.next());
            this.currentReader.init();
            return this.getNext();
        }
        return null;
    }

    private void doSkip(int offset) {
        while (this.hasNext() && this.count < offset) {
            this.next();
        }
    }

    @Override
    public void destroy() throws IOException {
        if (this.currentReader.hasNext()) {
            this.currentReader.destroy();
        }
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public Date getMaxDate() {
        return this.maxDate;
    }

    @Override
    public Date getMinDate() {
        return this.minDate;
    }

    public class DateRangeFilenameFilter
    implements FilenameFilter {
        Pattern pattern;
        SimpleDateFormat df;
        Calendar startCal;
        Calendar endCal;

        public DateRangeFilenameFilter(Pattern pattern, SimpleDateFormat df, Calendar startCal, Calendar endCal) {
            this.pattern = pattern;
            this.df = df;
            this.startCal = startCal;
            this.endCal = endCal;
        }

        @Override
        public boolean accept(File dir, String name) {
            Date d;
            Matcher matcher = this.pattern.matcher(name);
            if (!matcher.matches()) {
                return false;
            }
            String ds = matcher.group(1);
            try {
                d = this.df.parse(ds);
            }
            catch (ParseException e) {
                e.printStackTrace();
                return false;
            }
            if (MultipleFileLogReader.this.maxDate == null || d.compareTo(MultipleFileLogReader.this.maxDate) > 0) {
                MultipleFileLogReader.this.maxDate = d;
            }
            if (MultipleFileLogReader.this.minDate == null || d.compareTo(MultipleFileLogReader.this.minDate) < 0) {
                MultipleFileLogReader.this.minDate = d;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            return !(this.startCal != null && cal.compareTo(this.startCal) < 0 || this.endCal != null && cal.compareTo(this.endCal) > 0);
        }
    }
}

