/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.HelperTool;
import org.eclipse.rdf4j.sail.shacl.ast.NodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EqualsJoinValue;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;

public class OrConstraintComponent
extends AbstractConstraintComponent {
    List<Shape> or;

    public OrConstraintComponent(Resource id, RepositoryConnection connection, Cache cache, ShaclSail shaclSail) {
        super(id);
        this.or = HelperTool.toList(connection, id, Resource.class).stream().map(r -> new ShaclProperties((Resource)r, connection)).map(p -> {
            if (p.getType() == SHACL.NODE_SHAPE) {
                return NodeShape.getInstance(p, connection, cache, false, shaclSail);
            }
            if (p.getType() == SHACL.PROPERTY_SHAPE) {
                return PropertyShape.getInstance(p, connection, cache, shaclSail);
            }
            throw new IllegalStateException("Unknown shape type for " + p.getId());
        }).collect(Collectors.toList());
    }

    public OrConstraintComponent(OrConstraintComponent orConstraintComponent) {
        super(orConstraintComponent.getId());
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection, Set<Resource> rdfListDedupe) {
        model.add(subject, SHACL.OR, (Value)this.getId(), new Resource[0]);
        if (!cycleDetection.contains(this.getId())) {
            cycleDetection.add(this.getId());
            this.or.forEach(o -> o.toModel(null, null, model, cycleDetection, rdfListDedupe));
        }
        if (!rdfListDedupe.contains(this.getId())) {
            rdfListDedupe.add(this.getId());
            HelperTool.listToRdf(this.or.stream().map(Shape::getId).collect(Collectors.toList()), this.getId(), model);
        }
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        super.setTargetChain(targetChain);
        for (Shape shape : this.or) {
            shape.setTargetChain(targetChain.setOptimizable(false));
        }
    }

    public List<Shape> getOr() {
        return Collections.unmodifiableList(this.or);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.OrConstraintComponent;
    }

    @Override
    public PlanNode generateSparqlValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        PlanNodeProvider planNodeProvider = overrideTargetNode != null ? overrideTargetNode : () -> this.getAllTargetsPlan(connectionsGroup, scope);
        PlanNode orPlanNodes = this.or.stream().map(or -> or.generateTransactionalValidationPlan(connectionsGroup, logValidationPlans, planNodeProvider, scope)).reduce((a, b) -> new EqualsJoinValue((PlanNode)a, (PlanNode)b, false)).orElse(new EmptyNode());
        Unique invalid = new Unique(orPlanNodes, false);
        return invalid;
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        PlanNode allTargets;
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, ConstraintComponent.Scope.nodeShape, true);
            allTargets = new Unique(new ShiftToPropertyShape(allTargetsPlan), true);
        } else {
            allTargets = this.getTargetChain().getEffectiveTarget("target_", scope, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, scope, true);
        }
        PlanNode planNode = this.or.stream().map(or -> or.getAllTargetsPlan(connectionsGroup, scope)).reduce((xva$0, xva$1) -> new UnionNode((PlanNode)xva$0, (PlanNode)xva$1)).orElse(new EmptyNode());
        return new Unique(new UnionNode(allTargets, planNode), false);
    }

    @Override
    public ConstraintComponent deepClone() {
        OrConstraintComponent constraintComponent = new OrConstraintComponent(this);
        constraintComponent.or = this.or.stream().map(ConstraintComponent::deepClone).map(a -> (Shape)a).collect(Collectors.toList());
        return constraintComponent;
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        return this.or.stream().anyMatch(c -> c.requiresEvaluation(connectionsGroup, scope));
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope) {
        boolean isFilterCondition = this.or.stream().map(o -> o.buildSparqlValidNodes_rsx_targetShape(subject, object, rdfsSubClassOfReasoner, scope)).map(SparqlFragment::isFilterCondition).findFirst().orElse(false);
        if (scope == ConstraintComponent.Scope.nodeShape) {
            if (!isFilterCondition) {
                String collect = this.or.stream().map(shape -> shape.buildSparqlValidNodes_rsx_targetShape(subject, object, rdfsSubClassOfReasoner, scope)).map(SparqlFragment::getFragment).map(s -> s.replaceAll("(?m)^", "\t")).collect(Collectors.joining("\n} UNION {\n#VALUES_INJECTION_POINT#\n", "{\n#VALUES_INJECTION_POINT#\n", "\n}"));
                return SparqlFragment.bgp(collect);
            }
            String collect = this.or.stream().map(shape -> shape.buildSparqlValidNodes_rsx_targetShape(subject, object, rdfsSubClassOfReasoner, scope)).map(SparqlFragment::getFragment).collect(Collectors.joining(" ) || ( ", "( ", " )"));
            return SparqlFragment.filterCondition(collect);
        }
        if (scope == ConstraintComponent.Scope.propertyShape) {
            if (!isFilterCondition) {
                throw new UnsupportedOperationException();
            }
            Path path = this.getTargetChain().getPath().get();
            String collect = this.or.stream().map(shape -> shape.buildSparqlValidNodes_rsx_targetShape(subject, object, rdfsSubClassOfReasoner, scope)).map(SparqlFragment::getFragment).collect(Collectors.joining(" ) || ( ", "( ", " )"));
            String pathQuery1 = path.getTargetQueryFragment(subject, object, rdfsSubClassOfReasoner);
            String query = pathQuery1 + "\n FILTER (! EXISTS {\n" + pathQuery1.replaceAll("(?m)^", "\t") + "\n\tFILTER(!(" + collect + "))\n})";
            String pathQuery2 = path.getTargetQueryFragment(subject, new StatementMatcher.Variable(UUID.randomUUID().toString().replace("-", "")), rdfsSubClassOfReasoner);
            query = "{\n#VALUES_INJECTION_POINT#\n " + query.replaceAll("(?m)^", "\t") + " \n} UNION {\n\t " + "#VALUES_INJECTION_POINT#" + "\n\t ?" + subject.getName() + " " + this.randomVariable() + " " + this.randomVariable() + ".\n\t FILTER(NOT EXISTS {\n " + pathQuery2.replaceAll("(?m)^", "\t") + " \n})\n}";
            return SparqlFragment.bgp(query);
        }
        throw new UnsupportedOperationException("Unknown scope: " + (Object)((Object)scope));
    }

    private String randomVariable() {
        return "?" + UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public Stream<StatementMatcher> getStatementMatchers_rsx_targetShape(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope) {
        StatementMatcher subjectPattern = new StatementMatcher(object, null, null);
        StatementMatcher objectPattern = new StatementMatcher(null, null, object);
        Stream statementPatternStream = this.or.stream().flatMap(c -> c.getStatementMatchers_rsx_targetShape(object, new StatementMatcher.Variable("someVarName"), rdfsSubClassOfReasoner, ConstraintComponent.Scope.nodeShape));
        return Stream.concat(statementPatternStream, Stream.of(subjectPattern, objectPattern));
    }
}

