/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.actions;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.version.ui.actions.AbstractAction;
import org.eclipse.oomph.version.ui.actions.Messages;
import org.eclipse.oomph.version.ui.dialogs.ExtendedConfigurationDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureBuildersAction
extends AbstractAction<Map<IProject, VersionBuilderArguments>> {
    private Map<IProject, VersionBuilderArguments> oldMap;

    public ConfigureBuildersAction() {
        super(Messages.ConfigureBuildersAction_title);
    }

    @Override
    protected Map<IProject, VersionBuilderArguments> promptArguments() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
        HashSet<String> releasePaths = new HashSet<String>();
        Object[] objectArray = structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                releasePaths.add(file.getFullPath().toString());
            }
            ++n2;
        }
        if (!releasePaths.isEmpty()) {
            this.oldMap = ConfigureBuildersAction.collectVersionBuilderArguments(releasePaths);
            ExtendedConfigurationDialog dialog = new ExtendedConfigurationDialog(this.shell, this.oldMap);
            if (dialog.open() == 0) {
                return dialog.getMap();
            }
        }
        return null;
    }

    @Override
    protected void runWithArguments(Map<IProject, VersionBuilderArguments> newMap) throws CoreException {
        for (Map.Entry<IProject, VersionBuilderArguments> entry : newMap.entrySet()) {
            VersionBuilderArguments newArguments;
            IProject project = entry.getKey();
            VersionBuilderArguments oldArguments = this.oldMap.get(project);
            if (oldArguments == null || (newArguments = entry.getValue()).equals((Object)oldArguments)) continue;
            newArguments.applyTo(project);
        }
    }

    public static Map<IProject, VersionBuilderArguments> collectVersionBuilderArguments(Collection<String> releasePaths) {
        HashMap<IProject, VersionBuilderArguments> map = new HashMap<IProject, VersionBuilderArguments>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            map.put(project, null);
            try {
                IProjectDescription description = project.getDescription();
                ICommand[] iCommandArray = description.getBuildSpec();
                int n3 = iCommandArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    VersionBuilderArguments arguments;
                    ICommand command = iCommandArray[n4];
                    if ("org.eclipse.oomph.version.VersionBuilder".equals(command.getBuilderName()) && releasePaths.contains((arguments = new VersionBuilderArguments(command.getArguments())).getReleasePath())) {
                        map.put(project, arguments);
                    }
                    ++n4;
                }
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
        return map;
    }
}

