/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.draw2d;

import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.uml2.diagram.common.draw2d.decoration.ComposablePolygonDecoration;
import org.eclipse.uml2.diagram.common.draw2d.decoration.ComposableRotatableDecoration;
import org.eclipse.uml2.diagram.common.draw2d.decoration.CompositeDecoration;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageSort;

public class MessageDestinationDecoration
extends CompositeDecoration {
    private static final PointList OPEN_ARROW;
    private static final PointList CLOSED_ARROW;
    private ComposablePolygonDecoration myOpenArrowDecoration;
    private ComposablePolygonDecoration myClosedArrowDecoration;

    static {
        int[] nArray = new int[10];
        nArray[0] = -2;
        nArray[1] = 1;
        nArray[4] = -2;
        nArray[5] = -1;
        nArray[8] = -2;
        nArray[9] = 1;
        OPEN_ARROW = new PointList(nArray);
        int[] nArray2 = new int[6];
        nArray2[0] = -2;
        nArray2[1] = 1;
        nArray2[4] = -2;
        nArray2[5] = -1;
        CLOSED_ARROW = new PointList(nArray2);
    }

    public MessageDestinationDecoration() {
        this.initAggregationDecorations();
    }

    private void initAggregationDecorations() {
        this.myOpenArrowDecoration = new ComposablePolygonDecoration();
        this.myOpenArrowDecoration.setTemplate(OPEN_ARROW.getCopy());
        this.myOpenArrowDecoration.setFill(false);
        if (this.getParent() != null && this.getParent().getForegroundColor() != null) {
            this.myOpenArrowDecoration.setBackgroundColor(this.getParent().getForegroundColor());
        }
        this.myClosedArrowDecoration = new ComposablePolygonDecoration();
        this.myClosedArrowDecoration.setTemplate(CLOSED_ARROW.getCopy());
        this.myClosedArrowDecoration.setFill(true);
        if (this.getParent() != null && this.getParent().getForegroundColor() != null) {
            this.myClosedArrowDecoration.setBackgroundColor(this.getParent().getForegroundColor());
        }
    }

    public void updateMessageSort(MessageSort sort) {
        if (sort == MessageSort.ASYNCH_CALL_LITERAL || sort == MessageSort.ASYNCH_SIGNAL_LITERAL) {
            this.addDecoration((ComposableRotatableDecoration)this.myClosedArrowDecoration);
            this.removeDecoration((ComposableRotatableDecoration)this.myOpenArrowDecoration);
        } else {
            this.addDecoration((ComposableRotatableDecoration)this.myOpenArrowDecoration);
            this.removeDecoration((ComposableRotatableDecoration)this.myClosedArrowDecoration);
        }
    }

    public void updateReply(MessageSort sort) {
        PolylineConnectionEx connection = (PolylineConnectionEx)this.getParent();
        if (sort == MessageSort.REPLY_LITERAL) {
            connection.setLineStyle(6);
            connection.setLineDash(new int[]{5, 5, 5, 5});
        } else {
            connection.setLineStyle(1);
        }
    }

    public void update(Message message, IPreferenceStore store) {
        this.updateMessageSort(message.getMessageSort());
        this.updateReply(message.getMessageSort());
    }
}

