/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.action;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.uml2.diagram.clazz.part.CustomMessages;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class ApplyStereotypeAction
extends DiagramAction {
    private static final String EMPTY_NAME = CustomMessages.ApplyStereotypeAction_empty_name;
    private Element myElement;
    private Stereotype myStereotype;

    public ApplyStereotypeAction(IWorkbenchPage workbenchPage, Element element, Stereotype stereotype) {
        super(workbenchPage);
        this.myElement = element;
        this.myStereotype = stereotype;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected Command getCommand() {
        final IGraphicalEditPart elementEditPart = this.getElementEditPart();
        if (elementEditPart == null) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = elementEditPart.getEditingDomain();
        StereotypeRequest request = new StereotypeRequest(editingDomain);
        request.setApplyNotUnapply(!this.isStereotypeAppliedTo(this.myElement, this.myStereotype));
        request.setElement(this.myElement);
        request.setStereotype(this.myStereotype);
        CompoundCommand command = new CompoundCommand();
        command.add((Command)new ICommandProxy((ICommand)new StereotypeCommand(request)));
        command.add(new Command(){

            public void execute() {
                for (Object nextChildEP : elementEditPart.getChildren()) {
                    if (!(nextChildEP instanceof ITextAwareEditPart)) continue;
                    ((ITextAwareEditPart)nextChildEP).refresh();
                }
            }
        });
        return command;
    }

    public boolean isEnabled() {
        return this.getElementEditPart() != null;
    }

    public void refresh() {
        super.refresh();
        this.setText(this.calculateText());
        this.setChecked(this.calculateChecked());
    }

    private String calculateText() {
        String name = this.myStereotype.getQualifiedName();
        return name != null ? name : EMPTY_NAME;
    }

    private boolean calculateChecked() {
        return this.isStereotypeAppliedTo(this.myElement, this.myStereotype);
    }

    private IGraphicalEditPart getElementEditPart() {
        for (Object next : this.getSelectedObjects()) {
            if (!(next instanceof IGraphicalEditPart)) continue;
            IGraphicalEditPart elementEditPart = (IGraphicalEditPart)next;
            return elementEditPart;
        }
        return null;
    }

    private boolean isStereotypeAppliedTo(Element element, Stereotype stereotype) {
        return element.isStereotypeApplied(stereotype);
    }

    private class StereotypeCommand
    extends EditElementCommand {
        protected StereotypeCommand(StereotypeRequest request) {
            super(request.isApplyNotUnapply() ? CustomMessages.ApplyStereotypeAction_apply_stereotype_command : CustomMessages.ApplyStereotypeAction_annapply_stereotype_command, (EObject)request.getElement(), (IEditCommandRequest)request);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            StereotypeRequest request = (StereotypeRequest)this.getRequest();
            if (request.isApplyNotUnapply()) {
                request.getElement().applyStereotype(request.getStereotype());
            } else {
                request.getElement().unapplyStereotype(request.getStereotype());
            }
            return CommandResult.newOKCommandResult((Object)request.getElement());
        }
    }

    private static class StereotypeRequest
    extends AbstractEditCommandRequest {
        private Element myElement;
        private boolean myApplyNotUnapply;
        private Stereotype myStereotype;

        public StereotypeRequest(TransactionalEditingDomain domain) {
            super(domain);
        }

        public void setApplyNotUnapply(boolean applyNotUnapply) {
            this.myApplyNotUnapply = applyNotUnapply;
        }

        public void setElement(Element element) {
            this.myElement = element;
        }

        public void setStereotype(Stereotype stereotype) {
            this.myStereotype = stereotype;
        }

        public Stereotype getStereotype() {
            return this.myStereotype;
        }

        public Element getElement() {
            return this.myElement;
        }

        public boolean isApplyNotUnapply() {
            return this.myApplyNotUnapply;
        }

        public Object getEditHelperContext() {
            return null;
        }
    }
}

