/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFWebPackage.java,v 1.2 2007/03/18 10:23:39 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfweb.util;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebFactory
 * @model kind="package"
 * @generated
 */
public interface RDFWebPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "rdfweb";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///odm 2006-02-17/org/omg/odm/RDF/RDFWeb.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "odm 2006-02-17.org.omg.odm.RDF.RDFWeb";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	RDFWebPackage eINSTANCE = org.eclipse.eodm.rdf.rdfweb.impl.RDFWebPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfweb.impl.DocumentImpl <em>Document</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfweb.impl.DocumentImpl
	 * @see org.eclipse.eodm.rdf.rdfweb.impl.RDFWebPackageImpl#getDocument()
	 * @generated
	 */
	int DOCUMENT = 0;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT__RDF_SIS_DEFINED_BY = RDFBasePackage.RDFS_RESOURCE__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT__RDF_SSEE_ALSO = RDFBasePackage.RDFS_RESOURCE__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT__RD_FTYPE = RDFBasePackage.RDFS_RESOURCE__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT__RDF_SMEMBER = RDFBasePackage.RDFS_RESOURCE__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT__NODE_ID = RDFBasePackage.RDFS_RESOURCE__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT__RDF_SCOMMENT = RDFBasePackage.RDFS_RESOURCE__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT__RDF_SLABEL = RDFBasePackage.RDFS_RESOURCE__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT__URI_REF = RDFBasePackage.RDFS_RESOURCE__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT__SUBJECT_STATEMENT = RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT__STATEMENT = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Local Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT__LOCAL_NAME = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Xml Base</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT__XML_BASE = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Namespace Definition</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT__NAMESPACE_DEFINITION = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the the '<em>Document</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_FEATURE_COUNT = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfweb.impl.LocalNameImpl <em>Local Name</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfweb.impl.LocalNameImpl
	 * @see org.eclipse.eodm.rdf.rdfweb.impl.RDFWebPackageImpl#getLocalName()
	 * @generated
	 */
	int LOCAL_NAME = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_NAME__NAME = 0;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_NAME__URI_REF = 1;

	/**
	 * The number of structural features of the the '<em>Local Name</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCAL_NAME_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfweb.impl.NamespaceImpl <em>Namespace</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfweb.impl.NamespaceImpl
	 * @see org.eclipse.eodm.rdf.rdfweb.impl.RDFWebPackageImpl#getNamespace()
	 * @generated
	 */
	int NAMESPACE = 2;

	/**
	 * The feature id for the '<em><b>Namespace URI Ref</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE__NAMESPACE_URI_REF = 0;

	/**
	 * The number of structural features of the the '<em>Namespace</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfweb.impl.NamespaceDefinitionImpl <em>Namespace Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfweb.impl.NamespaceDefinitionImpl
	 * @see org.eclipse.eodm.rdf.rdfweb.impl.RDFWebPackageImpl#getNamespaceDefinition()
	 * @generated
	 */
	int NAMESPACE_DEFINITION = 3;

	/**
	 * The feature id for the '<em><b>Namespace Prefix</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE_DEFINITION__NAMESPACE_PREFIX = 0;

	/**
	 * The feature id for the '<em><b>Namespace</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE_DEFINITION__NAMESPACE = 1;

	/**
	 * The number of structural features of the the '<em>Namespace Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE_DEFINITION_FEATURE_COUNT = 2;


	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfweb.Document <em>Document</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Document</em>'.
	 * @see org.eclipse.eodm.rdf.rdfweb.Document
	 * @generated
	 */
	EClass getDocument();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfweb.Document#getStatement <em>Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Statement</em>'.
	 * @see org.eclipse.eodm.rdf.rdfweb.Document#getStatement()
	 * @see #getDocument()
	 * @generated
	 */
	EReference getDocument_Statement();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.eodm.rdf.rdfweb.Document#getLocalName <em>Local Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Local Name</em>'.
	 * @see org.eclipse.eodm.rdf.rdfweb.Document#getLocalName()
	 * @see #getDocument()
	 * @generated
	 */
	EReference getDocument_LocalName();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfweb.Document#getXmlBase <em>Xml Base</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Xml Base</em>'.
	 * @see org.eclipse.eodm.rdf.rdfweb.Document#getXmlBase()
	 * @see #getDocument()
	 * @generated
	 */
	EReference getDocument_XmlBase();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.eodm.rdf.rdfweb.Document#getNamespaceDefinition <em>Namespace Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Namespace Definition</em>'.
	 * @see org.eclipse.eodm.rdf.rdfweb.Document#getNamespaceDefinition()
	 * @see #getDocument()
	 * @generated
	 */
	EReference getDocument_NamespaceDefinition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfweb.LocalName <em>Local Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Local Name</em>'.
	 * @see org.eclipse.eodm.rdf.rdfweb.LocalName
	 * @generated
	 */
	EClass getLocalName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.rdf.rdfweb.LocalName#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.eodm.rdf.rdfweb.LocalName#getName()
	 * @see #getLocalName()
	 * @generated
	 */
	EAttribute getLocalName_Name();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfweb.LocalName#getUriRef <em>Uri Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Uri Ref</em>'.
	 * @see org.eclipse.eodm.rdf.rdfweb.LocalName#getUriRef()
	 * @see #getLocalName()
	 * @generated
	 */
	EReference getLocalName_UriRef();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfweb.Namespace <em>Namespace</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Namespace</em>'.
	 * @see org.eclipse.eodm.rdf.rdfweb.Namespace
	 * @generated
	 */
	EClass getNamespace();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.rdf.rdfweb.Namespace#getNamespaceURIRef <em>Namespace URI Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Namespace URI Ref</em>'.
	 * @see org.eclipse.eodm.rdf.rdfweb.Namespace#getNamespaceURIRef()
	 * @see #getNamespace()
	 * @generated
	 */
	EReference getNamespace_NamespaceURIRef();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition <em>Namespace Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Namespace Definition</em>'.
	 * @see org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition
	 * @generated
	 */
	EClass getNamespaceDefinition();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition#getNamespacePrefix <em>Namespace Prefix</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Namespace Prefix</em>'.
	 * @see org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition#getNamespacePrefix()
	 * @see #getNamespaceDefinition()
	 * @generated
	 */
	EAttribute getNamespaceDefinition_NamespacePrefix();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition#getNamespace <em>Namespace</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Namespace</em>'.
	 * @see org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition#getNamespace()
	 * @see #getNamespaceDefinition()
	 * @generated
	 */
	EReference getNamespaceDefinition_Namespace();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	RDFWebFactory getrdfwebFactory();

} //RDFWebPackage
