/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: OWLBaseAdapterFactory.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.eodm.owl.owlbase.*;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFProperty;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.RDFStatement;
import org.eclipse.eodm.rdf.rdfs.RDFSClass;



/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage
 * @generated
 */
public class OWLBaseAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static OWLBasePackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLBaseAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = OWLBasePackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch the delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OWLBaseSwitch modelSwitch =
		new OWLBaseSwitch() {
			public Object caseOWLOntology(OWLOntology object) {
				return createOWLOntologyAdapter();
			}
			public Object caseOWLGraph(OWLGraph object) {
				return createOWLGraphAdapter();
			}
			public Object caseStatement(Statement object) {
				return createStatementAdapter();
			}
			public Object caseUniverse(Universe object) {
				return createUniverseAdapter();
			}
			public Object caseOWLOntologyProperty(OWLOntologyProperty object) {
				return createOWLOntologyPropertyAdapter();
			}
			public Object caseOWLClass(OWLClass object) {
				return createOWLClassAdapter();
			}
			public Object caseOWLRestriction(OWLRestriction object) {
				return createOWLRestrictionAdapter();
			}
			public Object caseOWLObjectProperty(OWLObjectProperty object) {
				return createOWLObjectPropertyAdapter();
			}
			public Object caseProperty(Property object) {
				return createPropertyAdapter();
			}
			public Object caseOWLDatatypeProperty(OWLDatatypeProperty object) {
				return createOWLDatatypePropertyAdapter();
			}
			public Object caseIndividual(Individual object) {
				return createIndividualAdapter();
			}
			public Object caseOWLAllDifferent(OWLAllDifferent object) {
				return createOWLAllDifferentAdapter();
			}
			public Object caseOWLDataRange(OWLDataRange object) {
				return createOWLDataRangeAdapter();
			}
			public Object caseOWLAnnotationProperty(OWLAnnotationProperty object) {
				return createOWLAnnotationPropertyAdapter();
			}
			public Object caseEnumeratedClass(EnumeratedClass object) {
				return createEnumeratedClassAdapter();
			}
			public Object caseIntersectionClass(IntersectionClass object) {
				return createIntersectionClassAdapter();
			}
			public Object caseUnionClass(UnionClass object) {
				return createUnionClassAdapter();
			}
			public Object caseComplementClass(ComplementClass object) {
				return createComplementClassAdapter();
			}
			public Object caseHasValueRestriction(HasValueRestriction object) {
				return createHasValueRestrictionAdapter();
			}
			public Object caseAllValuesFromRestriction(AllValuesFromRestriction object) {
				return createAllValuesFromRestrictionAdapter();
			}
			public Object caseSomeValuesFromRestriction(SomeValuesFromRestriction object) {
				return createSomeValuesFromRestrictionAdapter();
			}
			public Object caseCardinalityRestriction(CardinalityRestriction object) {
				return createCardinalityRestrictionAdapter();
			}
			public Object caseMaxCardinalityRestriction(MaxCardinalityRestriction object) {
				return createMaxCardinalityRestrictionAdapter();
			}
			public Object caseMinCardinalityRestriction(MinCardinalityRestriction object) {
				return createMinCardinalityRestrictionAdapter();
			}
			public Object caseRDFSResource(RDFSResource object) {
				return createRDFSResourceAdapter();
			}
			public Object caseGraph(RDFGraph object) {
				return createGraphAdapter();
			}
			public Object caseRDFStatement(RDFStatement object) {
				return createRDFStatementAdapter();
			}
			public Object caseRDFProperty(RDFProperty object) {
				return createRDFPropertyAdapter();
			}
			public Object caseRDFSClass(RDFSClass object) {
				return createRDFSClassAdapter();
			}
			public Object defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	public Adapter createAdapter(Notifier target) {
		return (Adapter)modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLOntology <em>OWL Ontology</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntology
	 * @generated
	 */
	public Adapter createOWLOntologyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLGraph <em>OWL Graph</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLGraph
	 * @generated
	 */
	public Adapter createOWLGraphAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.Statement <em>Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.Statement
	 * @generated
	 */
	public Adapter createStatementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.Universe <em>Universe</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.Universe
	 * @generated
	 */
	public Adapter createUniverseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLOntologyProperty <em>OWL Ontology Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntologyProperty
	 * @generated
	 */
	public Adapter createOWLOntologyPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLClass <em>OWL Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLClass
	 * @generated
	 */
	public Adapter createOWLClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLRestriction <em>OWL Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLRestriction
	 * @generated
	 */
	public Adapter createOWLRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLObjectProperty <em>OWL Object Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLObjectProperty
	 * @generated
	 */
	public Adapter createOWLObjectPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.Property <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.Property
	 * @generated
	 */
	public Adapter createPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty <em>OWL Datatype Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty
	 * @generated
	 */
	public Adapter createOWLDatatypePropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.Individual <em>Individual</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.Individual
	 * @generated
	 */
	public Adapter createIndividualAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLAllDifferent <em>OWL All Different</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLAllDifferent
	 * @generated
	 */
	public Adapter createOWLAllDifferentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLDataRange <em>OWL Data Range</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLDataRange
	 * @generated
	 */
	public Adapter createOWLDataRangeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.OWLAnnotationProperty <em>OWL Annotation Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.OWLAnnotationProperty
	 * @generated
	 */
	public Adapter createOWLAnnotationPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.EnumeratedClass <em>Enumerated Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.EnumeratedClass
	 * @generated
	 */
	public Adapter createEnumeratedClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.IntersectionClass <em>Intersection Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.IntersectionClass
	 * @generated
	 */
	public Adapter createIntersectionClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.UnionClass <em>Union Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.UnionClass
	 * @generated
	 */
	public Adapter createUnionClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.ComplementClass <em>Complement Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.ComplementClass
	 * @generated
	 */
	public Adapter createComplementClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.HasValueRestriction <em>Has Value Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.HasValueRestriction
	 * @generated
	 */
	public Adapter createHasValueRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction <em>All Values From Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction
	 * @generated
	 */
	public Adapter createAllValuesFromRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction <em>Some Values From Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction
	 * @generated
	 */
	public Adapter createSomeValuesFromRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.CardinalityRestriction <em>Cardinality Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.CardinalityRestriction
	 * @generated
	 */
	public Adapter createCardinalityRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction <em>Max Cardinality Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction
	 * @generated
	 */
	public Adapter createMaxCardinalityRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction <em>Min Cardinality Restriction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction
	 * @generated
	 */
	public Adapter createMinCardinalityRestrictionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource <em>RDFS Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource
	 * @generated
	 */
	public Adapter createRDFSResourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFGraph <em>RDFGraph</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFGraph
	 * @generated
	 */
	public Adapter createGraphAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement <em>RDF Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement
	 * @generated
	 */
	public Adapter createRDFStatementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty <em>RDF Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFProperty
	 * @generated
	 */
	public Adapter createRDFPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfs.RDFSClass <em>RDFS Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSClass
	 * @generated
	 */
	public Adapter createRDFSClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //OWLBaseAdapterFactory
