/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: RDFNamespaceMap.java,v 1.1 2007/03/18 08:39:03 lzhang Exp $
 */

package org.eclipse.eodm.rdf.resource.parser.impl;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition;

/**
 * RDFNamespaceMap
 */
public class RDFNamespaceMap {
    private static final String nsPrefix = "ns_";

    private static int nsIndex = 0;

    private Map namespaces = new HashMap();

    public String getKey() {
        return (nsPrefix + (nsIndex++));
    }

    public void addNamespace(NamespaceDefinition namespace) {
        if (namespace.getNamespacePrefix() == null
            || namespace.getNamespacePrefix() == "")
            namespace.setNamespacePrefix(nsPrefix + nsIndex++);
        namespaces.put(namespace.getNamespace().getNamespaceURIRef().getURIString(),
                namespace);
    }

    public void addNamespace(String uri, NamespaceDefinition namespace) {
        if (namespace.getNamespacePrefix() == null
            || namespace.getNamespacePrefix() == "")
            namespace.setNamespacePrefix(nsPrefix + nsIndex++);
        namespaces.put(uri, namespace);
    }

    public NamespaceDefinition getNamespace(String uri) {
        return (NamespaceDefinition) namespaces.get(uri);
    }

    public NamespaceDefinition removeNamespace(String uri) {
        return (NamespaceDefinition) namespaces.remove(uri);
    }

    public void removeAllNamespaces() {
        namespaces.clear();
    }
}