/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ProtocolStateMachine;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.internal.operations.NamespaceOperations;
import org.eclipse.uml2.uml.internal.operations.RedefinableElementOperations;
import org.eclipse.uml2.uml.internal.operations.StateMachineOperations;
import org.eclipse.uml2.uml.internal.operations.StateOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionOperations
extends NamespaceOperations {
    protected RegionOperations() {
    }

    public static boolean validateInitialVertex(Region region, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateDeepHistoryVertex(Region region, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateShallowHistoryVertex(Region region, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateOwned(Region region, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static Classifier redefinitionContext(Region region) {
        StateMachine sm = region.containingStateMachine();
        if (sm != null) {
            BehavioredClassifier context = sm.getContext();
            return context == null || !sm.getGenerals().isEmpty() ? sm : context;
        }
        return null;
    }

    public static boolean isRedefinitionContextValid(Region region, Region redefined) {
        if (redefined != null) {
            StateMachine stateMachine = region.getStateMachine();
            if (stateMachine != null) {
                return StateMachineOperations.getAllExtendedStateMachines(stateMachine).contains((Object)redefined.getStateMachine());
            }
            State state = region.getState();
            return state != null && StateOperations.getAllRedefinedStates(state).contains((Object)redefined.getState());
        }
        return false;
    }

    public static StateMachine containingStateMachine(Region region) {
        StateMachine stateMachine = region.getStateMachine();
        if (stateMachine == null) {
            State state = region.getState();
            return state == null ? null : state.containingStateMachine();
        }
        return stateMachine;
    }

    public static boolean belongsToPSM(Region region) {
        StateMachine stateMachine = region.getStateMachine();
        if (stateMachine != null) {
            return stateMachine instanceof ProtocolStateMachine;
        }
        State state = region.getState();
        if (state != null) {
            Region container = state.getContainer();
            return container != null && container.belongsToPSM();
        }
        return false;
    }

    public static boolean isConsistentWith(Region region, RedefinableElement redefinee) {
        if (redefinee != null && redefinee.isRedefinitionContextValid(region)) {
            Region redefineeRegion = (Region)redefinee;
            EList<Vertex> allSubvertices = RegionOperations.getAllSubvertices(region);
            for (Vertex redefineeSubvertex : redefineeRegion.getSubvertices()) {
                State redefinedState;
                if (!(redefineeSubvertex instanceof State) || (redefinedState = ((State)redefineeSubvertex).getRedefinedState()) == null || allSubvertices.contains((Object)redefinedState)) continue;
                return false;
            }
            EList<Transition> allTransitions = RegionOperations.getAllTransitions(region);
            for (Transition redefineeTransition : redefineeRegion.getTransitions()) {
                Transition redefinedTransition = redefineeTransition.getRedefinedTransition();
                if (redefinedTransition == null || allTransitions.contains((Object)redefinedTransition)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static EList<Region> getAllExtendedRegions(Region region, EList<Region> allExtendedRegions) {
        Region extendedRegion = region.getExtendedRegion();
        if (extendedRegion != null && allExtendedRegions.add((Object)extendedRegion)) {
            RegionOperations.getAllExtendedRegions(extendedRegion, allExtendedRegions);
        }
        return allExtendedRegions;
    }

    protected static EList<Region> getAllExtendedRegions(Region region) {
        return RegionOperations.getAllExtendedRegions(region, (EList<Region>)new UniqueEList.FastCompare());
    }

    protected static EList<Vertex> getAllSubvertices(Region region) {
        UniqueEList.FastCompare allSubvertices = new UniqueEList.FastCompare(region.getSubvertices());
        for (Region extendedRegion : RegionOperations.getAllExtendedRegions(region)) {
            allSubvertices.addAll(extendedRegion.getSubvertices());
        }
        return RedefinableElementOperations.excludeRedefinedElements(allSubvertices);
    }

    protected static EList<Transition> getAllTransitions(Region region) {
        UniqueEList.FastCompare allTransitions = new UniqueEList.FastCompare(region.getTransitions());
        for (Region extendedRegion : RegionOperations.getAllExtendedRegions(region)) {
            allTransitions.addAll(extendedRegion.getTransitions());
        }
        return RedefinableElementOperations.excludeRedefinedElements(allTransitions);
    }
}

