/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.sheet.chooser;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.uml2.diagram.common.sheet.chooser.MetaclassContainmentFilter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLContainmentFilter
extends ViewerFilter {
    private static MetaclassContainmentFilter TEMPLATE_EXCLUDED;
    private static MetaclassContainmentFilter NOTHING_EXCLUDED;
    private Set<EClass> myAllowedMetaclasses;

    public UMLContainmentFilter(EReference feature, boolean considerUMLTemplates) {
        MetaclassContainmentFilter metaFilter = considerUMLTemplates ? UMLContainmentFilter.getTemplateAwareInstance() : UMLContainmentFilter.getWithoutTemplatesInstance();
        this.myAllowedMetaclasses = metaFilter.getAncestorsOrSelf(feature.getEReferenceType());
    }

    public boolean select(Viewer viewer, Object parentElement, Object object) {
        if (!(object instanceof Element)) {
            return true;
        }
        Element umlElement = (Element)object;
        if (umlElement instanceof ElementImport) {
            umlElement = ((ElementImport)umlElement).getImportedElement();
        }
        return umlElement != null && this.myAllowedMetaclasses.contains(umlElement.eClass());
    }

    public static MetaclassContainmentFilter getTemplateAwareInstance() {
        if (NOTHING_EXCLUDED == null) {
            NOTHING_EXCLUDED = new MetaclassContainmentFilter((EPackage)UMLPackage.eINSTANCE, Collections.<EReference>emptyList());
        }
        return NOTHING_EXCLUDED;
    }

    public static MetaclassContainmentFilter getWithoutTemplatesInstance() {
        if (TEMPLATE_EXCLUDED == null) {
            UMLPackage UML = UMLPackage.eINSTANCE;
            List<EReference> templateRelated = Arrays.asList(UML.getTemplateableElement_TemplateBinding(), UML.getTemplateSignature_OwnedParameter(), UML.getTemplateParameter_OwnedParameteredElement(), UML.getTemplateParameter_OwnedDefault());
            TEMPLATE_EXCLUDED = new MetaclassContainmentFilter((EPackage)UML, templateRelated);
        }
        return TEMPLATE_EXCLUDED;
    }
}

