/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.constraint;

import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.ValueSpecification;

public class ConstraintUtils {
    private static final String OCL_LANGUAGE = "OCL";

    public static String getOCLConstraintBody(Constraint umlConstraint) {
        ValueSpecification s = umlConstraint.getSpecification();
        if (s != null && s instanceof OpaqueExpression) {
            return ConstraintUtils.getOCLBodyFromOpaqueExpression((OpaqueExpression)s);
        }
        return null;
    }

    public static void setOCLConstraintBody(Constraint umlConstraint, String body) {
        ValueSpecification s = umlConstraint.getSpecification();
        if (s != null && s instanceof OpaqueExpression) {
            ConstraintUtils.setOCLBodyToOpaqueExpression((OpaqueExpression)s, body);
        }
    }

    public static String getOCLBodyFromOpaqueExpression(OpaqueExpression e) {
        if (ConstraintUtils.isOCLOpaqueExpression(e)) {
            EList bodies = e.getBodies();
            return bodies.isEmpty() ? null : (String)bodies.get(0);
        }
        return null;
    }

    public static void setOCLBodyToOpaqueExpression(OpaqueExpression e, String body) {
        if (ConstraintUtils.isOCLOpaqueExpression(e)) {
            EList bodies = e.getBodies();
            if (bodies.isEmpty()) {
                bodies.add((Object)body);
            } else {
                bodies.set(0, (Object)body);
            }
        }
    }

    public static boolean isOCLOpaqueExpression(OpaqueExpression e) {
        EList lans = e.getLanguages();
        return !lans.isEmpty() && OCL_LANGUAGE.equals(lans.get(0));
    }
}

