/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.async;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.uml2.diagram.common.Messages;
import org.eclipse.uml2.diagram.common.async.SyncModelContentProvider;
import org.eclipse.uml2.diagram.common.async.SyncModelLabelProvider;
import org.eclipse.uml2.diagram.common.async.SyncModelNode;

public class SyncModelUI {
    private SyncModelNode myRootNode;
    private final SyncModelLabelProvider myLabelProvider;
    private CheckboxTreeViewer myTreeViewer;
    private CheckListener myCheckListener;
    private CheckStateInitializer myCheckStateInitializer;

    public SyncModelUI(Composite parent, SyncModelLabelProvider labelProvider) {
        this.myLabelProvider = labelProvider;
        this.createContents(parent);
    }

    private void createContents(Composite composite) {
        CheckboxFilteredTree filterTree = new CheckboxFilteredTree(composite, 2820, new PatternFilter());
        this.myTreeViewer = filterTree.getCheckboxTreeViewer();
        this.myLabelProvider.hookTreeViewer(this.myTreeViewer);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 300;
        this.myTreeViewer.getTree().setLayoutData((Object)layoutData);
        this.myTreeViewer.setContentProvider((IContentProvider)new SyncModelContentProvider());
        this.myTreeViewer.setLabelProvider((IBaseLabelProvider)this.myLabelProvider);
        this.myTreeViewer.setComparator(new ViewerComparator());
        this.myCheckStateInitializer = new CheckStateInitializer(this.myTreeViewer);
        this.myTreeViewer.addTreeListener((ITreeViewerListener)this.myCheckStateInitializer);
        this.myCheckListener = new CheckListener(this.myTreeViewer);
        this.myTreeViewer.addCheckStateListener((ICheckStateListener)this.myCheckListener);
        new MenuBuilder(this.myTreeViewer).attachMenu();
    }

    public void setRootNode(SyncModelNode rootNode) {
        this.myRootNode = rootNode;
        this.myTreeViewer.setInput((Object)new SyncModelNode[]{rootNode});
        if (this.myCheckListener != null) {
            this.myCheckListener.setAlwaysChecked(rootNode);
        }
        this.myTreeViewer.setGrayChecked((Object)rootNode, true);
    }

    public void revealRootChildren() {
        if (this.myRootNode != null) {
            this.myTreeViewer.expandToLevel(2);
            TreeExpansionEvent expandEvent = new TreeExpansionEvent((AbstractTreeViewer)this.myTreeViewer, (Object)this.myRootNode);
            this.myCheckStateInitializer.treeExpanded(expandEvent);
        }
    }

    public SyncModelNode getRootSyncNode() {
        return this.myRootNode;
    }

    public CheckboxTreeViewer getUI() {
        return this.myTreeViewer;
    }

    private static class BulkSelectAction
    extends SyncModelUIAction {
        private final boolean mySelectNotUnselect;
        private final CheckboxTreeViewer mySyncModelUI;
        private SyncModelNode mySelected;

        public BulkSelectAction(CheckboxTreeViewer syncModelUI, boolean selectNotUnselect) {
            this.mySyncModelUI = syncModelUI;
            this.mySelectNotUnselect = selectNotUnselect;
        }

        public void update(CheckboxTreeViewer viewer) {
            this.mySelected = null;
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            this.setEnabled(selection.size() == 1);
            if (selection.size() != 1) {
                return;
            }
            this.mySelected = (SyncModelNode)selection.getFirstElement();
            this.setEnabled(!this.mySelected.isKnownLeaf() && !this.mySelected.getChildren().isEmpty());
        }

        public void run() {
            for (SyncModelNode nextDirectChild : this.mySelected.getChildren()) {
                if (this.isFiltered(this.mySelected, nextDirectChild)) continue;
                nextDirectChild.setChecked(this.mySelectNotUnselect);
                this.mySyncModelUI.setChecked((Object)nextDirectChild, this.mySelectNotUnselect);
            }
            if (!this.mySelectNotUnselect) {
                this.mySelected.setAutoSynchronized(false);
            }
            this.mySyncModelUI.refresh((Object)this.mySelected);
        }

        private boolean isFiltered(SyncModelNode parent, SyncModelNode child) {
            ViewerFilter[] viewerFilterArray = this.mySyncModelUI.getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter nextFilter = viewerFilterArray[n2];
                if (!nextFilter.select((Viewer)this.mySyncModelUI, (Object)parent, (Object)child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static class CheckListener
    implements ICheckStateListener {
        private final CheckboxTreeViewer myViewer;
        private SyncModelNode myAlwaysChecked;

        public CheckListener(CheckboxTreeViewer viewer) {
            this.myViewer = viewer;
        }

        public void setAlwaysChecked(SyncModelNode root) {
            this.myAlwaysChecked = root;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object subject = event.getElement();
            if (this.myAlwaysChecked != null && subject == this.myAlwaysChecked) {
                this.myViewer.setChecked(subject, true);
                return;
            }
            if (!(subject instanceof SyncModelNode)) {
                return;
            }
            SyncModelNode node = (SyncModelNode)subject;
            node.setChecked(event.getChecked());
            boolean refreshNeeded = false;
            if (event.getChecked()) {
                SyncModelNode next = node.getParent();
                while (next != null) {
                    refreshNeeded |= !next.isChecked();
                    next.setChecked(true);
                    this.myViewer.setChecked((Object)next, true);
                    next = next.getParent();
                }
                if (node.isAutoSynchronized()) {
                    for (SyncModelNode nextChild : node.getChildren()) {
                        refreshNeeded |= nextChild.isChecked();
                        nextChild.setChecked(true);
                        this.myViewer.setChecked((Object)nextChild, true);
                    }
                }
            } else {
                SyncModelNode parent = node.getParent();
                refreshNeeded = parent.isAutoSynchronized();
                parent.setAutoSynchronized(false);
                for (SyncModelNode nextChild : node.getChildren()) {
                    refreshNeeded |= nextChild.isChecked();
                    nextChild.setChecked(false);
                    this.myViewer.setChecked((Object)nextChild, false);
                }
            }
            if (refreshNeeded) {
                this.myViewer.refresh(true);
            }
        }
    }

    private static class CheckStateInitializer
    implements ITreeViewerListener {
        private final List<Object> myExpandedNodes = new ArrayList<Object>();
        private final CheckboxTreeViewer myViewer;

        public CheckStateInitializer(CheckboxTreeViewer viewer) {
            this.myViewer = viewer;
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Object expanded = event.getElement();
            if (this.myExpandedNodes.contains(expanded)) {
                return;
            }
            this.myExpandedNodes.add(expanded);
            Object[] objectArray = this.getTreeContentProvider().getChildren(expanded);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object nextChild = objectArray[n2];
                if (nextChild instanceof SyncModelNode) {
                    SyncModelNode node = (SyncModelNode)nextChild;
                    this.myViewer.setChecked((Object)node, node.isChecked());
                }
                ++n2;
            }
        }

        private ITreeContentProvider getTreeContentProvider() {
            return (ITreeContentProvider)this.myViewer.getContentProvider();
        }
    }

    private class CheckboxFilteredTree
    extends FilteredTree {
        public CheckboxFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
            super(parent, treeStyle, filter, true);
        }

        protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
            return new CheckboxTreeViewer(parent, style);
        }

        public CheckboxTreeViewer getCheckboxTreeViewer() {
            return (CheckboxTreeViewer)this.getViewer();
        }
    }

    private static class MenuBuilder
    implements IMenuListener {
        private final CheckboxTreeViewer myViewer;
        private final SyncModelUIAction mySwitchSyncAction;
        private final SyncModelUIAction mySelectAllChildrenAction;
        private final SyncModelUIAction myUnselectAllChildrenAction;

        public MenuBuilder(CheckboxTreeViewer viewer) {
            this.myViewer = viewer;
            this.mySwitchSyncAction = new SwitchSynchronizationAction(viewer);
            this.mySelectAllChildrenAction = new BulkSelectAction(viewer, true);
            this.myUnselectAllChildrenAction = new BulkSelectAction(viewer, false);
            this.mySelectAllChildrenAction.setText(Messages.SyncModelUI_action_select_all_children);
            this.myUnselectAllChildrenAction.setText(Messages.SyncModelUI_action_unselect_all_children);
        }

        public void attachMenu() {
            MenuManager menuManager = new MenuManager();
            menuManager.addMenuListener((IMenuListener)this);
            menuManager.add((IAction)this.mySwitchSyncAction);
            menuManager.add((IAction)this.mySelectAllChildrenAction);
            menuManager.add((IAction)this.myUnselectAllChildrenAction);
            this.myViewer.getTree().setMenu(menuManager.createContextMenu((Control)this.myViewer.getTree()));
        }

        public void removeMenu() {
            this.myViewer.getTree().setMenu(null);
        }

        public void menuAboutToShow(IMenuManager manager) {
            this.mySwitchSyncAction.update(this.myViewer);
            this.mySelectAllChildrenAction.update(this.myViewer);
            this.myUnselectAllChildrenAction.update(this.myViewer);
        }
    }

    private static class SwitchSynchronizationAction
    extends SyncModelUIAction {
        private final CheckboxTreeViewer mySyncModelUI;
        private SyncModelNode mySelected;

        public SwitchSynchronizationAction(CheckboxTreeViewer syncModelUI) {
            this.mySyncModelUI = syncModelUI;
        }

        public void update(CheckboxTreeViewer viewer) {
            this.mySelected = null;
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            this.setEnabled(selection.size() == 1);
            if (selection.size() != 1) {
                return;
            }
            this.mySelected = (SyncModelNode)selection.getFirstElement();
            if (this.mySelected.isAutoSynchronized()) {
                this.setText(Messages.SyncModelUI_action_disable_sync);
            } else {
                this.setText(Messages.SyncModelUI_action_enable_sync);
            }
        }

        public void run() {
            if (this.mySelected.isAutoSynchronized()) {
                this.mySelected.setAutoSynchronized(false);
            } else {
                this.mySelected.setAutoSynchronized(true);
                for (SyncModelNode nextDirectChild : this.mySelected.getChildren()) {
                    nextDirectChild.setChecked(true);
                    this.mySyncModelUI.setChecked((Object)nextDirectChild, true);
                }
            }
            this.mySyncModelUI.refresh((Object)this.mySelected);
        }
    }

    private static abstract class SyncModelUIAction
    extends Action {
        private SyncModelUIAction() {
        }

        public abstract void update(CheckboxTreeViewer var1);
    }
}

