/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.owl.resource.parser.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.eodm.OWLFactory;
import org.eclipse.eodm.exceptions.AddingTripleException;
import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.owl.owlbase.OWLGraph;
import org.eclipse.eodm.owl.owlbase.OWLOntology;
import org.eclipse.eodm.owl.resource.parser.OWLDocument;
import org.eclipse.eodm.owl.resource.parser.OWLParser;
import org.eclipse.eodm.owl.resource.parser.exception.OWLParserException;
import org.eclipse.eodm.owl.resource.parser.impl.OWLDocumentImpl;
import org.eclipse.eodm.owl.resource.parser.impl.OWLOntologyGraph;
import org.eclipse.eodm.owl.resource.parser.impl.OWLParserResultHandler;
import org.eclipse.eodm.owl.resource.parser.impl.OWLParserTripleAnalyzer;
import org.eclipse.eodm.owl.resource.parser.impl.OntologyTripleAnalyzer;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.resource.parser.NamespaceHandler;
import org.eclipse.eodm.rdf.resource.parser.StatementHandler;
import org.eclipse.eodm.rdf.resource.parser.exception.ParserException;
import org.eclipse.eodm.rdf.resource.parser.xml.RDFXMLParserImpl;
import org.eclipse.eodm.util.Triple;
import org.xml.sax.InputSource;

public class OWLParserImpl
implements OWLParser {
    private ArrayList documents = new ArrayList();
    private Hashtable parsedResults = new Hashtable();
    private Hashtable mapping = new Hashtable();
    static /* synthetic */ Class class$0;

    public void addOWLDocument(OWLDocument document) throws OWLParserException {
        String defaultBaseURI;
        if (document == null || document.getLocalURI() == null && document.getPublicURI() == null) {
            throw new OWLParserException("Document is not valid.");
        }
        if (this.getOWLDocument(document) != null) {
            System.out.print("Document already exists.");
            return;
        }
        this.documents.add(document);
        OntologyTripleAnalyzer tripleAnalyser = new OntologyTripleAnalyzer(document);
        RDFXMLParserImpl parser = new RDFXMLParserImpl();
        OWLParserResultHandler resultHandler = new OWLParserResultHandler(tripleAnalyser);
        parser.setNamespaceHandler((NamespaceHandler)resultHandler);
        parser.setStatementHandler((StatementHandler)resultHandler);
        InputSource input = new InputSource(document.readInput());
        if (document.getCharset() != null) {
            input.setEncoding(document.getCharset());
        }
        if ((defaultBaseURI = document.getDefaultBaseURI()) == null) {
            if (document.isLocalFile()) {
                StringBuffer buffer = new StringBuffer("file:///");
                int i = 0;
                while (i < document.getLocalURI().length()) {
                    if (document.getLocalURI().charAt(i) == '\\') {
                        buffer.append('/');
                    } else if (document.getLocalURI().charAt(i) != ' ') {
                        buffer.append(document.getLocalURI().charAt(i));
                    }
                    ++i;
                }
                defaultBaseURI = buffer.toString();
            } else {
                defaultBaseURI = document.getPublicURI();
            }
            document.setDefaultBaseURI(defaultBaseURI);
        }
        try {
            parser.parse(input, defaultBaseURI);
        }
        catch (ParserException e) {
            throw new OWLParserException("RDF parsing error", e);
        }
        input = null;
        try {
            if (!document.getLocalURI().equals("OWLInputStream")) {
                document.readInput().close();
                document.setInputStream(null);
            }
        }
        catch (OWLParserException e) {
            e.printStackTrace();
            throw new OWLParserException("Parser IO exception: " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OWLParserException("Parser IO exception: " + e.getMessage());
        }
        parser = null;
    }

    public void addOWLDocument(String localFileName) throws OWLParserException {
        if (localFileName == null || localFileName.length() == 0) {
            return;
        }
        OWLDocumentImpl doc = new OWLDocumentImpl(localFileName, null, true);
        this.addOWLDocument(doc);
    }

    /*
     * Unable to fully structure code
     */
    public OWLOntologyGraph[] parseOWLDocument(OWLDocument document) throws OWLParserException {
        block42: {
            doc = this.getOWLDocument(document);
            if (doc == null) {
                this.addOWLDocument(document);
            } else if (doc.isParsed()) {
                return (OWLOntologyGraph[])this.parsedResults.get(doc.getPublicURI());
            }
            docList = new LinkedList<String>();
            docList.addFirst(document.getPublicURI());
            iter = document.getImportOntologyURIs(true).iterator();
            while (iter.hasNext()) {
                str = (String)iter.next();
                if (this.isEixstingURI(str, docList)) continue;
                docList.addLast(str);
            }
            tripleAnalyser = new OWLParserTripleAnalyzer();
            resultHandler = new OWLParserResultHandler(tripleAnalyser);
            i = 0;
            while (i < docList.size()) {
                childdoc = null;
                documentURI = (String)docList.get(i);
                childdoc = this.getOWLDocumentbyPublicURI(documentURI);
                if (childdoc == null) {
                    url = null;
                    try {
                        url = new URL(documentURI);
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                        throw new OWLParserException("Parser exception: " + e1.getMessage());
                    }
                    if (url != null && url.getProtocol().equalsIgnoreCase("file")) {
                        try {
                            file = new File(url.getPath()).getCanonicalPath();
                            childdoc = new OWLDocumentImpl(file, null, true);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            throw new OWLParserException("Parser exception: " + e.getMessage());
                        }
                    } else {
                        name = (String)this.mapping.get(documentURI);
                        childdoc = name == null ? new OWLDocumentImpl(null, documentURI, false) : new OWLDocumentImpl(name, documentURI, true);
                    }
                    this.addOWLDocument(childdoc);
                }
                if (!childdoc.isParsed()) {
                    parser = new RDFXMLParserImpl();
                    parser.setNamespaceHandler((NamespaceHandler)resultHandler);
                    parser.setStatementHandler((StatementHandler)resultHandler);
                    links = childdoc.getImportOntologyURIs(true);
                    jj = 0;
                    while (jj < links.size()) {
                        str = (String)links.get(jj);
                        if (!this.isEixstingURI(str, docList)) {
                            docList.addLast(str);
                        }
                        if ((importingList = this.getOWLDocumentbyImportingURI(childdoc.getPublicURI())) != null) {
                            j = 0;
                            while (j < importingList.size()) {
                                ((OWLDocument)importingList.get(j)).addImportOntologyURIs(str);
                                ++j;
                            }
                        }
                        ++jj;
                    }
                    tripleAnalyser.initialize(childdoc.getPublicURI());
                    input = new InputSource(childdoc.readInput());
                    if (childdoc.getCharset() != null) {
                        input.setEncoding(childdoc.getCharset());
                    }
                    try {
                        parser.parse(input, childdoc.getDefaultBaseURI());
                    }
                    catch (ParserException e) {
                        throw new OWLParserException("RDF parsing error: " + e.getCause());
                    }
                    tripleAnalyser.postProcessing();
                    this.parsedResults.put(childdoc.getPublicURI(), tripleAnalyser.getOWLOntologyGraph());
                    childdoc.setParsed();
                    childdoc.setOntologyGraph(tripleAnalyser.getOWLOntologyGraph());
                    parser = null;
                }
                ++i;
            }
            i = 0;
            while (i < docList.size()) {
                childdoc = this.getOWLDocumentbyPublicURI((String)docList.get(i));
                if (childdoc == null) {
                    docList.remove(i);
                    --i;
                }
                ++i;
            }
            ontologygraph = new OWLOntologyGraph[docList.size()];
            igraph = null;
            if (docList.size() <= 1) break block42;
            try {
                igraph = OWLFactory.eINSTANCE.createOWLGraph(document.getPublicURI());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                throw new OWLParserException("Parser exception: " + e.getMessage());
            }
            igraph = this.mergeGraph(igraph, document.getOntologyGraph().getgraph());
            i = 0;
            while (i < docList.size()) {
                childdoc = this.getOWLDocumentbyPublicURI((String)docList.get(i));
                g = childdoc.getOntologyGraph();
                iter = null;
                try {
                    iter = g.getgraph().getTypeResources("http://www.w3.org/2002/07/owl#Ontology").iterator();
                    if (true) ** GOTO lbl121
                }
                catch (UnsupportedViewTypeException e) {
                    e.printStackTrace();
                    throw new OWLParserException("Parser exception: " + e.getMessage());
                }
                do {
                    try {
                        v0 = (RDFSResource)iter.next();
                        v1 = OWLParserImpl.class$0;
                        if (v1 == null) {
                            try {
                                v1 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLOntology");
                            }
                            catch (ClassNotFoundException v2) {
                                throw new NoClassDefFoundError(v2.getMessage());
                            }
                        }
                        g.setOntology((OWLOntology)v0.asType((Class)v1));
                    }
                    catch (UnsupportedViewTypeException e) {
                        e.printStackTrace();
                        throw new OWLParserException("Parser exception: " + e.getMessage());
                    }
lbl121:
                    // 2 sources

                } while (iter != null && iter.hasNext());
                ontologygraph[i] = g;
                if (i > 0) {
                    igraph = this.mergeGraph(igraph, g.getgraph());
                }
                ++i;
            }
            ontologygraph[0].setgraph(igraph);
            this.parsedResults.put(document.getPublicURI(), ontologygraph);
            return ontologygraph;
        }
        g = document.getOntologyGraph();
        try {
            iter = g.getgraph().getTypeResources("http://www.w3.org/2002/07/owl#Ontology").iterator();
            if (true) ** GOTO lbl154
        }
        catch (UnsupportedViewTypeException e) {
            e.printStackTrace();
            throw new OWLParserException("Parser exception: " + e.getMessage());
        }
        do {
            try {
                v3 = (RDFSResource)iter.next();
                v4 = OWLParserImpl.class$0;
                if (v4 == null) {
                    try {
                        v4 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLOntology");
                    }
                    catch (ClassNotFoundException v5) {
                        throw new NoClassDefFoundError(v5.getMessage());
                    }
                }
                g.setOntology((OWLOntology)v3.asType((Class)v4));
            }
            catch (UnsupportedViewTypeException e) {
                e.printStackTrace();
                throw new OWLParserException("Parser exception: " + e.getMessage());
            }
lbl154:
            // 2 sources

        } while (iter != null && iter.hasNext());
        ontologygraph[0] = g;
        this.parsedResults.put(document.getPublicURI(), ontologygraph);
        return ontologygraph;
    }

    public void clear() {
        this.documents.clear();
        this.parsedResults.clear();
    }

    public void clearDocument(String localFileName) {
        int i = 0;
        while (i < this.documents.size()) {
            OWLDocument doc = (OWLDocument)this.documents.get(i);
            if (doc.getLocalURI().equals(localFileName)) {
                this.documents.remove(i);
                return;
            }
            ++i;
        }
    }

    public List getOWLDocuments() {
        return this.documents;
    }

    public OWLDocument getOWLDocument(OWLDocument document) {
        if (this.documents.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < this.documents.size()) {
            OWLDocument doc = (OWLDocument)this.documents.get(i);
            if (document.getPublicURI() != null && doc.getPublicURI() != null && document.getPublicURI().equals(doc.getPublicURI())) {
                return doc;
            }
            if (document.getLocalURI() != null && doc.getLocalURI() != null && document.getLocalURI().equals(doc.getLocalURI())) {
                return doc;
            }
            ++i;
        }
        return null;
    }

    private OWLDocument getOWLDocumentbyPublicURI(String uri) {
        if (this.documents.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < this.documents.size()) {
            OWLDocument doc = (OWLDocument)this.documents.get(i);
            if (doc.getPublicURI() != null && uri.equals(doc.getPublicURI())) {
                return doc;
            }
            ++i;
        }
        return null;
    }

    private boolean isEixstingURI(String uri, LinkedList docList) {
        int i = 0;
        while (i < docList.size()) {
            if (uri.equals(docList.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private List getOWLDocumentbyImportingURI(String URI2) {
        ArrayList<OWLDocument> list = new ArrayList<OWLDocument>();
        int i = 0;
        while (i < this.documents.size()) {
            OWLDocument document = (OWLDocument)this.documents.get(i);
            Iterator iter = document.getImportOntologyURIs(true).iterator();
            while (iter.hasNext()) {
                if (!URI2.equals((String)iter.next())) continue;
                list.add(document);
                break;
            }
            ++i;
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    public OWLOntologyGraph[] parseOWLDocument(String localFileName) throws OWLParserException {
        if (localFileName == null || localFileName.length() == 0) {
            return null;
        }
        OWLDocumentImpl doc = new OWLDocumentImpl(localFileName, null, true);
        return this.parseOWLDocument(doc);
    }

    private OWLGraph mergeGraph(OWLGraph g1, OWLGraph g2) {
        Iterator triples = g2.exportTriples().iterator();
        while (triples.hasNext()) {
            Triple triple = (Triple)triples.next();
            try {
                if (!triple.getPredicateUriRef().getURIString().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) continue;
                g1.addTriple(triple);
            }
            catch (UnsupportedViewTypeException e) {
                e.printStackTrace();
                throw new OWLParserException("Parser exception: " + e.getMessage());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                throw new OWLParserException("Parser exception: " + e.getMessage());
            }
            catch (AddingTripleException e) {
                e.printStackTrace();
                throw new OWLParserException("Parser exception: " + e.getMessage());
            }
        }
        Iterator triples2 = g2.exportTriples().iterator();
        while (triples2.hasNext()) {
            Triple triple2 = (Triple)triples2.next();
            try {
                g1.addTriple(triple2);
            }
            catch (UnsupportedViewTypeException e) {
                e.printStackTrace();
                throw new OWLParserException("Parser exception: " + e.getMessage());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                throw new OWLParserException("Parser exception: " + e.getMessage());
            }
            catch (AddingTripleException e) {
                e.printStackTrace();
                throw new OWLParserException("Parser exception: " + e.getMessage());
            }
        }
        return g1;
    }

    public void addURL2FileMapping(String url, String filename) {
        String name = (String)this.mapping.get(url);
        if (name == null) {
            this.mapping.put(url, filename);
        }
    }
}

