/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.usecase.part;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.diagram.usecase.edit.commands.UMLCreateShortcutDecorationsCommand;
import org.eclipse.uml2.diagram.usecase.edit.parts.PackageEditPart;
import org.eclipse.uml2.diagram.usecase.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.usecase.part.UMLDiagramUpdateCommand;
import org.eclipse.uml2.diagram.usecase.part.UMLElementChooserDialog;

public class UMLCreateShortcutAction
implements IObjectActionDelegate {
    private PackageEditPart mySelectedElement;
    private Shell myShell;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myShell = targetPart.getSite().getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.mySelectedElement = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof PackageEditPart) {
            this.mySelectedElement = (PackageEditPart)((Object)structuredSelection.getFirstElement());
        }
        action.setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        return this.mySelectedElement != null;
    }

    public void run(IAction action) {
        EObject selectedElement;
        View view = (View)this.mySelectedElement.getModel();
        UMLElementChooserDialog elementChooser = new UMLElementChooserDialog(this.myShell, view);
        int result = elementChooser.open();
        if (result != 0) {
            return;
        }
        URI selectedModelElementURI = elementChooser.getSelectedModelElementURI();
        try {
            selectedElement = this.mySelectedElement.getEditingDomain().getResourceSet().getEObject(selectedModelElementURI, true);
        }
        catch (WrappedException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Exception while loading object: " + selectedModelElementURI.toString(), e);
            return;
        }
        if (selectedElement == null) {
            return;
        }
        CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(selectedElement), Node.class, null, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        CreateCommand command = new CreateCommand(this.mySelectedElement.getEditingDomain(), viewDescriptor, view);
        command = command.compose((IUndoableOperation)new UMLCreateShortcutDecorationsCommand(this.mySelectedElement.getEditingDomain(), view, viewDescriptor));
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            UMLDiagramUpdateCommand.performCanonicalUpdate(view.getDiagram().getElement());
        }
        catch (ExecutionException e) {
            UMLDiagramEditorPlugin.getInstance().logError("Unable to create shortcut", e);
        }
    }
}

