/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.awt.Color;
import java.awt.Point;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMountingRegion;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMVisibleFrameWithPentagon;

public class LMMountingLink {
    private LMFrame myFrame;
    private LMMountingRegion myMountingRegion;
    private final AbsLink myGdeLink;
    private Color mySavedValidColor = null;

    LMMountingLink(AbsLink gdeLink) {
        this.myGdeLink = gdeLink;
    }

    AbsLink getGdeLink() {
        return this.myGdeLink;
    }

    public LMFrame getFrame() {
        return this.myFrame;
    }

    void setFrame(LMFrame frame) {
        this.myFrame = frame;
    }

    LMMountingRegion getMountingRegion() {
        return this.myMountingRegion;
    }

    void setMountingRegion(LMMountingRegion mountingRegion) {
        this.myMountingRegion = mountingRegion;
    }

    void setXPosition(int newPos) {
        Point firstOldPoint = this.getFirstLinkPoint();
        this.setLinkPoints(newPos, firstOldPoint.y);
    }

    void setFrameTopPosition(int pos) {
        if (this.mySavedValidColor == null && this.myFrame.tryToUseAsPositionResponsibleLink(this)) {
            this.myFrame.setTopBorderPosFromMountingLink(pos);
        }
        Point firstOldPoint = this.getFirstLinkPoint();
        this.setLinkPoints(firstOldPoint.x, pos);
    }

    void setFrameBottomPosition(int pos) {
        if (this.mySavedValidColor != null) {
            return;
        }
        if (!this.myFrame.tryToUseAsPositionResponsibleLink(this)) {
            return;
        }
        this.myFrame.setBottomBorderPos(pos);
    }

    private Point getFirstLinkPoint() {
        Point[] points = this.getGdeLink().getLinkPoints();
        if (points.length == 0) {
            return new Point(0, 0);
        }
        return points[0];
    }

    private void setLinkPoints(int x, int y) {
        if (this.getFrame() instanceof LMVisibleFrameWithPentagon) {
            this.getGdeLink().setLinkPoints(new Point[]{new Point(x, y), new Point(x, y)});
        }
    }

    boolean isValid() {
        return this.mySavedValidColor == null;
    }

    void setInvalid(boolean invalid) {
        if (this.mySavedValidColor == null && invalid) {
            this.mySavedValidColor = this.myGdeLink.getForeground();
            this.myGdeLink.setForeground(Color.RED);
        } else if (this.mySavedValidColor != null && !invalid) {
            this.myGdeLink.setForeground(this.mySavedValidColor);
            this.mySavedValidColor = null;
        }
        if (!invalid) {
            this.myFrame.flushPositionResponsibleLink();
        }
    }
}

