/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.sheet;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.diagram.common.sheet.TextAndDialogCellEditor;
import org.eclipse.uml2.diagram.common.sheet.chooser.ReferencedElementChooserDialog;
import org.eclipse.uml2.uml.NamedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceDialogCellEditor
extends TextAndDialogCellEditor {
    private final ReferencedElementChooserDialog myElementChooserDialog;
    private final Collection<?> myChoiceOfValues;
    private Map<String, NamedElement> myName2Elements;

    public ReferenceDialogCellEditor(Composite parent, ReferencedElementChooserDialog chooserDialog, Collection<?> choiceOfValues, ILabelProvider labelProvider) {
        super(parent, labelProvider);
        this.myElementChooserDialog = chooserDialog;
        this.myChoiceOfValues = choiceOfValues;
        this.setValidator(new NamedElementValidator());
    }

    public ReferenceDialogCellEditor(Composite parent, ReferencedElementChooserDialog chooserDialog, ILabelProvider labelProvider) {
        super(parent, labelProvider);
        this.myElementChooserDialog = chooserDialog;
        this.myChoiceOfValues = null;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        this.myElementChooserDialog.open();
        return this.myElementChooserDialog.getResult();
    }

    protected void doSetValue(Object value) {
        if (ReferencedElementChooserDialog.NULL_VALUE.equals(value)) {
            value = null;
        }
        super.doSetValue(value);
    }

    @Override
    protected Object doGetValue() {
        Object value = super.doGetValue();
        if (value != null && value instanceof String) {
            if (value.equals(this.labelProvider.getText(this.getObjectValue()))) {
                return this.getObjectValue();
            }
            return this.findElementByName((String)value);
        }
        return value;
    }

    private Object findElementByName(String name) {
        return this.getName2ElementMap().get(name);
    }

    private boolean elementsExists(String name) {
        return this.findElementByName(name) != null;
    }

    private Map<String, NamedElement> getName2ElementMap() {
        if (this.myName2Elements == null) {
            this.myName2Elements = this.buildName2ElementMap();
        }
        return this.myName2Elements;
    }

    private Map<String, NamedElement> buildName2ElementMap() {
        if (this.myChoiceOfValues == null) {
            return Collections.emptyMap();
        }
        HashMap<String, NamedElement> result = new HashMap<String, NamedElement>();
        for (Object next : this.myChoiceOfValues) {
            String name;
            if (!(next instanceof NamedElement) || result.containsKey(name = ((NamedElement)next).getName())) continue;
            result.put(name, (NamedElement)next);
        }
        return result;
    }

    private class NamedElementValidator
    implements ICellEditorValidator {
        private NamedElementValidator() {
        }

        public String isValid(Object value) {
            if (value != null && value instanceof String) {
                if (value.equals(ReferenceDialogCellEditor.this.labelProvider.getText(ReferenceDialogCellEditor.this.getObjectValue()))) {
                    return null;
                }
                if (!ReferenceDialogCellEditor.this.elementsExists((String)value)) {
                    return "Cannot find element with name {0}";
                }
            }
            return null;
        }
    }
}

