/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uml2.articles;

import com.ibm.uml2.articles.UML2Article;
import org.eclipse.emf.common.util.URI;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Association;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Enumeration;
import org.eclipse.uml2.EnumerationLiteral;
import org.eclipse.uml2.Generalization;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.PrimitiveType;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Factory;

public class GettingStartedWithUML2
extends UML2Article {
    protected static Model createModel(String name) {
        Model model = UML2Factory.eINSTANCE.createModel();
        model.setName(name);
        GettingStartedWithUML2.out("Model '" + model.getQualifiedName() + "' created.");
        return model;
    }

    protected static Package createPackage(Package nestingPackage, String name) {
        Package package_ = nestingPackage.createNestedPackage(name);
        GettingStartedWithUML2.out("Package '" + package_.getQualifiedName() + "' created.");
        return package_;
    }

    protected static PrimitiveType createPrimitiveType(Package package_, String name) {
        PrimitiveType primitiveType = package_.createOwnedPrimitiveType(name);
        GettingStartedWithUML2.out("Primitive type '" + primitiveType.getQualifiedName() + "' created.");
        return primitiveType;
    }

    protected static Enumeration createEnumeration(Package package_, String name) {
        Enumeration enumeration = package_.createOwnedEnumeraton(name);
        GettingStartedWithUML2.out("Enumeration '" + enumeration.getQualifiedName() + "' created.");
        return enumeration;
    }

    protected static EnumerationLiteral createEnumerationLiteral(Enumeration enumeration, String name) {
        EnumerationLiteral enumerationLiteral = enumeration.createOwnedLiteral(name);
        GettingStartedWithUML2.out("Enumeration literal '" + enumerationLiteral.getQualifiedName() + "' created.");
        return enumerationLiteral;
    }

    protected static Class createClass(Package package_, String name, boolean isAbstract) {
        Class class_ = package_.createOwnedClass(name, isAbstract);
        GettingStartedWithUML2.out("Class '" + class_.getQualifiedName() + "' created.");
        return class_;
    }

    protected static Generalization createGeneralization(Classifier specificClassifier, Classifier generalClassifier) {
        Generalization generalization = specificClassifier.createGeneralization(generalClassifier);
        GettingStartedWithUML2.out("Generalization " + specificClassifier.getQualifiedName() + " ->> " + generalClassifier.getQualifiedName() + " created.");
        return generalization;
    }

    protected static Property createAttribute(Class class_, String name, Type type, int lowerBound, int upperBound) {
        Property attribute = class_.createOwnedAttribute(name, type, lowerBound, upperBound);
        StringBuffer sb = new StringBuffer();
        sb.append("Attribute '");
        sb.append(attribute.getQualifiedName());
        sb.append("' : ");
        sb.append(type.getQualifiedName());
        sb.append(" [");
        sb.append(lowerBound);
        sb.append("..");
        sb.append(-1 == upperBound ? "*" : String.valueOf(upperBound));
        sb.append("]");
        sb.append(" created.");
        GettingStartedWithUML2.out(sb.toString());
        return attribute;
    }

    protected static Association createAssociation(Type type1, boolean end1IsNavigable, AggregationKind end1Aggregation, String end1Name, int end1LowerBound, int end1UpperBound, Type type2, boolean end2IsNavigable, AggregationKind end2Aggregation, String end2Name, int end2LowerBound, int end2UpperBound) {
        Association association = type1.createAssociation(end1IsNavigable, end1Aggregation, end1Name, end1LowerBound, end1UpperBound, type2, end2IsNavigable, end2Aggregation, end2Name, end2LowerBound, end2UpperBound);
        StringBuffer sb = new StringBuffer();
        sb.append("Association ");
        if (end1Name == null || end1Name.length() == 0) {
            sb.append('{');
            sb.append(type1.getQualifiedName());
            sb.append('}');
        } else {
            sb.append("'");
            sb.append(type1.getQualifiedName());
            sb.append("::");
            sb.append(end1Name);
            sb.append("'");
        }
        sb.append(" [");
        sb.append(end1LowerBound);
        sb.append("..");
        sb.append(-1 == end1UpperBound ? "*" : String.valueOf(end1UpperBound));
        sb.append("] ");
        sb.append(end2IsNavigable ? (char)'<' : '-');
        sb.append('-');
        sb.append(end1IsNavigable ? (char)'>' : '-');
        sb.append(' ');
        if (end2Name == null || end2Name.length() == 0) {
            sb.append('{');
            sb.append(type2.getQualifiedName());
            sb.append('}');
        } else {
            sb.append("'");
            sb.append(type2.getQualifiedName());
            sb.append("::");
            sb.append(end2Name);
            sb.append("'");
        }
        sb.append(" [");
        sb.append(end2LowerBound);
        sb.append("..");
        sb.append(-1 == end2UpperBound ? "*" : String.valueOf(end2UpperBound));
        sb.append("]");
        sb.append(" created.");
        GettingStartedWithUML2.out(sb.toString());
        return association;
    }

    public static void main(String[] args) {
        if (1 != args.length) {
            GettingStartedWithUML2.err("Usage: java GettingStartedWithUML2 <URI>");
            System.exit(1);
        }
        GettingStartedWithUML2.registerResourceFactories();
        GettingStartedWithUML2.out("Creating model...");
        Model epo2Model = GettingStartedWithUML2.createModel("epo2");
        GettingStartedWithUML2.out("Creating primitive types...");
        PrimitiveType intPrimitiveType = GettingStartedWithUML2.createPrimitiveType((Package)epo2Model, "int");
        PrimitiveType stringPrimitiveType = GettingStartedWithUML2.createPrimitiveType((Package)epo2Model, "String");
        PrimitiveType datePrimitiveType = GettingStartedWithUML2.createPrimitiveType((Package)epo2Model, "Date");
        PrimitiveType skuPrimitiveType = GettingStartedWithUML2.createPrimitiveType((Package)epo2Model, "SKU");
        GettingStartedWithUML2.out("Creating enumerations...");
        Enumeration orderStatusEnumeration = GettingStartedWithUML2.createEnumeration((Package)epo2Model, "OrderStatus");
        GettingStartedWithUML2.out("Creating enumeration literals...");
        GettingStartedWithUML2.createEnumerationLiteral(orderStatusEnumeration, "Pending");
        GettingStartedWithUML2.createEnumerationLiteral(orderStatusEnumeration, "BackOrder");
        GettingStartedWithUML2.createEnumerationLiteral(orderStatusEnumeration, "Complete");
        GettingStartedWithUML2.out("Creating classes...");
        Class supplierClass = GettingStartedWithUML2.createClass((Package)epo2Model, "Supplier", false);
        Class customerClass = GettingStartedWithUML2.createClass((Package)epo2Model, "Customer", false);
        Class purchaseOrderClass = GettingStartedWithUML2.createClass((Package)epo2Model, "PurchaseOrder", false);
        Class itemClass = GettingStartedWithUML2.createClass((Package)epo2Model, "Item", false);
        Class addressClass = GettingStartedWithUML2.createClass((Package)epo2Model, "Address", true);
        Class usAddressClass = GettingStartedWithUML2.createClass((Package)epo2Model, "USAddress", false);
        Class globalAddressClass = GettingStartedWithUML2.createClass((Package)epo2Model, "GlobalAddress", false);
        Class globalLocationClass = GettingStartedWithUML2.createClass((Package)epo2Model, "GlobalLocation", false);
        GettingStartedWithUML2.out("Creating generalizations...");
        GettingStartedWithUML2.createGeneralization((Classifier)usAddressClass, (Classifier)addressClass);
        GettingStartedWithUML2.createGeneralization((Classifier)globalAddressClass, (Classifier)addressClass);
        GettingStartedWithUML2.createGeneralization((Classifier)globalAddressClass, (Classifier)globalLocationClass);
        GettingStartedWithUML2.out("Creating attributes...");
        GettingStartedWithUML2.createAttribute(supplierClass, "name", (Type)stringPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(customerClass, "customerID", (Type)intPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(purchaseOrderClass, "comment", (Type)stringPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(purchaseOrderClass, "orderDate", (Type)datePrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(purchaseOrderClass, "status", (Type)orderStatusEnumeration, 0, 1);
        GettingStartedWithUML2.createAttribute(purchaseOrderClass, "totalAmount", (Type)intPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(itemClass, "productName", (Type)stringPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(itemClass, "quantity", (Type)intPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(itemClass, "USPrice", (Type)intPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(itemClass, "comment", (Type)stringPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(itemClass, "shipDate", (Type)datePrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(itemClass, "partNum", (Type)skuPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(addressClass, "name", (Type)stringPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(addressClass, "country", (Type)stringPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(usAddressClass, "street", (Type)stringPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(usAddressClass, "city", (Type)stringPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(usAddressClass, "state", (Type)stringPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(usAddressClass, "zip", (Type)intPrimitiveType, 0, 1);
        GettingStartedWithUML2.createAttribute(globalAddressClass, "location", (Type)stringPrimitiveType, 0, -1);
        GettingStartedWithUML2.createAttribute(globalLocationClass, "countryCode", (Type)intPrimitiveType, 0, 1);
        GettingStartedWithUML2.out("Creating associations...");
        GettingStartedWithUML2.createAssociation((Type)supplierClass, true, AggregationKind.COMPOSITE_LITERAL, "orders", 0, -1, (Type)purchaseOrderClass, false, AggregationKind.NONE_LITERAL, "", 1, 1);
        GettingStartedWithUML2.createAssociation((Type)supplierClass, true, AggregationKind.NONE_LITERAL, "pendingOrders", 0, -1, (Type)purchaseOrderClass, false, AggregationKind.NONE_LITERAL, "", 0, 1);
        GettingStartedWithUML2.createAssociation((Type)supplierClass, true, AggregationKind.NONE_LITERAL, "shippedOrders", 0, -1, (Type)purchaseOrderClass, false, AggregationKind.NONE_LITERAL, "", 0, 1);
        GettingStartedWithUML2.createAssociation((Type)supplierClass, true, AggregationKind.COMPOSITE_LITERAL, "customers", 0, -1, (Type)customerClass, false, AggregationKind.NONE_LITERAL, "", 1, 1);
        GettingStartedWithUML2.createAssociation((Type)customerClass, true, AggregationKind.NONE_LITERAL, "orders", 0, -1, (Type)purchaseOrderClass, true, AggregationKind.NONE_LITERAL, "customer", 1, 1);
        GettingStartedWithUML2.createAssociation((Type)purchaseOrderClass, true, AggregationKind.NONE_LITERAL, "previousOrder", 0, 1, (Type)purchaseOrderClass, false, AggregationKind.NONE_LITERAL, "", 0, 1);
        GettingStartedWithUML2.createAssociation((Type)purchaseOrderClass, true, AggregationKind.COMPOSITE_LITERAL, "items", 0, -1, (Type)itemClass, true, AggregationKind.NONE_LITERAL, "order", 1, 1);
        GettingStartedWithUML2.createAssociation((Type)purchaseOrderClass, true, AggregationKind.COMPOSITE_LITERAL, "billTo", 1, 1, (Type)addressClass, false, AggregationKind.NONE_LITERAL, "", 1, 1);
        GettingStartedWithUML2.createAssociation((Type)purchaseOrderClass, true, AggregationKind.COMPOSITE_LITERAL, "shipTo", 0, 1, (Type)addressClass, false, AggregationKind.NONE_LITERAL, "", 1, 1);
        GettingStartedWithUML2.out("Saving model...");
        GettingStartedWithUML2.save((Package)epo2Model, URI.createURI((String)args[0]).appendSegment("ExtendedPO2").appendFileExtension("uml2"));
    }
}

